C  **********************************************************************
C  **
C  **  Module Name : refresh_screen
C  **  Module Type : subroutine 
C  **  Description : This SUBROUTINE updates the VT320 screen to
C  **                display the current state of the simulated
C  **                elevator system.
C  **                               
C  **********************************************************************

      SUBROUTINE refresh_screen
         
      INCLUDE 'my.h'
      INTEGER col,row

      DO col=1,80
        DO row=1,25
          IF (last_screen(col,row).ne.new_screen(col,row)) THEN
            CALL send_char(col,row,new_screen(col,row),new_mode(col,row))
            last_screen(col,row)=new_screen(col,row)    
            last_mode(col,row)=new_mode(col,row)    
          END IF
        END DO
      END DO    
                                        
      RETURN
      END

C  **********************************************************************
C  **
C  **  Module Name : update_state
C  **  Module Type : subroutine 
C  **  Description : This SUBROUTINE updates the VT320 screen to
C  **                display the current state of the simulated
C  **                elevator system.
C  **                           
C  **********************************************************************

      SUBROUTINE update_state(car)
             
      INCLUDE 'my.h'
      INCLUDE 'siman.h'                              
      INCLUDE 'var.h'                              
      INCLUDE 'agent.h'                              
  
      real car,tavg
      INTEGER ncol_offset,nrow_offset,icar,ncol
      INTEGER num_in_car,num_waiting,num_riders
      
      ncol_offset = 6
      nrow_offset = 3
                
      DO icar=1,tot_cars
               
        ncol = (14-tot_cars) * icar + ncol_offset
                                            
        CALL write_digit(ncol,nrow_offset,icar)

        IF (state(icar) .EQ. parking ) THEN 
          CALL write_string(ncol-1,nrow_offset+1,'prk',3)
        ELSE IF (state(icar) .EQ. stopped ) THEN
          CALL write_string(ncol-1,nrow_offset+1,'stp',3)
        ELSE IF (state(icar).EQ.moving) THEN
          CALL write_string(ncol-1,nrow_offset+1,'run',3)
        ELSE IF (state(icar) .EQ. loading ) THEN
	  CALL write_string(ncol-1,nrow_offset+1,'ld ',3)	  
        END IF                                  
                                                    
        IF (last_action(icar) .EQ. ISTOP_ACTION) THEN 
          CALL write_string(ncol-1,nrow_offset+4,'stp',3)
        ELSE IF (last_action(icar) .EQ. ICONT_ACTION ) THEN 
          CALL write_string(ncol-1,nrow_offset+4,'cnt',3)
        ELSE IF (last_action(icar) .EQ. IUP_ACTION ) THEN 
          CALL write_string(ncol-1,nrow_offset+4,'up ',3)
        ELSE IF (last_action(icar) .EQ. IDOWN_ACTION ) THEN 
          CALL write_string(ncol-1,nrow_offset+4,'dwn',3)
        ELSE 
          CALL write_string(ncol-1,nrow_offset+4,'???',3)
        END IF                                  
                                                    
        CALL write_bcd(ncol-1,nrow_offset+2,0,FLOAT(num_in_car(icar)))
        CALL write_bcd(ncol-1,nrow_offset+3,1,bload(icar))
                  
      END DO    
                  
      ncol = MIN (66, (5*tot_cars) + 40 + ncol_offset )

      CALL put_time(67,1)    
      CALL write_sim_time(ncol+5,nrow_offset)
      CALL write_bcd(ncol+8,nrow_offset+1,0,float(num_waiting()))
      CALL write_bcd(ncol+8,nrow_offset+2,0,float(num_riders())) 
      CALL write_bcd(ncol+8,nrow_offset+3,1,tavg(1))

      RETURN
      END

c  **********************************************************************
C  **
C  **  Module Name : update_display
C  **  Module Type : subroutine 
C  **  Description : This SUBROUTINE updates the VT320 screen to
C  **                display the current state of the simulated
C  **                elevator system.
C  **                
C  **********************************************************************

      SUBROUTINE update_display

      INCLUDE  'siman.h'
      INCLUDE  'my.h'

      INTEGER ncol_offset,icar,idir,iflr,nrow,ncol,inc,nrowbase,ncolbase 
      INTEGER ntemp,number,nq,ind_up,ind_dn
      REAL flag            
  
      ncol_offset = 6

      DO idir=0,1
        DO icar= 1,tot_cars
          DO iflr=1,tot_flrs
                
            nrow = 22 - iflr     
            IF (idir.eq.1) THEN
              ncol = (14-tot_cars) * icar - 1 + ncol_offset
              inc  = -1
            ELSE
              ncol = (14-tot_cars) * icar + 1 + ncol_offset
              inc  = 1
            END IF 
                       
            nrowbase = nrow 
            ncolbase = ncol + inc*2
                                                    
            IF ( cur_dir(icar).eq.idir.AND.cur_flr(icar).eq.iflr ) THEN
              CALL write_char(ncol,nrow,'a',2)
              ncol = ncol + inc
            END IF  
                                         
            IF (car_calls(icar,idir+1,iflr).GE.0.0 .AND.
     .          hall_calls(icar,idir+1,iflr).GE.0.0) THEN
              CALL write_char(ncol,nrow,'g',2)
              ncol = ncol + inc
            ELSEIF (hall_calls(icar,idir+1,iflr).GE.0.0) THEN
              CALL write_char(ncol,nrow,'+',4)
              ncol = ncol + inc
            ELSEIF (car_calls(icar,idir+1,iflr).GE.0.0) THEN
              CALL write_char(ncol,nrow,'-',4)
              ncol = ncol + inc
            END IF
                                     
            DO ntemp = ncol,ncolbase,inc
              CALL write_char(ntemp,nrow,' ',4)
            END DO
            
            nrow = 22 - iflr     
            IF (idir.eq.1) THEN 
              number = nq(ind_up(iflr))
              ncol = (14-tot_cars) * (tot_cars+2) + 1 + ncol_offset
            ELSE
              number = nq(ind_dn(iflr))
              ncol = (14-tot_cars) * (tot_cars+2) - 1 + ncol_offset
            END IF 

            IF (idir.eq.1) THEN
              ncol = (14-tot_cars) * (tot_cars+2) - 1 + ncol_offset
            ELSE
              ncol = (14-tot_cars) * (tot_cars+2)  + 1 + ncol_offset
            END IF 
                       
            IF (number.eq.0) THEN
              CALL write_char(ncol,nrow,' ',4)
            ELSE IF (number.gt.9) THEN
              CALL write_char(ncol,nrow,'*',4)
            ELSE      
              CALL write_digit(ncol,nrow,number)
            END IF

          END DO
        END DO
      END DO                     
                   
      RETURN
      END 

C  **********************************************************************
C  **
C  **  Module Name : draw_system
C  **  Module Type : subroutine 
C  **  Description : This SUBROUTINE draws the basic elevator system
C  **                on a VT320 screen.
C  **
C  **********************************************************************
               
      SUBROUTINE draw_system
                                 
      REAL cars,floors

      INCLUDE 'my.h'

      INTEGER icol,irow,ncol_offset,nrow_offset,icar,iflr,nrow,ncol

      DO icol=1,80
        DO irow=1,25
          last_screen(icol,irow) = ' '
          new_screen(icol,irow) = ' '
        END DO
      END DO                

      ncol_offset = 6
      nrow_offset = 3       

      DO icar   = 1,tot_cars
        DO iflr = 1,tot_flrs              
          nrow = 22 - iflr
          ncol = (14-tot_cars) * icar + ncol_offset 
          CALL write_char(ncol,nrow,'n',1)
        END DO
      END DO
                   
      DO icar   = 1,tot_cars
        ncol = (14-tot_cars) * icar + ncol_offset 
        CALL write_char(ncol,22-1,'v',1)
        CALL write_char(ncol,22-tot_flrs,'w',1)
      END DO          
                                              
      ncol = (14-tot_cars) * (tot_cars+2) + ncol_offset

      DO iflr = 1,tot_flrs              
        nrow = 22 - iflr
        CALL write_char(ncol,nrow,'n',1)
      END DO

      CALL write_char(ncol,22-1,'v',1)
      CALL write_char(ncol,22-tot_flrs,'w',1)

      ncol = MIN (66, (5*tot_cars) + 40 + ncol_offset )
                                                         
      CALL set_mode(3)
      CALL put_date(5,1)    
      CALL put_time(67,1)    
      CALL write_string(20,1, 'ELEVATOR SYSTEM DISCRETE EVENT SIMULATION',4)
      CALL write_string(ncol-7,nrow_offset+0, 'CLK TIME  :',4)
      CALL write_string(ncol-7,nrow_offset+1, '# WAITING :',4)
      CALL write_string(ncol-7,nrow_offset+2, '# RIDING  :',4)
      CALL write_string(ncol-7,nrow_offset+3, 'AVG WAIT  :',4)
      CALL write_string(2,nrow_offset+0, 'CAR    :',4)
      CALL write_string(2,nrow_offset+1, 'STATE  :',4)
      CALL write_string(2,nrow_offset+2, 'RIDERS :',4)
      CALL write_string(2,nrow_offset+3, 'LOAD   :',4)

      RETURN
      END

C  **********************************************************************
C  **
C  **  Module Name : send_char( ncol, nrow , nchar , mode )
C  **  Module Type : subroutine 
C  **  Description : This SUBROUTINE places 'nchar' at 'nrow'\'ncol' 
C  **                on a VT320 screen.
C  **
C  **********************************************************************

      SUBROUTINE send_char( ncol, nrow , nchar , mode)
      
      INTEGER ncol,nrow,mode
      CHARACTER nchar    
      INCLUDE 'my.h'
      CHARACTER*8 t3        
      INTEGER ny1,ny2,nx1,nx2                       

      CALL set_mode(mode)

      ny1 = int ( nrow / 10 )
      ny2 = int ( nrow - ny1 * 10 )
              
      nx1 = int ( ncol / 10 )
      nx2 = int ( ncol - nx1 * 10 )

      t3=char(27)//'['//char(ny1+ichar('0'))//  
     .char(ny2+ichar('0'))//';'//char(nx1+ichar('0'))//  
     .char(nx2+ichar('0'))//'H'       

      PRINT *, t3, nchar
      
      RETURN
      END 
C  *
C  **********************************************************************
C  *
      SUBROUTINE set_mode(mode) 
                  
      INCLUDE 'my.h'
      INTEGER mode

      CHARACTER*3 graph,text                                               
      CHARACTER*4 bright,dim                                               

      graph  = char(27)//'(0'
      text   = char(27)//'(B'
      bright = char(27)//'[1m'
      dim    = char(27)//'[0m'
C
C  DIM GRAPHICS
C       
      IF (mode.eq.1.AND.gmode.ne.1) THEN 
        PRINT *,dim
        PRINT *,graph
        gmode = 1
      END IF
C
C  BRIGHT GRAPHICS
C
      IF (mode.eq.2.AND.gmode.ne.2) THEN
        PRINT *,bright
        PRINT *,graph
        gmode = 2
      END IF
C
C   DIM TEXT
C
      IF (mode.eq.3.AND.gmode.ne.3) THEN
        PRINT *,dim
        PRINT *,text
        gmode = 3
      END IF
C
C   BRIGHT TEXT
C
      IF (mode.eq.4.AND.gmode.ne.4) THEN
        PRINT *,bright
        PRINT *,graph
        gmode = 4
      END IF

      RETURN
      END

C  **********************************************************************
C  **
C  **  Module Name : write_char( ncol, nrow , nchar , mode )
C  **  Module Type : subroutine 
C  **  Description : This SUBROUTINE places 'nchar' at 'nrow'\'ncol' 
C  **                on a VT320 screen.
C  ** 
C  **********************************************************************

      SUBROUTINE write_char( ncol, nrow , nchar , mode )
                                                       
      INTEGER ncol,nrow,mode 
      INCLUDE 'my.h'

      CHARACTER nchar

      new_screen(ncol,nrow) = nchar
      new_mode(ncol,nrow) = mode 

      RETURN
      END

C  **********************************************************************
C  **
C  **  Module Name : clear_screen
C  **  Module Type : subroutine 
C  **  Description : This SUBROUTINE clears the VT320 screen. 
C  **
C  **********************************************************************

      SUBROUTINE clear_screen

      CHARACTER*6 t1
      CHARACTER*4 t2             
      CHARACTER*7 t3
                    
      t1 = char(27)//'[1;1H'
      t2 = char(27)//'[2J'
      t3 = char(27)//'[1;24r'

      PRINT *, t1
      PRINT *, t2
      PRINT *, t3
 
      RETURN
      END
C
C  **********************************************************************
C
      SUBROUTINE write_digit (ncol,nrow,number) 

      INTEGER ncol,nrow,number
      
      CALL write_char(ncol,nrow,char(number+ichar('0')),3)
      
      RETURN
      END
C
C  **********************************************************************
C
      SUBROUTINE put_time(ncol,nrow)
                              
      INTEGER ncol,nrow
      CHARACTER*8 t3                               
      CHARACTER*8 timestr 

      INTEGER i

c     CALL time(timestr)
      timestr = " No Time "
                  
      DO i=1,len(timestr)
        CALL write_char(ncol-1+i,nrow,timestr(i:i),3)
      END DO

      RETURN
      END
C
C  **********************************************************************
C
      SUBROUTINE put_date(ncol,nrow)
                 
      INTEGER ncol,nrow
      CHARACTER*8 t3                               
      CHARACTER*9 datestr
      INTEGER i          

c     CALL date(datestr)
       datestr = " No Date  "
                    
      DO i=1,len(datestr)
        CALL write_char(ncol-1+i,nrow,datestr(i:i),3)
      END DO

      RETURN
      END
C
C  **********************************************************************
c                      
      INTEGER function num_riders()

      INCLUDE 'my.h'
      INTEGER car,num_in_car

      num_riders = 0
      DO car=1,tot_cars
        num_riders = num_riders + num_in_car(car) 
      END DO
                 
      RETURN  
      END
c
C  **********************************************************************
C
      SUBROUTINE write_sim_time(ncol,nrow)
        
      INTEGER ncol,nrow

      INCLUDE 'siman.h'

      INTEGER thousands,hundreds,tens,units
      INTEGER hours,minutes,seconds,value  
                  
      value = INT(tnow)
      hours = value / 3600  
      value = value - 3600*hours
      minutes = value / 60               
      value = value - 60*minutes
      seconds = value 
      CALL bcd(hours,thousands,hundreds,tens,units)
      CALL write_digit(ncol+0,nrow,tens) 
      CALL write_digit(ncol+1,nrow,units) 
      CALL write_char  (ncol+2,nrow,':',3)
      CALL bcd(minutes,thousands,hundreds,tens,units)
      CALL write_digit(ncol+3,nrow,tens) 
      CALL write_digit(ncol+4,nrow,units) 
      CALL write_char  (ncol+5,nrow,':',3)
      CALL bcd(seconds,thousands,hundreds,tens,units)
      CALL write_digit(ncol+6,nrow,tens) 
      CALL write_digit(ncol+7,nrow,units) 
      
      RETURN  
      END
C
C  **********************************************************************
C
      SUBROUTINE write_string(ncol,nrow,tstring,mode)

      CHARACTER*(*) tstring
      INTEGER nrow,ncol,mode,i
      CHARACTER*8 t3                               

      DO i=1,len(tstring)
        CALL write_char(ncol-1+i,nrow,tstring(i:i),mode)
      END DO

      RETURN
      END
c
c   *****************************************************************
c
      SUBROUTINE bcd(passed_value,thousands,hundreds,tens,units)

      INTEGER passed_value,value,thousands,hundreds,tens,units
               
      value = passed_value
      thousands = 0
      hundreds  = 0
      tens      = 0
      units     = 0

      DO WHILE (value-1000.ge.0)
        value = value-1000
        thousands = thousands + 1
      END DO  

      DO WHILE (value-100.ge.0)
        value = value-100
        hundreds = hundreds + 1
      END DO  

      DO WHILE (value-10.ge.0)
        value = value-10
        tens = tens + 1
      END DO  
                    
      units = value 

      RETURN
      END
c
c   *****************************************************************
c
      SUBROUTINE write_bcd(ncol,nrow,right,passed_value)

      REAL    passed_value  
      INTEGER ncol,nrow,left,right             

      REAL*8    value            
      INTEGER offset,i,digit,my_offset
      LOGICAL start
                                        
      start = .FALSE.
      value = passed_value  
      offset = 4
      my_offset = 0    

      value = value + 0.5 *(10.0**(-1.0*float(right)))
      IF (value.LT.0.0) THEN
        value = 0.0
      END IF

      DO i=5,1,-1         
        digit = 0
        IF (i.EQ.3.AND.right.NE.0) THEN
          CALL write_char(ncol+(5-i)+my_offset,nrow,'.',3)
          start = .TRUE.
          my_offset = 1
        END IF
        DO WHILE (value-10**float((i-offset)).GT.0.0) 
          start = .TRUE.
          digit = digit + 1
          value = value-10**float((i-offset))     
        END DO
        IF (( start.AND.i.GE.offset-right).OR.(i.EQ.offset)) THEN
          CALL write_digit(ncol+(5-i)+my_offset,nrow,digit)
        ELSE
          CALL write_char(ncol+(5-i)+my_offset,nrow,' ',3)
        END IF
      END DO

      RETURN
      END



