/*
 * Decompiled with CFR 0.152.
 */
package com.thierrymasson.qlearner;

import com.thierrymasson.qlearner.QLearning;
import com.thierrymasson.qlearner.mapPanel;
import com.thierrymasson.qlearner.myDecimalField;
import com.thierrymasson.qlearner.myWholeNumberField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;

public class QLearnerDemo
extends JApplet {
    private static final boolean DEBUG = false;
    private JPanel optionsPanel = new JPanel();
    private TitledBorder titledBorder1;
    private QLearning bot;
    private Thread apprentissage;
    private long startTime = 0L;
    private long endTime = 0L;
    private long elapsedTime = 0L;
    private int mapFixe = 600;
    private Dimension mapDim = new Dimension(this.mapFixe, this.mapFixe);
    private String[] availableSizes = new String[]{"10", "15", "20"};
    private ResourceBundle QLDMessages;
    private String OPTIONSStr;
    private String MAPSIZEStr;
    private String CARTEStr;
    private String ITERATIONSStr;
    private String LEARNINGRATEStr;
    private String EXPLORATIONStr;
    private String AMORTISSEMENTStr;
    private String APPRENDREStr;
    private String PENALITEStr;
    private String RECOMPENSEStr;
    private String DEGRESSIFStr;
    private String ITERATIONS_TT_Str;
    private String EXPLORATION_TT_Str;
    private String LEARNINGRATE_TT_Str;
    private String RECOMPENSE_TT_Str;
    private String AMORTISSEMENT_TT_Str;
    private String PENALITE_TT_Str;
    private String APPRENTISSAGE_TT_Str;
    private String DEGRESSIF_TT_Str;
    private String TAILLECARTE_TT_STr;
    private String PROGRESSIONStr;
    private JLabel mapSizeL = new JLabel();
    private mapPanel mapP = new mapPanel();
    private TitledBorder titledBorder2;
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private FlowLayout flowLayout1 = new FlowLayout();
    private JComboBox mapSizeCB = new JComboBox<String>(this.availableSizes);
    private JLabel IterationsL = new JLabel();
    private myWholeNumberField iterMaxTF = new myWholeNumberField(8);
    private JLabel exploreL = new JLabel();
    private myDecimalField exploreTF = new myDecimalField(4, NumberFormat.getNumberInstance());
    private JLabel learnRateL = new JLabel();
    private myDecimalField apprentTF = new myDecimalField(4, NumberFormat.getNumberInstance());
    private JLabel AmortissementL = new JLabel();
    private JButton learnB = new JButton();
    private myDecimalField amortTF = new myDecimalField(4, NumberFormat.getNumberInstance());
    private JLabel penalL = new JLabel();
    private myDecimalField penalTF = new myDecimalField(6, NumberFormat.getNumberInstance());
    private JLabel recompL = new JLabel();
    private myDecimalField recompTF = new myDecimalField(6, NumberFormat.getNumberInstance());
    private JCheckBox decreaseLearnCheck = new JCheckBox();
    private Timer appTimer;
    private JProgressBar appPB;
    private JFrame pbf;
    ActionListener appSurv = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            long cI = QLearnerDemo.this.bot.getCurrentIter();
            if (cI < QLearnerDemo.this.bot.getIterMax() - (long)1) {
                QLearnerDemo.this.appPB.setValue((int)cI);
            } else {
                QLearnerDemo.this.appTimer.stop();
                QLearnerDemo.this.endTime = System.currentTimeMillis();
                QLearnerDemo.this.elapsedTime = QLearnerDemo.this.endTime - QLearnerDemo.this.startTime;
                QLearnerDemo.this.appPB.setValue(0);
                QLearnerDemo.this.appPB.setVisible(false);
                QLearnerDemo.this.pbf.dispose();
                QLearnerDemo.this.learnB.setEnabled(true);
                QLearnerDemo.this.mapP.setMapDef(QLearnerDemo.this.bot.giveResMap());
                QLearnerDemo.this.mapP.setTargetHits(QLearnerDemo.this.bot.getTargetHits());
                QLearnerDemo.this.mapP.setElapsedTime(QLearnerDemo.this.elapsedTime);
                QLearnerDemo.this.mapP.repaint();
            }
        }
    };

    public QLearnerDemo() throws HeadlessException {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("");
        this.titledBorder2 = new TitledBorder("");
        this.optionsPanel.setBackground(new Color(236, 233, 217));
        this.optionsPanel.setBorder(this.titledBorder1);
        this.optionsPanel.setMaximumSize(new Dimension(600, 100));
        this.optionsPanel.setMinimumSize(new Dimension(600, 100));
        this.optionsPanel.setPreferredSize(new Dimension(600, 100));
        this.optionsPanel.setLayout(this.flowLayout1);
        this.mapSizeL.setFont(new Font("Dialog", 0, 10));
        this.mapP.setBackground(new Color(236, 233, 217));
        this.mapP.setBorder(this.titledBorder2);
        this.mapP.setMaximumSize(this.mapDim);
        this.mapP.setMinimumSize(this.mapDim);
        this.mapP.setPreferredSize(this.mapDim);
        this.mapP.setLayout(this.gridBagLayout2);
        this.mapSizeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QLearnerDemo.this.mapSizeCB_actionPerformed(e);
            }
        });
        this.IterationsL.setFont(new Font("Dialog", 0, 10));
        this.iterMaxTF.setMinimumSize(new Dimension(60, 21));
        this.iterMaxTF.setPreferredSize(new Dimension(60, 21));
        this.iterMaxTF.setValue(5000000);
        this.exploreL.setFont(new Font("Dialog", 0, 10));
        this.exploreTF.setMinimumSize(new Dimension(35, 21));
        this.exploreTF.setPreferredSize(new Dimension(35, 21));
        this.exploreTF.setValue(0.8);
        this.learnRateL.setFont(new Font("Dialog", 0, 10));
        this.apprentTF.setMinimumSize(new Dimension(35, 21));
        this.apprentTF.setPreferredSize(new Dimension(35, 21));
        this.apprentTF.setValue(0.05);
        this.AmortissementL.setFont(new Font("Dialog", 0, 10));
        this.learnB.setBackground(Color.blue);
        this.learnB.setEnabled(false);
        this.learnB.setForeground(Color.yellow);
        this.learnB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QLearnerDemo.this.learnB_actionPerformed(e);
            }
        });
        this.amortTF.setValue(0.9);
        this.penalL.setFont(new Font("Dialog", 0, 10));
        this.penalTF.setValue(-5000.0);
        this.recompL.setFont(new Font("Dialog", 0, 10));
        this.recompTF.setValue(1000.0);
        this.decreaseLearnCheck.setBackground(new Color(236, 233, 217));
        this.decreaseLearnCheck.setFont(new Font("Dialog", 0, 10));
        this.decreaseLearnCheck.setHorizontalTextPosition(2);
        this.decreaseLearnCheck.setSelected(true);
        this.mapSizeCB.setBackground(new Color(236, 233, 217));
        this.optionsPanel.add((Component)this.mapSizeL, null);
        this.optionsPanel.add((Component)this.mapSizeCB, null);
        this.optionsPanel.add((Component)this.IterationsL, null);
        this.optionsPanel.add((Component)this.iterMaxTF, null);
        this.optionsPanel.add((Component)this.exploreL, null);
        this.optionsPanel.add((Component)this.exploreTF, null);
        this.optionsPanel.add((Component)this.learnRateL, null);
        this.getContentPane().setName("com.thierrymasson.qlearner.QLearnerDemo.class");
        this.getContentPane().add((Component)this.mapP, "Center");
        this.getContentPane().add((Component)this.optionsPanel, "North");
        this.optionsPanel.add((Component)this.apprentTF, null);
        this.optionsPanel.add((Component)this.decreaseLearnCheck, null);
        this.optionsPanel.add((Component)this.AmortissementL, null);
        this.optionsPanel.add((Component)this.amortTF, null);
        this.optionsPanel.add((Component)this.penalL, null);
        this.optionsPanel.add((Component)this.penalTF, null);
        this.optionsPanel.add((Component)this.recompL, null);
        this.optionsPanel.add((Component)this.recompTF, null);
        this.optionsPanel.add((Component)this.learnB, null);
    }

    public void init() {
        System.err.println("|------------------------------------------------------------|");
        System.err.println("| com.thierrymasson.qlearner.QLearnerDemo par Thierry MASSON |");
        System.err.println("| (c) 2002 Thierry MASSON                                    |");
        System.err.println("| Applet de d\u00e9monstration de l'algorithme de Q-Learning.     |");
        System.err.println("| Apprentissage non supervis\u00e9, par renforcement.             |");
        System.err.println("| Contact -> mailto:thierry.masson@free.fr                   |");
        System.err.println("| -----------------------------------------------------------|");
        String laLangue = this.getParameter("lang");
        Locale laLocale = new Locale(laLangue);
        this.QLDMessages = ResourceBundle.getBundle("com.thierrymasson.qlearner.QLD", laLocale);
        this.OPTIONSStr = this.QLDMessages.getString("OPTIONSStr");
        this.MAPSIZEStr = this.QLDMessages.getString("MAPSIZEStr");
        this.CARTEStr = this.QLDMessages.getString("CARTEStr");
        this.ITERATIONSStr = this.QLDMessages.getString("ITERATIONSStr");
        this.LEARNINGRATEStr = this.QLDMessages.getString("LEARNINGRATEStr");
        this.EXPLORATIONStr = this.QLDMessages.getString("EXPLORATIONStr");
        this.AMORTISSEMENTStr = this.QLDMessages.getString("AMORTISSEMENTStr");
        this.APPRENDREStr = this.QLDMessages.getString("APPRENDREStr");
        this.PENALITEStr = this.QLDMessages.getString("PENALITEStr");
        this.RECOMPENSEStr = this.QLDMessages.getString("RECOMPENSEStr");
        this.DEGRESSIFStr = this.QLDMessages.getString("DEGRESSIFStr");
        this.ITERATIONS_TT_Str = this.QLDMessages.getString("ITERATIONS_TT_Str");
        this.EXPLORATION_TT_Str = this.QLDMessages.getString("EXPLORATION_TT_Str");
        this.LEARNINGRATE_TT_Str = this.QLDMessages.getString("LEARNINGRATE_TT_Str");
        this.RECOMPENSE_TT_Str = this.QLDMessages.getString("RECOMPENSE_TT_Str");
        this.AMORTISSEMENT_TT_Str = this.QLDMessages.getString("AMORTISSEMENT_TT_Str");
        this.PENALITE_TT_Str = this.QLDMessages.getString("PENALITE_TT_Str");
        this.APPRENTISSAGE_TT_Str = this.QLDMessages.getString("APPRENTISSAGE_TT_Str");
        this.DEGRESSIF_TT_Str = this.QLDMessages.getString("DEGRESSIF_TT_Str");
        this.TAILLECARTE_TT_STr = this.QLDMessages.getString("TAILLECARTE_TT_Str");
        this.PROGRESSIONStr = this.QLDMessages.getString("PROGRESSIONStr");
        this.titledBorder1.setTitleColor(Color.blue);
        this.titledBorder2.setTitleColor(Color.blue);
        this.titledBorder1.setTitle(this.OPTIONSStr);
        this.titledBorder2.setTitle(this.CARTEStr);
        this.mapSizeL.setText(this.MAPSIZEStr);
        this.IterationsL.setText(this.ITERATIONSStr);
        this.iterMaxTF.setToolTipText(this.ITERATIONS_TT_Str);
        this.exploreL.setText(this.EXPLORATIONStr);
        this.exploreTF.setToolTipText(this.EXPLORATION_TT_Str);
        this.learnRateL.setText(this.LEARNINGRATEStr);
        this.amortTF.setToolTipText(this.AMORTISSEMENT_TT_Str);
        this.penalL.setText(this.PENALITEStr);
        this.penalTF.setToolTipText(this.PENALITE_TT_Str);
        this.recompL.setText(this.RECOMPENSEStr);
        this.recompTF.setToolTipText(this.RECOMPENSE_TT_Str);
        this.learnB.setToolTipText(this.APPRENTISSAGE_TT_Str);
        this.learnB.setText(this.APPRENDREStr);
        this.mapSizeCB.setToolTipText(this.TAILLECARTE_TT_STr);
        this.decreaseLearnCheck.setText(this.DEGRESSIFStr);
        this.decreaseLearnCheck.setToolTipText(this.DEGRESSIF_TT_Str);
        this.AmortissementL.setText(this.AMORTISSEMENTStr);
        this.apprentTF.setToolTipText(this.LEARNINGRATE_TT_Str);
        this.mapP.setLang(laLangue);
    }

    public void start() {
    }

    void mapSizeCB_actionPerformed(ActionEvent e) {
        Integer whichSize = new Integer((String)this.mapSizeCB.getSelectedItem());
        this.mapP.setBlocks(whichSize);
        this.mapP.repaint();
        this.learnB.setEnabled(true);
    }

    void learnB_actionPerformed(ActionEvent e) {
        this.mapP.cleanMap();
        try {
            long iM = this.iterMaxTF.getValue();
            double ex = this.exploreTF.getValue();
            double am = this.amortTF.getValue();
            double p = this.penalTF.getValue();
            double r = this.recompTF.getValue();
            double ap = this.apprentTF.getValue();
            int mapSize = new Integer((String)this.mapSizeCB.getSelectedItem());
            boolean dec_a = this.decreaseLearnCheck.isSelected();
            this.bot = new QLearning(iM, ex, am, r, p, ap, mapSize, this.mapP.getMapDef(), dec_a);
            this.appPB = new JProgressBar(0, (int)iM);
            this.appPB.setValue(0);
            this.appPB.setStringPainted(true);
            this.appPB.setBorder(BorderFactory.createEtchedBorder());
            this.appPB.setBorderPainted(true);
            this.appPB.setSize(new Dimension(150, 85));
            this.appPB.setMaximumSize(new Dimension(150, 85));
            this.pbf = new JFrame(this.PROGRESSIONStr);
            this.pbf.setSize(new Dimension(400, 85));
            this.pbf.setLocation(this.mapP.getLocationOnScreen());
            this.pbf.getContentPane().add(this.appPB);
            this.pbf.show();
            this.learnB.setEnabled(false);
            this.apprentissage = new Thread(this.bot);
            this.appTimer = new Timer(0, this.appSurv);
            this.startTime = System.currentTimeMillis();
            this.apprentissage.start();
            this.appTimer.start();
        }
        catch (Exception anyex) {
            anyex.printStackTrace();
        }
    }

    static {
        DEBUG = false;
    }
}

