/*
 * Decompiled with CFR 0.152.
 */
package com.thierrymasson.qlearner;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class mapPanel
extends JPanel {
    boolean DEBUG = false;
    boolean hitsReceived = false;
    boolean elapsedTimeReceived = false;
    int[][] mapDef;
    int recS = 50;
    int halfRec = (this.recS - 2) / 2;
    int tiersRec = (this.recS - 2) / 3;
    int transparence = 70;
    Color couleurCaseNormale = Color.GRAY;
    Color couleurCaseDanger = Color.RED;
    Color couleurCaseCible = Color.GREEN;
    Color couleurCaseNormaleT = new Color(128, 128, 128, this.transparence);
    Color couleurCaseCibleT = new Color(0, 255, 0, this.transparence);
    Color couleurCaseDangerT = new Color(255, 0, 0, this.transparence);
    Color couleurRobot = Color.WHITE;
    Color couleurFleche = Color.BLACK;
    Color couleurTexte = Color.BLACK;
    int blocksN = 10;
    int decal = 100;
    int xc;
    int yc;
    int[] xp = new int[3];
    int[] yp = new int[3];
    int targetHits;
    long elapsedTime;
    private String targetHitsStr;
    private String targetHitsCompStr;
    private String elapsedTimeStr;
    private String elapsedTimeUnitStr;

    public void setLang(String laLangue) {
        Locale laLocale = new Locale(laLangue);
        ResourceBundle QLDMessages = ResourceBundle.getBundle("com.thierrymasson.qlearner.QLD", laLocale);
        this.targetHitsStr = QLDMessages.getString("targetHitsStr");
        this.targetHitsCompStr = QLDMessages.getString("targetHitsCompStr");
        this.elapsedTimeStr = QLDMessages.getString("elapsedTimeStr");
        this.elapsedTimeUnitStr = QLDMessages.getString("elapsedTimeUnitStr");
    }

    public void setBlocks(int blocksNum) {
        this.mapDef = new int[blocksNum][blocksNum];
        for (int i = 0; i < blocksNum; ++i) {
            for (int j = 0; j < blocksNum; ++j) {
                this.mapDef[i][j] = 0;
            }
        }
        this.blocksN = blocksNum;
        this.recS = 500 / blocksNum;
        this.halfRec = (this.recS - 2) / 2;
        this.tiersRec = (this.recS - 2) / 3;
        this.targetHits = 0;
        this.elapsedTime = 0L;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                if (mapPanel.this.DEBUG) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("click \u00e0 :").append(x).append(" , ").append(y))));
                }
                int relx = x - mapPanel.this.decal - 2;
                int rely = y - mapPanel.this.decal - 2;
                int iflag = relx / mapPanel.this.recS;
                int jflag = rely / mapPanel.this.recS;
                int flag = 0;
                if (iflag >= 0 && iflag < mapPanel.this.blocksN && jflag >= 0 && jflag < mapPanel.this.blocksN) {
                    switch (e.getButton()) {
                        case 1: {
                            flag = 1;
                            break;
                        }
                        case 2: {
                            flag = 0;
                            break;
                        }
                        case 3: {
                            flag = 2;
                        }
                    }
                    mapPanel.this.mapDef[jflag][iflag] = flag;
                }
                mapPanel.this.repaint();
            }
        });
    }

    public void paintComponent(Graphics g) {
        g.setColor(new Color(236, 233, 217));
        super.paintComponent(g);
        if (this.mapDef != null) {
            boolean robPresence = false;
            for (int i = 0; i < this.blocksN; ++i) {
                this.yc = this.decal + 2 + i * this.recS + this.halfRec;
                block18: for (int j = 0; j < this.blocksN; ++j) {
                    this.xc = this.decal + 2 + j * this.recS + this.halfRec;
                    switch (this.mapDef[i][j]) {
                        case 0: {
                            g.setColor(this.couleurCaseNormale);
                            g.fillRect(this.decal + 2 + j * this.recS, this.decal + 2 + i * this.recS, this.recS - 2, this.recS - 2);
                            continue block18;
                        }
                        case 1: {
                            g.setColor(this.couleurCaseDanger);
                            g.fillRect(this.decal + 2 + j * this.recS, this.decal + 2 + i * this.recS, this.recS - 2, this.recS - 2);
                            continue block18;
                        }
                        case 2: {
                            g.setColor(this.couleurCaseCible);
                            g.fillRect(this.decal + 2 + j * this.recS, this.decal + 2 + i * this.recS, this.recS - 2, this.recS - 2);
                            continue block18;
                        }
                        case 100: {
                            g.setColor(this.couleurCaseNormaleT);
                            g.fillRect(this.decal + 2 + j * this.recS, this.decal + 2 + i * this.recS, this.recS - 2, this.recS - 2);
                            g.setColor(this.couleurFleche);
                            g.drawLine(this.xc, this.yc, this.xc, this.yc - this.recS + 3);
                            this.xp[0] = this.xc;
                            this.xp[1] = this.xc - 3;
                            this.xp[2] = this.xc + 3;
                            this.yp[0] = this.yc - this.recS + 3;
                            this.yp[1] = this.yc - this.recS + 8;
                            this.yp[2] = this.yc - this.recS + 8;
                            g.fillPolygon(this.xp, this.yp, 3);
                            continue block18;
                        }
                        case 101: {
                            g.setColor(this.couleurCaseDangerT);
                            g.fillRect(this.decal + 2 + j * this.recS, this.decal + 2 + i * this.recS, this.recS - 2, this.recS - 2);
                            g.setColor(this.couleurFleche);
                            g.drawLine(this.xc, this.yc, this.xc, this.yc - this.recS + 3);
                            this.xp[0] = this.xc;
                            this.xp[1] = this.xc - 3;
                            this.xp[2] = this.xc + 3;
                            this.yp[0] = this.yc - this.recS + 3;
                            this.yp[1] = this.yc - this.recS + 8;
                            this.yp[2] = this.yc - this.recS + 8;
                            g.fillPolygon(this.xp, this.yp, 3);
                            continue block18;
                        }
                        case 102: {
                            g.setColor(this.couleurCaseCibleT);
                            g.fillRect(this.decal + 2 + j * this.recS, this.decal + 2 + i * this.recS, this.recS - 2, this.recS - 2);
                            continue block18;
                        }
                        case 200: {
                            g.setColor(this.couleurCaseNormaleT);
                            g.fillRect(this.decal + 2 + j * this.recS, this.decal + 2 + i * this.recS, this.recS - 2, this.recS - 2);
                            g.setColor(this.couleurFleche);
                            g.drawLine(this.xc, this.yc, this.xc + this.recS - 3, this.yc);
                            this.xp[0] = this.xc + this.recS - 3;
                            this.xp[1] = this.xc + this.recS - 8;
                            this.xp[2] = this.xc + this.recS - 8;
                            this.yp[0] = this.yc;
                            this.yp[1] = this.yc - 3;
                            this.yp[2] = this.yc + 3;
                            g.fillPolygon(this.xp, this.yp, 3);
                            continue block18;
                        }
                        case 201: {
                            g.setColor(this.couleurCaseDangerT);
                            g.fillRect(this.decal + 2 + j * this.recS, this.decal + 2 + i * this.recS, this.recS - 2, this.recS - 2);
                            g.setColor(this.couleurFleche);
                            g.drawLine(this.xc, this.yc, this.xc + this.recS - 3, this.yc);
                            this.xp[0] = this.xc + this.recS - 3;
                            this.xp[1] = this.xc + this.recS - 8;
                            this.xp[2] = this.xc + this.recS - 8;
                            this.yp[0] = this.yc;
                            this.yp[1] = this.yc - 3;
                            this.yp[2] = this.yc + 3;
                            g.fillPolygon(this.xp, this.yp, 3);
                            continue block18;
                        }
                        case 202: {
                            g.setColor(this.couleurCaseCibleT);
                            g.fillRect(this.decal + 2 + j * this.recS, this.decal + 2 + i * this.recS, this.recS - 2, this.recS - 2);
                            continue block18;
                        }
                        case 300: {
                            g.setColor(this.couleurCaseNormaleT);
                            g.fillRect(this.decal + 2 + j * this.recS, this.decal + 2 + i * this.recS, this.recS - 2, this.recS - 2);
                            g.setColor(this.couleurFleche);
                            g.drawLine(this.xc, this.yc, this.xc, this.yc + this.recS - 3);
                            this.xp[0] = this.xc;
                            this.xp[1] = this.xc - 3;
                            this.xp[2] = this.xc + 3;
                            this.yp[0] = this.yc + this.recS - 3;
                            this.yp[1] = this.yc + this.recS - 8;
                            this.yp[2] = this.yc + this.recS - 8;
                            g.fillPolygon(this.xp, this.yp, 3);
                            continue block18;
                        }
                        case 301: {
                            g.setColor(this.couleurCaseDangerT);
                            g.fillRect(this.decal + 2 + j * this.recS, this.decal + 2 + i * this.recS, this.recS - 2, this.recS - 2);
                            g.setColor(this.couleurFleche);
                            g.drawLine(this.xc, this.yc, this.xc, this.yc + this.recS - 3);
                            this.xp[0] = this.xc;
                            this.xp[1] = this.xc - 3;
                            this.xp[2] = this.xc + 3;
                            this.yp[0] = this.yc + this.recS - 3;
                            this.yp[1] = this.yc + this.recS - 8;
                            this.yp[2] = this.yc + this.recS - 8;
                            g.fillPolygon(this.xp, this.yp, 3);
                            continue block18;
                        }
                        case 302: {
                            g.setColor(this.couleurCaseCibleT);
                            g.fillRect(this.decal + 2 + j * this.recS, this.decal + 2 + i * this.recS, this.recS - 2, this.recS - 2);
                            continue block18;
                        }
                        case 400: {
                            g.setColor(this.couleurCaseNormaleT);
                            g.fillRect(this.decal + 2 + j * this.recS, this.decal + 2 + i * this.recS, this.recS - 2, this.recS - 2);
                            g.setColor(this.couleurFleche);
                            g.drawLine(this.xc, this.yc, this.xc - this.recS + 3, this.yc);
                            this.xp[0] = this.xc - this.recS + 3;
                            this.xp[1] = this.xc - this.recS + 8;
                            this.xp[2] = this.xc - this.recS + 8;
                            this.yp[0] = this.yc;
                            this.yp[1] = this.yc + 3;
                            this.yp[2] = this.yc - 3;
                            g.fillPolygon(this.xp, this.yp, 3);
                            continue block18;
                        }
                        case 401: {
                            g.setColor(this.couleurCaseDangerT);
                            g.fillRect(this.decal + 2 + j * this.recS, this.decal + 2 + i * this.recS, this.recS - 2, this.recS - 2);
                            g.setColor(this.couleurFleche);
                            g.drawLine(this.xc, this.yc, this.xc - this.recS + 3, this.yc);
                            this.xp[0] = this.xc - this.recS + 3;
                            this.xp[1] = this.xc - this.recS + 8;
                            this.xp[2] = this.xc - this.recS + 8;
                            this.yp[0] = this.yc;
                            this.yp[1] = this.yc + 3;
                            this.yp[2] = this.yc - 3;
                            g.fillPolygon(this.xp, this.yp, 3);
                            continue block18;
                        }
                        case 402: {
                            g.setColor(this.couleurCaseCibleT);
                            g.fillRect(this.decal + 2 + j * this.recS, this.decal + 2 + i * this.recS, this.recS - 2, this.recS - 2);
                        }
                    }
                }
                if (this.hitsReceived) {
                    g.setColor(this.couleurTexte);
                    g.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.targetHitsStr))).append(" ").append(this.targetHits).append(" ").append(this.targetHitsCompStr))), 400, 650);
                }
                if (!this.elapsedTimeReceived) continue;
                g.setColor(this.couleurTexte);
                g.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.elapsedTimeStr))).append(" ").append((double)this.elapsedTime / 1000.0).append(" ").append(this.elapsedTimeUnitStr))), 400, 665);
            }
        }
    }

    public int[][] getMapDef() {
        return this.mapDef;
    }

    public void setMapDef(int[][] givenMap) {
        this.mapDef = givenMap;
    }

    public int getMapDefCell(int row, int col) {
        return this.mapDef[row][col];
    }

    public void updateMapDef(int row, int col, int value) {
        this.mapDef[row][col] = value;
    }

    public void dumpMap() {
        for (int i = 0; i < this.blocksN; ++i) {
            for (int j = 0; j < this.blocksN; ++j) {
                System.err.print(String.valueOf(String.valueOf(this.mapDef[i][j])).concat("-"));
            }
            System.err.println("*");
        }
    }

    public void cleanMap() {
        for (int i = 0; i < this.blocksN; ++i) {
            for (int j = 0; j < this.blocksN; ++j) {
                this.mapDef[i][j] = this.mapDef[i][j] % 100;
            }
        }
        this.hitsReceived = false;
    }

    public void setTargetHits(int value) {
        this.targetHits = value;
        this.hitsReceived = true;
    }

    public void setElapsedTime(long value) {
        this.elapsedTime = value;
        this.elapsedTimeReceived = true;
    }
}

