package com.thierrymasson.qlearner;

import javax.swing.*;
import java.awt.*;
import javax.swing.border.*;
import java.lang.String;
import java.awt.event.*;
import java.text.*;

import java.util.Locale;
import java.util.ResourceBundle;

/**
 * <p>Title: Q - Learner</p>
 * <p>Description: Applet de dmonstration de Q-Learning</p>
 * <p>Copyright: Copyright (c) 2002 Thierry MASSON</p>
 * <p>Company: </p>
 * @author Thierry MASSON
 * @version 1.1
 */

public class QLearnerDemo extends JApplet {

  private static final boolean DEBUG=false;

  private JPanel optionsPanel = new JPanel();
  private TitledBorder titledBorder1;
  private QLearning bot;
  private Thread apprentissage;

  private long startTime=0;
  private long endTime=0;
  private long elapsedTime=0;

 //non swing
  private int mapFixe =600;
  private Dimension mapDim = new Dimension(mapFixe,mapFixe);
  private String availableSizes[]={"10","15","20"};

  private ResourceBundle QLDMessages;

  //Messages localiss
  //LABELS
  private String OPTIONSStr;
  private String MAPSIZEStr;
  private String CARTEStr;
  private String ITERATIONSStr;
  private String LEARNINGRATEStr;
  private String EXPLORATIONStr;
  private String AMORTISSEMENTStr;
  private String APPRENDREStr;
  private String PENALITEStr;
  private String RECOMPENSEStr;
  private String DEGRESSIFStr;
  //TOOLTIPSTEXT
  private String ITERATIONS_TT_Str;
  private String EXPLORATION_TT_Str;
  private String LEARNINGRATE_TT_Str;
  private String RECOMPENSE_TT_Str;
  private String AMORTISSEMENT_TT_Str;
  private String PENALITE_TT_Str;
  private String APPRENTISSAGE_TT_Str;
  private String DEGRESSIF_TT_Str;
  private String TAILLECARTE_TT_STr;
  private String PROGRESSIONStr;

  //-----------------------------------------------

  private JLabel mapSizeL = new JLabel();
  private mapPanel mapP= new mapPanel();
  private TitledBorder titledBorder2;
  private GridBagLayout gridBagLayout2 = new GridBagLayout();
  private FlowLayout flowLayout1 = new FlowLayout();
  private JComboBox mapSizeCB = new JComboBox(availableSizes);
  private JLabel IterationsL = new JLabel();
  private myWholeNumberField iterMaxTF = new myWholeNumberField(8);
  private JLabel exploreL = new JLabel();
  private myDecimalField exploreTF = new myDecimalField(4,NumberFormat.getNumberInstance());
  private JLabel learnRateL = new JLabel();
  private myDecimalField apprentTF = new myDecimalField(4,NumberFormat.getNumberInstance());
  private JLabel AmortissementL = new JLabel();
  private JButton learnB = new JButton();
  private myDecimalField amortTF = new myDecimalField(4,NumberFormat.getNumberInstance());
  private JLabel penalL = new JLabel();
  private myDecimalField penalTF = new myDecimalField(6,NumberFormat.getNumberInstance());
  private JLabel recompL = new JLabel();
  private myDecimalField recompTF = new myDecimalField(6,NumberFormat.getNumberInstance());
  private JCheckBox decreaseLearnCheck = new JCheckBox();
  private Timer appTimer;
  private JProgressBar appPB;
  private JFrame pbf;

  public QLearnerDemo() throws HeadlessException {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  private void jbInit() throws Exception {

    titledBorder1 = new TitledBorder("");
    titledBorder2 = new TitledBorder("");
    optionsPanel.setBackground(new Color(236, 233, 217));
    optionsPanel.setBorder(titledBorder1);
    optionsPanel.setMaximumSize(new Dimension(600, 100));
    optionsPanel.setMinimumSize(new Dimension(600, 100));
    optionsPanel.setPreferredSize(new Dimension(600, 100));
    optionsPanel.setLayout(flowLayout1);
    mapSizeL.setFont(new java.awt.Font("Dialog", 0, 10));

    mapP.setBackground(new Color(236, 233, 217));
    mapP.setBorder(titledBorder2);
    mapP.setMaximumSize(mapDim);
    mapP.setMinimumSize(mapDim);
    mapP.setPreferredSize(mapDim);
    mapP.setLayout(gridBagLayout2);

    mapSizeCB.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        mapSizeCB_actionPerformed(e);
      }
    });

    IterationsL.setFont(new java.awt.Font("Dialog", 0, 10));
    iterMaxTF.setMinimumSize(new Dimension(60, 21));
    iterMaxTF.setPreferredSize(new Dimension(60, 21));
    iterMaxTF.setValue(5000000);
    exploreL.setFont(new java.awt.Font("Dialog", 0, 10));
    exploreTF.setMinimumSize(new Dimension(35, 21));
    exploreTF.setPreferredSize(new Dimension(35, 21));
    exploreTF.setValue(0.80);
    learnRateL.setFont(new java.awt.Font("Dialog", 0, 10));
    apprentTF.setMinimumSize(new Dimension(35, 21));
    apprentTF.setPreferredSize(new Dimension(35, 21));
    apprentTF.setValue(0.05);
    AmortissementL.setFont(new java.awt.Font("Dialog", 0, 10));
    learnB.setBackground(Color.blue);
    learnB.setEnabled(false);
    learnB.setForeground(Color.yellow);


    learnB.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        learnB_actionPerformed(e);
      }
    });

    amortTF.setValue(0.90);
    penalL.setFont(new java.awt.Font("Dialog", 0, 10));
    penalTF.setValue(-5000.0);
    recompL.setFont(new java.awt.Font("Dialog", 0, 10));
    recompTF.setValue(1000.0);
    decreaseLearnCheck.setBackground(new Color(236, 233, 217));
    decreaseLearnCheck.setFont(new java.awt.Font("Dialog", 0, 10));
    decreaseLearnCheck.setHorizontalTextPosition(SwingConstants.LEFT);
    decreaseLearnCheck.setSelected(true);
    mapSizeCB.setBackground(new Color(236, 233, 217));
    optionsPanel.add(mapSizeL, null);
    optionsPanel.add(mapSizeCB, null);
    optionsPanel.add(IterationsL, null);
    optionsPanel.add(iterMaxTF, null);
    optionsPanel.add(exploreL, null);
    optionsPanel.add(exploreTF, null);
    optionsPanel.add(learnRateL, null);
    this.getContentPane().setName("com.thierrymasson.qlearner.QLearnerDemo.class");
    this.getContentPane().add(mapP, BorderLayout.CENTER);
    this.getContentPane().add(optionsPanel, BorderLayout.NORTH);
    optionsPanel.add(apprentTF, null);
    optionsPanel.add(decreaseLearnCheck, null);
    optionsPanel.add(AmortissementL, null);
    optionsPanel.add(amortTF, null);
    optionsPanel.add(penalL, null);
    optionsPanel.add(penalTF, null);
    optionsPanel.add(recompL, null);
    optionsPanel.add(recompTF, null);
    optionsPanel.add(learnB, null);
  }
  //----------------------------------------------------------------------------
  public void init()
  {
    System.err.println("|------------------------------------------------------------|");
    System.err.println("| com.thierrymasson.qlearner.QLearnerDemo par Thierry MASSON |");
    System.err.println("| (c) 2002 Thierry MASSON                                    |");
    System.err.println("| Applet de dmonstration de l'algorithme de Q-Learning.     |");
    System.err.println("| Apprentissage non supervis, par renforcement.             |");
    System.err.println("| Contact -> mailto:thierry.masson@free.fr                   |");
    System.err.println("| -----------------------------------------------------------|");

    String laLangue=getParameter("lang");
    Locale laLocale=new Locale(laLangue);
    QLDMessages=ResourceBundle.getBundle("com.thierrymasson.qlearner.QLD",laLocale);

    OPTIONSStr=QLDMessages.getString("OPTIONSStr");
    MAPSIZEStr=QLDMessages.getString("MAPSIZEStr");
    CARTEStr=QLDMessages.getString("CARTEStr");
    ITERATIONSStr=QLDMessages.getString("ITERATIONSStr");
    LEARNINGRATEStr=QLDMessages.getString("LEARNINGRATEStr");
    EXPLORATIONStr=QLDMessages.getString("EXPLORATIONStr");
    AMORTISSEMENTStr=QLDMessages.getString("AMORTISSEMENTStr");
    APPRENDREStr=QLDMessages.getString("APPRENDREStr");
    PENALITEStr=QLDMessages.getString("PENALITEStr");
    RECOMPENSEStr=QLDMessages.getString("RECOMPENSEStr");
    DEGRESSIFStr=QLDMessages.getString("DEGRESSIFStr");

    //TOOLTIPSTEXT
    ITERATIONS_TT_Str=QLDMessages.getString("ITERATIONS_TT_Str");
    EXPLORATION_TT_Str=QLDMessages.getString("EXPLORATION_TT_Str");
    LEARNINGRATE_TT_Str=QLDMessages.getString("LEARNINGRATE_TT_Str");
    RECOMPENSE_TT_Str=QLDMessages.getString("RECOMPENSE_TT_Str");
    AMORTISSEMENT_TT_Str=QLDMessages.getString("AMORTISSEMENT_TT_Str");
    PENALITE_TT_Str=QLDMessages.getString("PENALITE_TT_Str");
    APPRENTISSAGE_TT_Str=QLDMessages.getString("APPRENTISSAGE_TT_Str");
    DEGRESSIF_TT_Str=QLDMessages.getString("DEGRESSIF_TT_Str");
    TAILLECARTE_TT_STr=QLDMessages.getString("TAILLECARTE_TT_Str");
    PROGRESSIONStr=QLDMessages.getString("PROGRESSIONStr");


    titledBorder1.setTitleColor(Color.blue);
    titledBorder2.setTitleColor(Color.blue);
    titledBorder1.setTitle(OPTIONSStr);
    titledBorder2.setTitle(CARTEStr);
    mapSizeL.setText(MAPSIZEStr);
    IterationsL.setText(ITERATIONSStr);
    iterMaxTF.setToolTipText(ITERATIONS_TT_Str);
    exploreL.setText(EXPLORATIONStr);
    exploreTF.setToolTipText(EXPLORATION_TT_Str);
    learnRateL.setText(LEARNINGRATEStr);
    amortTF.setToolTipText(AMORTISSEMENT_TT_Str);
    penalL.setText(PENALITEStr);
    penalTF.setToolTipText(PENALITE_TT_Str);
    recompL.setText(RECOMPENSEStr);
    recompTF.setToolTipText(RECOMPENSE_TT_Str);
    learnB.setToolTipText(APPRENTISSAGE_TT_Str);
    learnB.setText(APPRENDREStr);
    mapSizeCB.setToolTipText(TAILLECARTE_TT_STr);
    decreaseLearnCheck.setText(DEGRESSIFStr);
    decreaseLearnCheck.setToolTipText(DEGRESSIF_TT_Str);
    AmortissementL.setText(AMORTISSEMENTStr);
    apprentTF.setToolTipText(LEARNINGRATE_TT_Str);

    mapP.setLang(laLangue);
  }
  //----------------------------------------------------------------------------
  public void start()
  {
  }
  //----------------------------------------------------------------------------
  void mapSizeCB_actionPerformed(ActionEvent e) {
    Integer whichSize=new Integer((String) mapSizeCB.getSelectedItem());
    if(DEBUG) System.err.println("taille carte ="+whichSize);
    mapP.setBlocks(whichSize.intValue());
    mapP.repaint();
    learnB.setEnabled(true);
  }

  void learnB_actionPerformed(ActionEvent e) {
    mapP.cleanMap();
    if(DEBUG)
      {
      System.err.println("originalMap:");
      mapP.dumpMap();
      }
      //Recup des valeurs
      try{

        long iM= (long) this.iterMaxTF.getValue();
        double ex=exploreTF.getValue();
        double am = amortTF.getValue();
        double p = penalTF.getValue();
        double r = recompTF.getValue();
        double ap = apprentTF.getValue();
        int mapSize=new Integer((String) this.mapSizeCB.getSelectedItem()).intValue();
        boolean dec_a=this.decreaseLearnCheck.isSelected();

        // nvelle instance d'apprentissage
        bot = new QLearning(iM,ex,am,r,p,ap,mapSize,mapP.getMapDef(),dec_a);

        //Prparation de la progressBar
        appPB = new JProgressBar(0,(int)iM);
        appPB.setValue(0);
        appPB.setStringPainted(true);
        appPB.setBorder(BorderFactory.createEtchedBorder());
        appPB.setBorderPainted(true);
        appPB.setSize(new Dimension(150,85));
        appPB.setMaximumSize(new Dimension(150,85));
        pbf=new JFrame(PROGRESSIONStr);
        pbf.setSize(new Dimension(400,85));
        pbf.setLocation(mapP.getLocationOnScreen());
        pbf.getContentPane().add(appPB);
        pbf.show();
        learnB.setEnabled(false);
        //Lancement de l'apprentissage
        apprentissage=new Thread(bot);
        appTimer=new Timer(0,appSurv);
        startTime=System.currentTimeMillis();
        apprentissage.start();
        appTimer.start();
      }
      catch(Exception anyex)
      {
        anyex.printStackTrace();
      }
  }

  //Surveillance de l'apprentissage

  ActionListener appSurv = new ActionListener()
  {
    public void actionPerformed(ActionEvent e)
    {
      long cI=bot.getCurrentIter();
      //TANT QUE APPRENTISSAGE PAS FINI
      if(cI<bot.getIterMax()-1)
      {
        appPB.setValue((int)cI);
        if(DEBUG) System.err.println("cI= "+cI);
      }
      else
        //SI APPRENTISSAGE FINI, MONTRER LES RESULTATS ...
      {
        appTimer.stop();
        endTime=System.currentTimeMillis();
        elapsedTime=endTime-startTime;
        appPB.setValue(0);
        appPB.setVisible(false);
        pbf.dispose();
        learnB.setEnabled(true);
        mapP.setMapDef(bot.giveResMap());
        mapP.setTargetHits(bot.getTargetHits());
        mapP.setElapsedTime(elapsedTime);
        if(DEBUG) mapP.dumpMap();
        mapP.repaint();
        if(DEBUG) System.err.println("TIMER STOP");
      }
    }
  };
  //----------------------------------------------------------------------------
}