package com.thierrymasson.qlearner;

import javax.swing.JPanel;
import java.awt.*;
import java.awt.event.*;
import javax.swing.event.*;

import java.util.ResourceBundle;
import java.util.Locale;

/**
 * <p>Title: Q - Learner</p>
 * <p>Description: Applet de dmonstration de Q-Learning</p>
 * <p>Copyright: Copyright (c) 2002 Thierry MASSON</p>
 * <p>Company: </p>
 * @author Thierry MASSON
 * @version 1.0
 */

public class mapPanel extends JPanel {

  boolean DEBUG=false;

  boolean hitsReceived=false;
  boolean elapsedTimeReceived=false;
  int mapDef[][];
  int recS=50;
  int halfRec=(recS-2)/2;
  int tiersRec=(recS-2)/3;
  int transparence = 70;
  Color couleurCaseNormale = Color.GRAY;
  Color couleurCaseDanger = Color.RED;
  Color couleurCaseCible = Color.GREEN;
  Color couleurCaseNormaleT = new Color(128,128,128,transparence);
  Color couleurCaseCibleT = new Color(0,255,0,transparence);
  Color couleurCaseDangerT = new Color(255,0,0,transparence);
  Color couleurRobot = Color.WHITE;
  Color couleurFleche = Color.BLACK;
  Color couleurTexte = Color.BLACK;
  int blocksN=10;
  int decal=100;
  int xc;
  int yc;
  int xp[]=new int [3];
  int yp[]= new int[3];
  int targetHits;
  long elapsedTime;

  private String targetHitsStr;
  private String targetHitsCompStr;

  private String elapsedTimeStr;
  private String elapsedTimeUnitStr;

  public mapPanel(){}

  public void setLang(String laLangue)
  {
    Locale laLocale=new Locale(laLangue);
    ResourceBundle QLDMessages=ResourceBundle.getBundle("com.thierrymasson.qlearner.QLD",laLocale);
    targetHitsStr=QLDMessages.getString("targetHitsStr");
    targetHitsCompStr=QLDMessages.getString("targetHitsCompStr");
    elapsedTimeStr=QLDMessages.getString("elapsedTimeStr");
    elapsedTimeUnitStr=QLDMessages.getString("elapsedTimeUnitStr");
  }

  public void setBlocks(int blocksNum)
  {
    mapDef=new int[blocksNum][blocksNum];
    for(int i=0;i<blocksNum;i++)
    {
      for(int j=0;j<blocksNum;j++)
      {
        mapDef[i][j]=0;
      }
    }
    blocksN=blocksNum;
    recS=500/blocksNum;
    halfRec=(recS-2)/2;
    tiersRec=(recS-2)/3;
    targetHits=0;
    elapsedTime=0;

    addMouseListener(new MouseAdapter() {
         public void mousePressed(MouseEvent e) {
             int x = e.getX();
             int y = e.getY();
             //DEBUG
             if(DEBUG)
             {
               System.err.println("click  :"+x+" , "+y);
             }
             //MAJ MapDef
             int relx=x-decal-2;
             int rely=y-decal-2;
             int iflag=relx/recS;
             int jflag=rely/recS;
             int flag=0;
             // Verif. du respect des limites du tableau ...
             if(iflag>=0 && iflag<blocksN && jflag>=0 && jflag<blocksN)
             {
               switch(e.getButton())
               {
                 case 1:flag=1;break;
                 case 2:flag=0;break;
                 case 3:flag=2;break;
               }
               mapDef[jflag][iflag]=flag;
             }
             // Repeindre composant
             repaint();
         }
        });
  }

  public void paintComponent(Graphics g)
  {
    //paint bg
    g.setColor(new Color(236, 233, 217));
    super.paintComponent(g);
    // Dessine la grille (si kekchose  dessiner ....)
    if(mapDef !=null){
      boolean robPresence=false;
      for(int i=0;i<blocksN;i++)
      {
         yc=decal+2+(i*recS)+halfRec;
        for(int j=0;j<blocksN;j++)
        {
          xc=decal+2+(j*recS)+halfRec;
          switch (mapDef[i][j])
          {
          case 0:
            g.setColor(couleurCaseNormale);
            g.fillRect(decal+2+j*recS,decal+2+i*recS,recS-2,recS-2);
            break;
          case 1:
            g.setColor(couleurCaseDanger);
            g.fillRect(decal+2+j*recS,decal+2+i*recS,recS-2,recS-2);
            break;
          case 2:
            g.setColor(couleurCaseCible);
            g.fillRect(decal+2+j*recS,decal+2+i*recS,recS-2,recS-2);
            break;
            //TODO AFFICHAGE DES FLECHES ...
          case 100:
            g.setColor(couleurCaseNormaleT);
            g.fillRect(decal+2+j*recS,decal+2+i*recS,recS-2,recS-2);
            //DESSINER LIGNE NORD
            g.setColor(couleurFleche);
            g.drawLine(xc,yc,xc,yc-recS+3);
            xp[0]=xc;xp[1]=xc-3;xp[2]=xc+3;
            yp[0]=yc-recS+3;yp[1]=yc-recS+8;yp[2]=yc-recS+8;
            g.fillPolygon(xp,yp,3);
            break;
          case 101:
            g.setColor(couleurCaseDangerT);
            g.fillRect(decal+2+j*recS,decal+2+i*recS,recS-2,recS-2);
            //DESSINER LIGNE NORD
            g.setColor(couleurFleche);
            g.drawLine(xc,yc,xc,yc-recS+3);
            xp[0]=xc;xp[1]=xc-3;xp[2]=xc+3;
            yp[0]=yc-recS+3;yp[1]=yc-recS+8;yp[2]=yc-recS+8;
            g.fillPolygon(xp,yp,3);
            break;
          case 102:
            g.setColor(couleurCaseCibleT);
            g.fillRect(decal+2+j*recS,decal+2+i*recS,recS-2,recS-2);
            //DESSINER LIGNE NORD
         /*   g.setColor(couleurFleche);
            g.drawLine(xc,yc,xc,yc-recS);*/
            break;
          case 200:
            g.setColor(couleurCaseNormaleT);
            g.fillRect(decal+2+j*recS,decal+2+i*recS,recS-2,recS-2);
            //DESSINER LIGNE E
            g.setColor(couleurFleche);
            g.drawLine(xc,yc,xc+recS-3,yc);
            xp[0]=xc+recS-3;xp[1]=xc+recS-8;xp[2]=xc+recS-8;
            yp[0]=yc;yp[1]=yc-3;yp[2]=yc+3;
            g.fillPolygon(xp,yp,3);
            break;
          case 201:
            g.setColor(couleurCaseDangerT);
            g.fillRect(decal+2+j*recS,decal+2+i*recS,recS-2,recS-2);
            //DESSINER LIGNE E
           g.setColor(couleurFleche);
           g.drawLine(xc,yc,xc+recS-3,yc);
           xp[0]=xc+recS-3;xp[1]=xc+recS-8;xp[2]=xc+recS-8;
           yp[0]=yc;yp[1]=yc-3;yp[2]=yc+3;
            g.fillPolygon(xp,yp,3);
            break;
          case 202:
            g.setColor(couleurCaseCibleT);
            g.fillRect(decal+2+j*recS,decal+2+i*recS,recS-2,recS-2);
            //DESSINER LIGNE E
       /*     g.setColor(couleurFleche);
            g.drawLine(xc,yc,xc+recS,yc);*/
            break;
          case 300:
            g.setColor(couleurCaseNormaleT);
            g.fillRect(decal+2+j*recS,decal+2+i*recS,recS-2,recS-2);
            //DESSINER LIGNE S
            g.setColor(couleurFleche);
            g.drawLine(xc,yc,xc,yc+recS-3);
            xp[0]=xc;xp[1]=xc-3;xp[2]=xc+3;
            yp[0]=yc+recS-3;yp[1]=yc+recS-8;yp[2]=yc+recS-8;
            g.fillPolygon(xp,yp,3);
            break;
          case 301:
            g.setColor(couleurCaseDangerT);
            g.fillRect(decal+2+j*recS,decal+2+i*recS,recS-2,recS-2);
            //DESSINER LIGNE S
           g.setColor(couleurFleche);
           g.drawLine(xc,yc,xc,yc+recS-3);
           xp[0]=xc;xp[1]=xc-3;xp[2]=xc+3;
           yp[0]=yc+recS-3;yp[1]=yc+recS-8;yp[2]=yc+recS-8;
           g.fillPolygon(xp,yp,3);
            break;
          case 302:
            g.setColor(couleurCaseCibleT);
            g.fillRect(decal+2+j*recS,decal+2+i*recS,recS-2,recS-2);
            //DESSINER LIGNE S
         /*   g.setColor(couleurFleche);
            g.drawLine(xc,yc,xc,yc+recS);*/
            break;
          case 400:
            g.setColor(couleurCaseNormaleT);
            g.fillRect(decal+2+j*recS,decal+2+i*recS,recS-2,recS-2);
            //DESSINER LIGNE O
            g.setColor(couleurFleche);
            g.drawLine(xc,yc,xc-recS+3,yc);
            xp[0]=xc-recS+3;xp[1]=xc-recS+8;xp[2]=xc-recS+8;
            yp[0]=yc;yp[1]=yc+3;yp[2]=yc-3;
            g.fillPolygon(xp,yp,3);
            break;
          case 401:
            g.setColor(couleurCaseDangerT);
            g.fillRect(decal+2+j*recS,decal+2+i*recS,recS-2,recS-2);
            //DESSINER LIGNE O
            g.setColor(couleurFleche);
            g.drawLine(xc,yc,xc-recS+3,yc);
            xp[0]=xc-recS+3;xp[1]=xc-recS+8;xp[2]=xc-recS+8;
            yp[0]=yc;yp[1]=yc+3;yp[2]=yc-3;
            g.fillPolygon(xp,yp,3);
            break;
          case 402:
            g.setColor(couleurCaseCibleT);
            g.fillRect(decal+2+j*recS,decal+2+i*recS,recS-2,recS-2);
            //DESSINER LIGNE O
         /*   g.setColor(couleurFleche);
            g.drawLine(xc,yc,xc-recS,yc);*/
            break;
          }
        }
        if(hitsReceived)
        {
          g.setColor(couleurTexte);
          g.drawString(this.targetHitsStr+" "+this.targetHits+" "+this.targetHitsCompStr,400,650);
        }
        if(elapsedTimeReceived)
        {
          g.setColor(couleurTexte);
          g.drawString(this.elapsedTimeStr+" "+this.elapsedTime/1000.0+" "+this.elapsedTimeUnitStr,400,665);
        }
      }
    }//fin if(mapDef != null)
  }

  public int[][] getMapDef(){return mapDef;}

  public void setMapDef(int givenMap[][])
  {
    this.mapDef=givenMap;
  }

  public int getMapDefCell(int row, int col)
  {
    return mapDef[row][col];
  }

  public void updateMapDef(int row, int col, int value)
  {
    mapDef[row][col]=value;
  }

  // DEBUG ;-D
  public void dumpMap()
  {
    for (int i=0;i<blocksN;i++)
    {
      for(int j=0;j<blocksN;j++)
      {
        System.err.print(mapDef[i][j]+"-");
      }
      System.err.println("*");
    }
  }

  public void cleanMap()
  {
    for (int i=0;i<blocksN;i++)
   {
     for(int j=0;j<blocksN;j++)
     {
       mapDef[i][j]=(mapDef[i][j] % 100);
     }
    }
    hitsReceived=false;
  }

  public void setTargetHits(int value)
  {
    this.targetHits=value;
    hitsReceived=true;
  }

  public void setElapsedTime(long value)
  {
    this.elapsedTime=value;
    elapsedTimeReceived=true;
  }
}