C **********************************************************************
C
C 	                       agent.com
C
C **********************************************************************

	PARAMETER (ISTOP_ACTION=1, ICONT_ACTION=2)
	PARAMETER (IUP_ACTION=3, IDOWN_ACTION=4)
	PARAMETER (ISTATE_SIZE=47)
	PARAMETER (INUM_INPUT_UNITS=ISTATE_SIZE)
	PARAMETER (INUM_HIDDEN_UNITS=20)
	PARAMETER (INUM_NETS=2)
	PARAMETER (INUM_OUTPUT_UNITS=2)
	PARAMETER (MAX_CARS=4)
	PARAMETER (MAX_FLRS=10)
	PARAMETER (MAX_PASSENGERS=10000)

	COMMON /agent/
     .  alpha,        !! Exponential decay rates for rewards.
     .  alpha2,       !! Squared.
     .  alpha3,       !! Cubed.
     .  alpha4,       !! Fourth power.
     .	last_event_time,
     .  immediate_rewards(MAX_CARS),
     .  last_action_time(MAX_CARS),
     .  last_evaluation(MAX_CARS),
     .  current_state(ISTATE_SIZE),
     .  previous_state(ISTATE_SIZE),
     .  last_state(MAX_CARS, ISTATE_SIZE),
     .	hidden_units(INUM_HIDDEN_UNITS),
     .  output_units(INUM_OUTPUT_UNITS),
     .  ih_weights(INUM_INPUT_UNITS,INUM_HIDDEN_UNITS,INUM_NETS),
     .  ho_weights(INUM_HIDDEN_UNITS,INUM_OUTPUT_UNITS,INUM_NETS),
     .  ih_dw_old(INUM_INPUT_UNITS,INUM_HIDDEN_UNITS,INUM_NETS),
     .  ho_dw_old(INUM_HIDDEN_UNITS,INUM_OUTPUT_UNITS,INUM_NETS),
     .	learning_rate,
     .  momentum,        !! Added by NJM 8/20
     .	slope,		 !! Constant in exponent of logistic function.
     .  temperature,
     .  temp_factor,
     .  lr_factor,
     .  average_epsilon,
     .  total_squared_wait,
     .  avg_floor_wait(MAX_FLRS),
     .  total_reward(MAX_CARS),
     .  total_time(MAX_CARS),
     .  rho(MAX_CARS),
     .  waiting_list(MAX_PASSENGERS),
     .  last_action(MAX_CARS),
     .  num_floor_wait(MAX_FLRS),  !! for calculating avg floor wait
     .  num_epsilons,    !! for calculating avg td error
     .  passenger_count, !! for calculating avg squared wait
     .  save_interval,
     .  rand_type,
     .  traffic_type,
     .  inter_traffic,
     .  reward_type,
     .  do_floor,
     .  do_parking,
     .  do_sarsa,
     .  agree,
     .  disagree,
     .  rand_action(MAX_CARS)

	REAL*8 alpha,alpha2,alpha3,alpha4
	REAL*8 last_event_time
	REAL*8 immediate_rewards
        REAL*8 last_action_time
	REAL*8 last_evaluation
	REAL*8 current_state, previous_state, last_state
	REAL*8 hidden_units, output_units
	REAL*8 ih_weights, ho_weights
        REAL*8 ih_dw_old, ho_dw_old
	REAL*8 learning_rate
        REAL*8 momentum
	REAL*8 slope
	REAL*8 temperature
	REAL*8 temp_factor
	REAL*8 lr_factor
	REAL*8 average_epsilon
	REAL*8 total_squared_wait
	REAL*8 avg_floor_wait
        REAL*8 total_reward
        REAL*8 total_time
        REAL*8 rho
	REAL waiting_list
	INTEGER last_action
	INTEGER num_floor_wait
	INTEGER num_epsilons
	INTEGER passenger_count
        INTEGER save_interval
	INTEGER rand_type
	INTEGER traffic_type
	INTEGER inter_traffic
	INTEGER reward_type
	INTEGER do_floor
	INTEGER do_parking
	INTEGER do_sarsa
        INTEGER agree
        INTEGER disagree
        INTEGER rand_action



