C  *************************************************************************
C  **
C  **  Module Name : prime
C  **  Module Type : subroutine 
C  **  Description : This subroutine performs simulation initialization
C  **                tasks  (called by SIMAN). 
C  **      
C  ************************************************************************* 
    
      SUBROUTINE prime
       
      INCLUDE  'agent.h'
      INCLUDE  'siman.h'
      INCLUDE  'my.h'      

      COMMON /intcom/ lastint(2,10), meanint(2,10), off(2,10)
      REAL*8 lastint, meanint, off

      INTEGER car,dir,floor,run,stream
      REAL    factor,delay,ex,junk,drand
      REAL get_poisson_interval
      INTEGER first_iteration
      SAVE first_iteration
      DATA first_iteration/1/

C  These were originally in my.h, but the data stmts can't appear
C  in multiple subroutines. (Crites 12/93)

      DATA max_interval/36000.0/
      DATA start_event/.TRUE./

C
C  INITIALIZE SYSTEM CONSTANTS
C                               
         
      CALL   get_parameters()     
             
      IF ( print ) THEN
        CALL print_parameters()     
      END IF  
C
C  ALL CARS ARE STOPPED
C
      DO car = 1,tot_cars
        door_open(car) = .FALSE. 
        state(car) = stopped 
        CALL get_car_statistics ( car )
        CALL get_system_statistics()
      END DO 
C
C	PRINT THE DOWN CONSTANTS. I.E. % OF TRAFFIC GOING DOWN.
C
C 	DO FLOOR=1,TOT_FLRs
C 	write (11,*) (down(floor,i),i=1,5)
C 	end do
C
C	DO FLOOR=1,TOT_FLRs
C	write (11,*) (down(floor,i),i=6,10)
C	end do

C
C CLEAR DISPLAY AND DRAW SYSTEM
C
      IF ( graphics ) THEN
        CALL clear_screen
        CALL draw_system
        CALL refresh_screen
      END IF 
C
C CLEAR ALL CALLS
C           
      DO car =  1,tot_cars
        DO dir = 1,2      
          DO floor = 1,tot_flrs
            hall_calls(car,dir,floor) = -1.0
            car_calls(car,dir,floor)  = -1.0
            buttons(dir,floor)        = -1.0
            lastint(dir,floor)        = 300.0
            meanint(dir,floor)        = 300.0
            off(dir,floor)            = 0.0
          END DO
        END DO
      END DO

C	set car_flag to zero.

	do car = 1,tot_cars
		car_flag(car,1) = 0
		car_flag(car,2) = 0
		car_flag(car,3) = 0
	end do

C     Perform our own initializations.

      IF (first_iteration .EQ. 1) THEN
         
         CALL init_rand
         CALL init_agents
         CALL init_net

         OPEN ( unit=12 , file= 'wait.stats' , status='unknown' )
         OPEN ( unit=13 , file= 'critic.stats' , status='unknown' )

C         OPEN ( unit=60,  file= 'floor1.stats', status='unknown' )
C         OPEN ( unit=61,  file= 'floor2.stats', status='unknown' )
C         OPEN ( unit=62,  file= 'floor3.stats', status='unknown' )
C         OPEN ( unit=63,  file= 'floor4.stats', status='unknown' )
C         OPEN ( unit=64,  file= 'floor5.stats', status='unknown' )
C         OPEN ( unit=65,  file= 'floor6.stats', status='unknown' )
C         OPEN ( unit=66,  file= 'floor7.stats', status='unknown' )
C         OPEN ( unit=67,  file= 'floor8.stats', status='unknown' )
C         OPEN ( unit=68,  file= 'floor9.stats', status='unknown' )
C         OPEN ( unit=69,  file= 'floor10.stats', status='unknown' )

         first_iteration = 0
      END IF

      num_sys = 0
      max_sys = 0

      CALL init_floor_wait
      CALL init_waiting_list
      CALL reset_agents

C
C SCHEDULE FIRST PASSENGER ARRIVALS
C              

      IF (stationary_load) THEN
        factor = 1.0
      ELSE
        factor = float(nnrun) / (float(nnrns) + float(nnrun) - 1.0)
        factor = factor + 0.5
      END IF

      DO run=1,nnrun+1
        DO stream=1,nnstr
          junk = drand(stream)
C          junk = get_rand ( 0.0, 1.0 )
        END DO
      END DO  

      DO floor= 1,tot_flrs

        IF ( arr_int(floor,1) .LE. max_interval ) THEN 

           IF (rand_type .EQ. 0) THEN
              delay = ex(1,1) * arr_int(floor,1) / factor
           ELSE
              delay = get_poisson_interval ( 1.0/arr_int(floor,1)*factor )
           END IF

          IF (floor.LE.20) THEN
C            CALL tally ( floor + 7 , delay )
C            CALL tally ( tot_flrs + 7 + 1 , delay )
          END IF  
             
          CALL sch_pass_arrival ( floor , delay )

        END IF
      END DO

      RETURN
      END                                                                   

C  *************************************************************************
C  **                          
C  **  Module Name : event(job,code)
C  **  Module Type : subroutine 
C  **  Description : This subroutine vectors the entity associated
C  **                with job to the appropriate event handler.
C  **                'Job' represents an entity associated with event 
C  **                type 'code'. (called by SIMAN). 
C  **      
C  ************************************************************************* 

      SUBROUTINE event(job,code)
                                
      INCLUDE  'siman.h'
      INCLUDE  'my.h'      
                   
      REAL a 
      INTEGER code,car,direction,floor,job   
      LOGICAL more_calls,flag

      car       = INT(a(job,3))     
      direction = INT(a(job,4))
      floor     = INT(a(job,5))

C	print *, "Car ", car
                 
      CALL dispos(job)

      IF(code .eq. 1) THEN
        CALL pass_arrival(floor)
        flag = .TRUE.
      END IF
                          
      IF(code .eq. 2) THEN
        CALL car_arrival(car)
        CALL get_car_statistics ( car )
        flag = .FALSE.
      END IF 
             
      IF(code .eq. 3) THEN 
        CALL transfer(car)
        CALL get_car_statistics ( car )
        flag = .TRUE.
      END IF 
                  
      IF(code .eq. 4) THEN 
        CALL car_full(direction,floor)
        flag = .TRUE.
      END IF
             
      IF ( graphics .AND. tnow.GT.start .AND. code.LE.2 ) THEN
        CALL update_state
        CALL update_display
        CALL refresh_screen
      END IF
                
      IF (flag) THEN
        CALL get_system_statistics()
      END IF

C     ------------------------------------------------------------
C     No longer need to call reallocate (mcnulty, 3/21/94)
C     ------------------------------------------------------------

C        CALL reallocate()     
                          
      DO car = 1,tot_cars                                            
C        IF ( ( state(car).EQ.stopped ) .AND.
C     .       ( more_calls(car) .OR. 
C     .	       ( park_floor(car) .NE. cur_flr(car) ) ) ) THEN
C
C	Changed 3/8/94 (mcnulty) since cars can now stop for no reason.
C       Without this change they never start moving again.
C
        IF ( state(car).EQ.stopped ) THEN
          state(car) = awake
          CALL sch_car_arrival ( car , 0.0 )
        END IF
      END DO

      RETURN           
      END

C  **********************************************************************
C  **
C  **  Module Name : pass_arrival(source)                
C  **  Module Type : subroutine 
C  **  Description : This subroutine places a passenger in the pass_arrival 
C  **                buffer for the 'source' floor and schedules the
C  **                next pass_arrival at floor 'source'.
C  **
C  **********************************************************************

      SUBROUTINE pass_arrival(source)                
      
      INCLUDE  'siman.h'
      INCLUDE  'my.h'  
      INCLUDE  'agent.h'
           
      COMMON /intcom/ lastint(2,10), meanint(2,10), off(2,10)
      REAL*8 lastint, meanint, off

      INTEGER source,dest,direction
      REAL    factor,delay,ex
      INTEGER idir,iflr,job
      INTEGER ind_up,ind_dn
      REAL get_poisson_interval
           
C         
C  GET SOURCE AND DESTINATION FLRS
C                               
      CALL get_destination(source,dest) 

      IF ( dest .GT. source ) THEN
        direction = 1
      ELSE   
        direction = 0
      END IF                   
C
C  Comment from Bob Crites (6/95):
C
C  I know that the get_destination code is an illogical rat's nest
C  and it makes more sense to me to generate destinations until we
C  get one that is in an acceptable direction.  But I am keeping
C  the code this way so that my comparisons match those who gave
C  me the code.  While I'm at it, the arrival rate calculations in
C  get_parameters are another weird baroque nightmare.
C
      IF (direction .EQ. 1 .AND. traffic_type .EQ. 0) GO TO 88

      num_sys = num_sys + 1
      IF (num_sys .GT. max_sys) THEN
         max_sys = num_sys
      END IF
C                         
C  PUT PASSENGER IN APPROPRIATE ARRIVAL BUFFER
C     
      CALL create (job)

      CALL seta ( job , 1 , float(source) )
      CALL seta ( job , 2 , float(dest)   )
      CALL seta ( job , 3 , tnow   )
      CALL seta ( job , 4 , 0.0    )
      CALL seta ( job , 5 , 0.0    )
C          
C  SET FIRST PASSENGER FLAG IF LANDING IS EMPTY 
C          
      IF ( buttons(direction+1,source) .LT. 0.0 ) THEN 
        buttons(direction+1,source) = tnow
        lastint(direction+1,source) = tnow - off(direction+1,source)
        meanint(direction+1,source) = 0.5 * meanint(direction+1,source) +
     X                                0.5 * lastint(direction+1,source)
        CALL seta ( job , 6 , 1.0    )                
      ELSE
        CALL seta ( job , 6 , 0.0    )                
      END IF
C
C  PUT PASSENGER IN ARRIVAL BUFFER 
C          
      IF ( dest .GT.  source ) THEN
         CALL insert ( job , ind_up(source) )
      ELSE   
         CALL insert ( job , ind_dn(source) )
      END IF 

      IF ( debug ) THEN
        WRITE (11,50) source,dest,tnow
      END IF              
50    FORMAT (' ** passenger arrives floor ',i2,' dest floor ',i2,' time : ',f8.2)

      CALL handle_event ( tnow )

C     ------------------------------------------------------------
C     Enter the new passenger's arrival time into our waiting list
C     (mcnulty 3/21/94).
C     ------------------------------------------------------------

      DO i=1, max_sys
         IF (waiting_list(i) .EQ. -1.0) THEN
            waiting_list(i) = tnow
            GOTO 88
         END IF 
      END DO

 88   CONTINUE

C                       
C  SCHEDULE NEXT ARRIVAL (expon)
C                  

      IF (stationary_load) THEN
        factor = 1.0
      ELSE
        factor = float(nnrun) / (float(nnrns) + float(nnrun) - 1.0)
        factor = factor + 0.5
      END IF 

      IF (rand_type .EQ. 0) THEN
         delay = ex(1,1) * arr_int(source,min(24,INT(tnow/300.0)+1) )/ factor
      ELSE
         delay = get_poisson_interval
     +     (1.0/arr_int(source,min(24,INT(tnow/300.0)+1))*factor)
      END IF

      CALL sch_pass_arrival ( source , delay )
C                           
C  COLLECT STATISTICS ON THIS ARRIVAL
C     
      IF ( source .LE. 20 ) THEN
C        CALL tally ( source + 7 , delay)
C        CALL tally ( tot_flrs + 7 + 1, delay )
      END IF
                                
      RETURN
      END

C  **********************************************************************
C  **
C  **  Module Name : car_arrival(car)
C  **  Module Type : subroutine 
C  **  Description : This subroutine moves 'car' between floors.
C  **                Schedules a transfer if a car call or hall call is 
C  **                active for 'car' at the current floor.  The
C  **                subroutine schedules itself if no transfers are  
C  **                required at the car's current floor, but there are
C  **                calls to service at other floors.             
C  **                
C  **********************************************************************

      SUBROUTINE car_arrival(car)

      INCLUDE  'siman.h'   
      INCLUDE  'my.h'                         
      INCLUDE  'agent.h'

      INTEGER car
      INTEGER num_in_car
      LOGICAL no_calls       
      LOGICAL more_calls,in_motion,xfer_req,more_work_this_dir,going_up
      INTEGER step,new_state,new_dir,new_flr
      LOGICAL passengers_waiting
      INTEGER handle_car_arrival
      INTEGER action, index
      LOGICAL waiting_same_dir
      LOGICAL waiting_either_dir
      LOGICAL waiting_other_dir
      LOGICAL waiting_both_dir
      INTEGER oldest_dir
      LOGICAL exit_req	
      CHARACTER*20 state_string
      CHARACTER*4 dir_string
      INTEGER i
      LOGICAL covered

C
C  DETERMINE CARS NEXT MOVE
C

      IF (debug) THEN
	 write (11, *) '-----------------------------------------------'
         write (11, *) 'Car ', car, ' arrived at floor ', cur_flr(car), 
     .                     ' at time ', tnow
         write (11, *) state_string(car), ' ', dir_string(cur_dir(car))

         write( 11,*) 'Buttons:'
         write (11,*) 'Down: N ', (buttons(1,i),' ',i=2,tot_flrs)
         write (11,*) '  Up: ', (buttons(2,i), ' ',i=1,tot_flrs-1),' N'

         DO i=1,tot_cars
            write (11, *) 'car ', i, ': ', state_string(i), cur_flr(i),
     +           dir_string(cur_dir(i))
         END DO

C	 write (11, *) 'state     = ', state_string(car)
C	 write (11, *) 'in_motion = ', in_motion(state(car))
C	 write (11, *) 'dir       = ', cur_dir(car)
C	 write (11, *) 'waiting_same_dir = ', waiting_same_dir(car)
C	 write (11, *) 'waiting_both_dir = ', waiting_both_dir(car)
      END IF

      new_dir = cur_dir(car)
      new_flr = cur_flr(car)

      IF (.NOT. in_motion(state(car))) THEN
         
	 IF (debug) THEN
	    write (11, *) 'Car ', car, ' is not in motion.'
	 END IF

         ! ----------------------------------------------------
         ! If a passenger on board the elevator wishes to exit,
         ! elevator must enter the 'loading' state.

         IF (exit_req(car)) THEN

            IF (debug) THEN
               WRITE (11,*) "Car ", car, " forced to unload at ", tnow
            END IF

            new_state = loading

         ! ---------------------------------------------------------------
         ! If a passenger is waiting to travel in the same direction,
         ! the elevator must pick them up before taking off (if not full).

         ELSE IF (waiting_same_dir(car) .AND. (num_in_car(car).GT.0)) THEN

	    IF (debug) THEN
	       write (11,*) 'Car ', car, ': people on board and waiting at ',
     .                      ' floor ', cur_flr(car)
	    END IF 

	    IF (num_in_car(car).LT.capacity) THEN
            
	       IF (debug) THEN
		  WRITE (11,*) "Car ", car, 
     .                         " forced to load (same dir) at ", tnow
	       END IF

	       new_state = loading

	    ELSE

	       IF (debug) THEN
	          WRITE (11,*) "Car ", car, " is full and cannot turn."
	       END IF

               new_state = accel
               new_flr   = cur_flr(car) + (2*cur_dir(car)-1)
               
	    END IF

         ! ----------------------------------------------------------
         ! If the car is empty, force it to turn in the direction of the
         ! oldest button that was pressed.

         ELSE IF ((waiting_either_dir(car)) .AND. (num_in_car(car).EQ.0)) THEN

	    IF (debug) THEN
	       WRITE (11,*) 'Car ', car, ' is empty and forced to load at ',
     .                      'floor ', cur_flr(car)
	    END IF
             
            IF (oldest_dir(cur_flr(car)) .EQ. cur_dir(car)) THEN

               new_state = loading

	       IF (debug) THEN
		  WRITE (11,*) "Car ", car, " is empty - forced to load."
	       END IF

            ELSE

               new_state = turning
               new_dir   = 1 - cur_dir(car)

               IF (debug) THEN
		  WRITE (11,*) "Car ", car, " is empty - forced to turn."
	       END IF

            END IF

         ! ----------------------------------------------------------
         ! If the car is on the bottom floor, it must go up.

         ELSE IF (cur_flr(car) .EQ. 1) THEN

            IF (cur_dir(car) .EQ. 1) THEN 

               IF (debug) THEN
                  WRITE (11,*) "Car ", car, " must go up."
               END IF

               new_state = accel
               new_flr   = cur_flr(car) + 1
               
            ELSE

               IF (debug) THEN
                  WRITE (11,*) "Car ", car, " must turn."
               END IF

               new_state = turning
               new_dir   = 1 - cur_dir(car)
               
            END IF

         ! ----------------------------------------------------------
         ! If the car is on the top floor, it must go down.

         ELSE IF (cur_flr(car) .EQ. tot_flrs) THEN

            IF (cur_dir(car) .EQ. 0) THEN 

               IF (debug) THEN
                  WRITE (11,*) "Car ", car, " must go down."
               END IF

               new_state = accel
               new_flr   = cur_flr(car) - 1
               
            ELSE

               IF (debug) THEN
                  WRITE (11,*) "Car ", car, " must turn."
               END IF

               new_state = turning
               new_dir   = 1 - cur_dir(car)
               
            END IF

         ! ----------------------------------------------------------
         ! If the car has passengers, then it must continue in the same
         ! direction.

         ELSE IF (num_in_car(car) .GT. 0) THEN

            IF (debug) THEN
               WRITE (11,*) "Car ", car, " must continue in same direction."
            END IF

            new_state = accel
            new_flr   = cur_flr(car) + (2*cur_dir(car)-1)
               
         ! ----------------------------------------------------------
         ! A decision must be made to go up or down.

         ELSE

C  crites - 6/29/94
C  "action = IUP_ACTION" added in order to force UP action
C  anytime we have a choice as a way of building in some
C  a priori heuristic knowledge.

C            action = 0
C            CALL handle_car_arrival ( car, tnow, action )

            action = IUP_ACTION
           
            IF (debug) THEN
               WRITE (11,*) "action ",action
            END IF

            ! ------------------------------------------------------
            ! Implement UP action while stopped.

            IF (action .EQ. IUP_ACTION) THEN

               IF (cur_dir(car) .EQ. 1) THEN

                  IF (debug) THEN
                     WRITE (11,*) 'Car ', car, ' chooses to go UP',
     .                            ' at floor ', cur_flr(car), ' ',tnow
                  END IF

                  new_state = accel
                  new_flr   = cur_flr(car) + 1

               ELSE ! must turn first.

                  IF (debug) THEN
                     WRITE (11,*) 'Car ', car, ' chooses to TURN',
     .                            ' at floor ', cur_flr(car), ' ',tnow
                  END IF

                  new_state = turning
                  new_dir   = 1 - cur_dir(car)
               END IF

            ! ------------------------------------------------------
            ! Implement DOWN action while stopped.

            ELSE  ! action is DOWN.

               IF (cur_dir(car) .EQ. 0) THEN

                  IF (debug) THEN
                     WRITE (11,*) 'Car ', car, ' chooses to go DOWN',
     .                            ' at floor ', cur_flr(car), ' ',tnow
                  END IF

                  new_state = accel
                  new_flr   = cur_flr(car) - 1

               ELSE ! must turn first.

                  IF (debug) THEN
                     WRITE (11,*) 'Car ', car, ' chooses to TURN',
     .                            ' at floor ', cur_flr(car), ' ',tnow
                  END IF

                  new_state = turning
                  new_dir   = 1 - cur_dir(car)
               END IF

            END IF

         END IF

      ELSE ! Car is moving.

	 ! -------------------------------------------------------
	 ! If the car just arrived at the bottom or top floor,
	 ! force it to stop.
	
	 IF (cur_flr(car) .EQ. 1) THEN

            new_state = decel

C            action = ISTOP_ACTION
C            CALL handle_car_arrival ( car, tnow, action )

            IF (debug) THEN
               WRITE (11,*) 'Car ', car, ' forced to stop at floor 1.'
            END IF

         ELSE IF (cur_flr(car) .EQ. tot_flrs) THEN

            new_state = decel

C            action = ISTOP_ACTION
C            CALL handle_car_arrival ( car, tnow, action )

            IF (debug) THEN
               WRITE (11,*) 'Car ', car, ' forced to stop at top floor.'
            END IF

         ! ----------------------------------------------------
         ! If a passenger on board the elevator wishes to exit,
         ! elevator must stop.

         ELSE IF (exit_req(car)) THEN

            new_state = decel

C            action = ISTOP_ACTION
C            CALL handle_car_arrival ( car, tnow, action )

            IF (debug) THEN
               WRITE (11,*) 'Car ', car, ' forced to stop for discharge.'
            END IF

         ! ----------------------------------------------------
         ! Crites - 6/29/94 - don't allow the cars with riders to stop at
         ! floors where no one is waiting.  FORCE continue.

         ELSE IF ((.NOT. waiting_either_dir(car)) .OR.
     +    ((.NOT. waiting_same_dir(car)) .AND. (num_in_car(car) .GT. 0))) THEN

            new_state = moving
            new_flr   = cur_flr(car) + (2*cur_dir(car)-1)  
            new_dir   = cur_dir(car)

C            action = ICONT_ACTION
C            CALL handle_car_arrival ( car, tnow, action )

            IF (debug) THEN
               WRITE (11,*) 'Car ', car, ' forced to continue.'
            END IF

         ! ----------------------------------------------------
         ! Crites - 1/30/95 - don't allow the cars to stop at
         ! floors that another car is covering.  FORCE continue.

         ELSE IF (covered(car)) THEN

           new_state = moving
           new_flr   = cur_flr(car) + (2*cur_dir(car)-1)  
           new_dir   = cur_dir(car)

C           action = ICONT_ACTION
C           CALL handle_car_arrival ( car, tnow, action )

           IF (debug) THEN
              WRITE (11,*) 'Car ', car, ' forced to continue.'
           END IF

         ! ----------------------------------------------------
         ! Crites - 6/3/95 - Must stop for up passengers on way up.

         ELSE IF (cur_dir(car) .EQ. 1 .AND. waiting_same_dir(car)) THEN

            new_state = decel

            IF (debug) THEN
               WRITE (11,*) 'Car ', car, ' forced to stop for up passenger.'
            END IF

         ! ----------------------------------------------------------
         ! A decision must be made to stop or continue.

         ELSE

            ! -------------------------------------------------------
            ! Make a decision.

            action = 0
            CALL handle_car_arrival ( car, tnow, action )

            ! ------------------------------------------------------
            ! Implement STOP action.

            IF (action .EQ. ISTOP_ACTION) THEN

               IF (debug) THEN
                  write (11,*) 'Car ', car, ' chooses to STOP (decel)',
     .                         ' at floor ', cur_flr(car), ' ',tnow
               END IF

               new_state = decel
               new_dir   = cur_dir(car)
               new_flr   = cur_flr(car)

            ! ------------------------------------------------------
            ! Implement CONTINUE action.

            ELSE  ! action is continue.

               IF (debug) THEN
                  WRITE (11,*) 'Car ', car, ' chooses to CONT',
     .                         ' at floor ', cur_flr(car), ' ',tnow
               END IF

               new_state = moving
               new_flr   = cur_flr(car) + (2*cur_dir(car)-1)  
               new_dir   = cur_dir(car)

               IF (debug) THEN
                  WRITE(11,*) "Car ", car, " will arrive at floor ", new_flr
               END IF

            END IF

         END IF

      END IF

C
C  TRANSITION TO NEW MOTION STATE 
C

      IF ( .NOT. in_motion(state(car)) .AND. in_motion(new_state) ) THEN
        door_open(car) = .FALSE.
        state(car)   = accel 
        cur_flr(car) = new_flr 
      ELSE IF ( in_motion(state(car)) .AND. .NOT. in_motion(new_state) ) THEN
        state(car)   = decel 
      ELSE
        state(car)   = new_state
        cur_dir(car) = new_dir 
        cur_flr(car) = new_flr 
      END IF
C
C  SCHEDULE NEW EVENTS
C
      IF (state(car).EQ.loading) THEN 
        CALL sch_transfer ( car , 0.0 )
      ELSE IF (state(car).EQ.moving) THEN 
        CALL sch_car_arrival ( car , flr_time )
      ELSE IF (state(car).EQ.parking) THEN 
        CALL sch_car_arrival ( car , flr_time )
      ELSE IF (state(car).EQ.accel) THEN 
         CALL sch_car_arrival ( car , stop_time/2.0 )
      ELSE IF (state(car).EQ.decel) THEN 
        CALL sch_car_arrival ( car , stop_time/2.0 )
      ELSE IF (state(car).EQ.turning) THEN 
        CALL sch_car_arrival ( car , 1.0 )
      END IF
C                                     
C  DEBUGGING STATEMENTS
C
      IF ( debug ) THEN
        IF (state(car).EQ.stopped) THEN       
          WRITE (11,100) car,cur_flr(car),tnow
        ELSE IF (state(car).EQ.moving) THEN 
          WRITE (11,200) car,cur_flr(car)-(2*cur_dir(car)-1),cur_flr(car),tnow 
        ELSE IF (state(car).EQ.parking) THEN 
          WRITE (11,300) car,cur_flr(car)-(2*cur_dir(car)-1),cur_flr(car),tnow 
        ELSE IF (state(car).EQ.accel) THEN 
          WRITE (11,400) car,tnow
        ELSE IF (state(car).EQ.decel) THEN 
          WRITE (11,500) car,tnow 
        ELSE IF (state(car).EQ.turning) THEN 
          WRITE (11,600) car,tnow 
        END IF
      END IF
                                        
100   FORMAT ( ' car ',i1,' is stopped floor ',i2,' time : ',f8.2)
200   FORMAT ( ' car ',i1,' moves from floor ',i2,' to floor ',i2,' time : ',f8.2)
300   FORMAT ( ' car ',i1,' parks from floor ',i2,' to floor ',i2,' time : ',f8.2)
400   FORMAT ( ' car ',i1,' is accellerating time : ',f8.2)
500   FORMAT ( ' car ',i1,' is decellerating time : ',f8.2)
600   FORMAT ( ' car ',i1,' switches direction time : ',f8.2)

C	this modification is done by asif to get cycle time & 
C	# of stops statistics.(5/15/92)

	IF ( cur_flr(car) .EQ. 2 .AND. cur_dir(car) .EQ. 1) then
	car_flag(car,1) = 1
C	write (11,*) ' car flag for car ',car, ' is  set to 1 '
	end if

      RETURN
      END

C **********************************************************************
C
C     covered
C
C     Returns true if cur_flr of car is already being serviced by
C     another car.
C
C **********************************************************************

      LOGICAL FUNCTION covered(car)
                      
      INCLUDE  'my.h'    

      INTEGER car,i
      LOGICAL waiting_both_dir

      covered = .FALSE.
      DO i = 1, tot_cars
         IF (i .NE. car) THEN
            IF (cur_flr(i) .EQ. cur_flr(car)) THEN
               IF (state(i) .EQ. stopped
     +   .OR.      state(i) .EQ. loading
     +   .OR.      state(i) .EQ. decel
     +   .OR.      state(i) .EQ. turning) THEN
                  IF (.NOT. waiting_both_dir(car)) THEN
                     covered = .TRUE.
                  ELSE IF (cur_dir(i) .EQ. cur_dir(car)) THEN
                     covered = .TRUE.
                  END IF
               END IF
            END IF
         END IF
      END DO

      RETURN
      END

C
C *********************************************************************
C                                                      
      LOGICAL FUNCTION in_motion(state_b)
                            
      INTEGER state_b
      INCLUDE 'my.h'
 
      IF (state_b.EQ.accel.OR.state_b.EQ.moving.OR.state_b.EQ.parking) THEN
        in_motion = .TRUE.
      ELSE
        in_motion = .FALSE.
      END IF              

      RETURN
      END
             

C
C *********************************************************************
C                                                      
      LOGICAL FUNCTION car_in_motion(car)
                            
      INTEGER car
      INCLUDE 'my.h'
      INTEGER state_b
	
      state_b = state(car)
 
      IF (state_b.EQ.accel.OR.state_b.EQ.moving.OR.state_b.EQ.parking) THEN
        car_in_motion = .TRUE.
      ELSE
        car_in_motion = .FALSE.
      END IF              

      RETURN
      END
             

C  **********************************************************************
C  **
C  **  Module Name : transfer(car)
C  **  Module Type : subroutine 
C  **  Description : This subroutine moves passengers in and out of
C  **                'car' one by one. Schedules itself if there are
C  **                more passengers to be loaded\unloaded. Schedules
C  **                the car_arrival otherwise.
C  **
C  **********************************************************************

      SUBROUTINE transfer(car)

      INCLUDE  'siman.h'
      INCLUDE  'my.h'           
      INCLUDE  'agent.h'           
                              
      COMMON /intcom/ lastint(2,10), meanint(2,10), off(2,10)
      REAL*8 lastint, meanint, off

      INTEGER car  
      REAL    delay,ex,a,er
      INTEGER job,floor,dir,my_car,dest
      INTEGER ind_car,ind_up,ind_dn
      INTEGER num_in_car,lfr
      LOGICAL exit_req,ent_req,going_up
      LOGICAL waiting_same_dir
      LOGICAL waiting_either_dir
      REAL wait
                       
      door_open(car) = .TRUE.
      state(car) = loading 
C
C  IF SOME TO EXIT 
C             
      IF (exit_req(car) ) THEN

	IF (debug) THEN
	   WRITE (11,*) "Car ", car, " unloading 1 passenger at ", tnow
	END IF

        num_sys = num_sys - 1                      
C            
C    SCHEDULE TRANSFER
C               
        delay = er(20,2,0.6,6.0) * exit_time
        CALL tally(7,delay)
C            
C    REMOVE PASSENGER FROM CAR BUFFER
C       
        job = lfr(ind_car(car))
        CALL remove( job , ind_car(car) )
        CALL seta (job , 5 , tnow + delay )

C	------------------------------------------------------------
C	Added write for debuggin (mcnulty, 3/4/94)
C	------------------------------------------------------------

C	WRITE (15, 1200) car, cur_flr(car), " unloading one passenger "
      
 1200	FORMAT (I1, ", ", I1, ": ", A50)

        IF ( debug ) THEN
          WRITE (11,50) car,INT(a(job,2)),tnow
        END IF
50      FORMAT (' passenger exits car ',i1,' at floor ',i2,' time : ',f8.2)
                            
C
C    COLLECT WAITING,TRAVEL,AND SYSTEM STATISTICS  
C                   
        CALL tally( 1 , a(job,4)-a(job,3) )
        CALL tally( 2 , (a(job,4)-a(job,3))**2.0 )
        CALL tally( 3 , a(job,5)-a(job,3) )
        CALL dispos ( job )
             
        IF ( a(job,6)  .GT. 0.5 ) THEN
          CALL tally(4,a(job,4)-a(job,3))
        END IF

        IF ( a(job,4)-a(job,3) .GT. max_wait) THEN
          CALL tally(5,a(job,4)-a(job,3))
        END IF
                                                        
C        CALL tally ( INT(8+(a(job,3)/300.0)) , a(job,4)-a(job,3) )

        CALL tally ( INT(8+ a(job,1) ) , a(job,4)-a(job,3) )

        CALL sch_transfer ( car , delay )

C     ------------------------------------------------------------
C     Added call to update rewards (mcnulty, 3/21/94).
C     If a passenger has left the system, this currently has no
C     impact since we are only considering waiting time not travel
C     time for rewards.  So don't call handle_event here.
C     ------------------------------------------------------------

C        CALL handle_event ( tnow )

C
C ELSE IF SOME TO ENTER
C
      ELSE IF (waiting_same_dir(car) .AND. (num_in_car(car).LT.capacity)) THEN

C         ------------------------------------------------------------
C       If a passenger has entered an elevator, then we count that
C       as a satisfied customer and stop accumulating rewards for
C       that passenger.  So call handle_event to update rewards
C       (mcnulty, 3/21/94).  
C       passenger's waiting time will not be counted.
C       ------------------------------------------------------------

	IF (debug) THEN
	   WRITE (11,*) "Car ", car, " picking up 1 passenger at ", tnow
	END IF

	CALL handle_event ( tnow )

C
C  SCHEDULE TRANSFER
C
	delay = er(20,2,0.6,6.0) * entrance_time 
        CALL tally(6,delay)
C                  
C    MOVE FROM ARRIVAL BUFFER TO CAR BUFFER
C
	IF ( going_up(car) ) THEN
	  job = lfr(ind_up(cur_flr(car)))
	  CALL remove( job , ind_up(cur_flr(car)))
	ELSE
	  job = lfr(ind_dn(cur_flr(car)))
	  CALL remove( job , ind_dn(cur_flr(car)))
	END IF

	dest  = INT(a(job,2))
	dir   = cur_dir(car) 
	floor = dest 

C       ------------------------------------------------------------
C       Extract time of original passenger arrival so we can remove
C       it from the active waiting list.
C       ------------------------------------------------------------

	arr_time = 1.0*a(job,3)
	DO i=1, max_sys
	   IF (waiting_list(i) .EQ. arr_time) THEN

	      ! ------------------------------------------
	      ! Save the passenger's squared waiting time.

C              print *, "Passenger arrived at ", arr_time, " picked up at ",
C     .            tnow
	      CALL add_waiting_time ( tnow - waiting_list(i) )
              CALL add_floor_wait ( cur_flr(car), tnow - waiting_list(i) )

	      ! -----------------------------------
	      ! Remove passenger from waiting list.

	      waiting_list(i) = -1.0

              GOTO 88
	   END IF
	END DO

        PRINT *, "Failed to find a passenger in the waiting list!!!"

 88     CONTINUE

	IF ( debug ) THEN
	  WRITE (11,150) car,INT(a(job,1)),tnow
	END IF
150     FORMAT (' passenger enters car ',i1,' at floor ',i2,' time : ',f8.2)

	IF ( car_calls(car,dir+1,floor) .LT. 0.0 ) THEN
	  car_calls(car,dir+1,floor) = tnow
	END IF                    

	CALL seta ( job , 4 , tnow + entrance_time )
	CALL insert (job , ind_car(car))                                   

        CALL sch_transfer ( car , delay )
	
C                  
C  ELSE CLEAR CALLS AND SCHEDULE CAR_ARRIVAL (zero) TRANSFER COMPLETE
C            
      ELSE
         
	IF (debug) THEN
           WRITE (11,*) "No transfer required."
	END IF

        dir   = cur_dir(car)
        floor = cur_flr(car)
       
        car_calls (car,dir+1,floor) = -1.0
        temp_storage  =  buttons   (dir+1,floor) 
        buttons   (dir+1,floor)     = -1.0
        off (dir+1,floor) = tnow

C	this is a modification introduced by asif (5/15/92) to get 
C	an estimate of the round-trip travel time & the # of stops 
C	that a car makes per trip.

	IF ( floor .EQ. 1 .AND. num_in_car(car) .EQ. 0)  then
	  IF ( car_flag(car,1) .EQ. 1) then
C	WRITE (11,*) ' GOT INTO THE IF BLOCK ',tnow
C	WRITE (11,*) ' CAR,car_flag(3),floor ',car,car_flag(car,3),floor

	IF ( tnow .GT. car_flag(car,2) ) THEN
	CALL tally (20,(tnow - car_flag(car,2))) 
	END IF

	car_flag(car,2) = tnow
	car_flag(car,1) = 0
	CALL tally (21,(car_flag(car,3) +1))
	car_flag(car,3) = 0
	  else
C	WRITE (11,*) ' GOT INTO THE else if  BLOCK ',tnow
C	WRITE (11,*) ' CAR,car_flag(3),floor ',car,car_flag(car,3),floor
	car_flag(car,2) = tnow
	car_flag(car,3) = 0
	  end if
	end if
C	if a transfer was done here and floor is not 1, then for the
C	downpeak case, that is a stop.
	IF (floor .NE. 1) then
	car_flag(car,3) = car_flag(car,3) + 1
C	write (11,*) ' CAR # ',car, ' stopped here  at time ',tnow
	end if

C	car_flag(car,1) is a flag that is used to indicate the  start of
C	a trip . It is 0 at the first floor  and is set to 1 at the second
C	floor in the car arrival routine. Car_flag(car,2) indicates thetime 
C	of start of the trip. And car_flag(*,3) is a count of the # of stops
C	excluding the one at the first floor.
C	this is the end of the modification here for now.
C

C	IF ( debug ) then
C	WRITE (11,*) ' GOT INTO THE transfer & call car_arr BLOCK  '
C	WRITE (11,*) ' hall_calls( car,dir+1,floor),car,floor,dir '
C	WRITE (11,*)  hall_calls(car,dir+1,floor),car,floor,dir
C	end if

        CALL sch_car_arrival ( car , 0.0  )
        
        IF ( ent_req(car) ) THEN
          CALL sch_button ( dir , floor , 0.0 )         
          buttons   (dir+1,floor)  =  temp_storage 
       END IF

      END IF
      
      RETURN
      END          
              

C  **********************************************************************
C  **     
C  **  Module Name : car_full(direction,floor) 
C  **  Module Type : subroutine 
C  **  Description : This subroutine reissues a hall call immediately
C  **                after a full car has left a floor landing at which 
C  **                passengers are still waiting.
C  **
C  **********************************************************************
                 
      SUBROUTINE car_full(direction,floor)

      INCLUDE  'my.h'
      INCLUDE  'siman.h'          
                 
      INTEGER lfr,ind_up,ind_dn
      INTEGER direction,floor,job
                                          
C      buttons(direction+1,floor) = tnow    
      IF (direction .EQ. 1) THEN
        job = lfr(ind_up(floor))
        CALL remove( job , ind_up(floor))
        CALL seta  ( job , 6 , 1.0 )
        CALL insert (job , ind_up(floor))                                   
      ELSE
        job = lfr(ind_dn(floor))
        CALL remove( job , ind_dn(floor))
        CALL seta  ( job , 6 , 1.0 )
        CALL insert (job , ind_dn(floor))                                   
      END IF

      RETURN
      END

C  **********************************************************************
C  **
C  **  Module Name : get_destination(s,d) 
C  **  Module Type : subroutine 
C  **  Description : This subroutine contains the statistical
C  **                functions which select from an arbitrary
C  **                probability distribution the destination floor 'd' 
C  **                of a passenger arriving at floor 's'.
C  **
C  **********************************************************************

      SUBROUTINE get_destination(source,dest) 
                      
      INCLUDE  'my.h'
      INCLUDE  'siman.h'
      INCLUDE  'agent.h'
            
      INTEGER source,dest     
      REAL    un
      LOGICAL done                                             

      done = .FALSE.               
      DO WHILE (.NOT.done)   
        IF (un(6,6) .LT. down(source,min(24,INT(tnow/300.0)+1)) .AND.
     .                                                 source.NE.1 ) THEN
          dest = 1
        ELSE
          dest = INT(-2.0 + ( (float(tot_flrs) + 4.0) * un(6,6) ))
        END IF
        IF (dest.GE.1.AND.dest.LE.tot_flrs.AND.dest.NE.source) THEN
          done = .TRUE.
        END IF             
      END DO

      IF (inter_traffic .EQ. 0) THEN
         dest = 1
      END IF

      RETURN
      END    

C  *********************************************************************
C  **
C  **  Module Name : more_calls( car )
C  **  Module Type : function 
C  **  Description : This function returns true if 'car' has no more
C  **                calls to service. 
C  **
C  *********************************************************************

      LOGICAL  FUNCTION more_calls( car )

      INCLUDE  'siman.h'
      INCLUDE  'my.h'                  
      
      INTEGER car  
      LOGICAL keep_going
      INTEGER floor

      keep_going = .TRUE.
      more_calls = .FALSE.               
      floor      = 1          
                     
      DO WHILE (floor .LE. tot_flrs .AND. keep_going)

        IF ( car_calls (car,1,floor) .GT. 0.0  .OR.
     .       car_calls (car,2,floor) .GT. 0.0  ) THEN 
          more_calls = .TRUE.               
          keep_going = .FALSE.
        END IF  

        floor = floor + 1

      END DO

      RETURN
      END
                           
C  ***************************************************************************
C  **
C  **  Module Name : xfer_req ( car ) 
C  **  Module Type : function 
C  **  Description : This function returns true if a passenger transfer
C  **                is required at the current floor of 'car'. 
C  **
C  **
C  ***************************************************************************

      LOGICAL FUNCTION xfer_req ( car ) 
          
      INCLUDE  'siman.h'
      INCLUDE  'my.h'   
                       
      INTEGER opp_dir,car,dir,flr 
      INTEGER num_in_car
      logical ent_req                      

      dir = cur_dir(car) 
      flr = cur_flr(car)     
                     
      IF ( car_calls(car,dir+1,flr)  .GT. 0.0. OR.
     .     (ent_req(car) .AND. door_open(car)
     .                   .AND. num_in_car(car).LT.capacity) ) THEN
        xfer_req = .TRUE.    
      ELSE
        xfer_req = .FALSE.
      END IF

      RETURN
      END     
       

C  ***************************************************************************
C  **                  
C  **  Module Name : ent_req(car)
C  **  Module Type : function 
C  **  Description : This function returns true if a passenger exit is 
C  **                required at the current floor of 'car'. 
C  **
C  ***************************************************************************

      LOGICAL FUNCTION ent_req(car)
                      
      INCLUDE  'siman.h'                                               
      INCLUDE  'my.h'    

      INTEGER car
      LOGICAL going_up   
      INTEGER ind_dn,ind_up,nq   

      IF ( going_up(car) ) THEN
        IF (nq(ind_up(cur_flr(car))).eq.0) THEN 
          ent_req = .FALSE. 
        ELSE                                      
          ent_req = .TRUE.
       END IF
      ELSE
        IF (nq(ind_dn(cur_flr(car))).eq.0) THEN 
          ent_req = .FALSE.
        ELSE
          ent_req = .TRUE.
        END IF
      END IF 

      RETURN
      END

C  ***************************************************************************
C  **
C  **  Module Name : exit_req(car)
C  **  Module Type : function 
C  **  Description : This function returns true if a passenger exit is 
C  **                required at the current floor of 'car'. 
C  **
C  ***************************************************************************

      LOGICAL FUNCTION exit_req(car)
              
      INCLUDE  'siman.h'
      INCLUDE  'my.h'                

      INTEGER car
      INTEGER ind_up,ind_dn,ind_car,nq,lfr
 
      IF (nq(ind_car(car)).eq.0) THEN 
        exit_req = .FALSE.
      ELSE
c       CALL copy(lfr(ind_car(car)) , atrib )
        CALL copy(lfr(ind_car(car)))

        IF (INT(atrib(2)) .eq. cur_flr(car)) THEN
          exit_req = .TRUE.
        ELSE         
          exit_req = .FALSE.
        END IF         
      END IF

      RETURN
      END                     


C  ***************************************************************************
C  **
C  **  Module Name : more_work_this_dir( car ) 
C  **  Module Type : function 
C  **  Description : This function returns true if 'car' has more
C  **                calls in its current travel direction.    
C  **
C  ***************************************************************************
                
      LOGICAL FUNCTION more_work_this_dir( car ) 
                                                                              
      INCLUDE  'siman.h'
      INCLUDE  'my.h' 
               
      INTEGER car
      INTEGER dir,floor,inc,extreme
      LOGICAL keep_going    
                    
      dir        = cur_dir(car)
      floor      = cur_flr(car)  
      inc        = 2*dir-1                  
      extreme    = MAX(1,dir*tot_flrs)   

      keep_going = .TRUE.                            
      more_work_this_dir = .FALSE.

      floor = floor + inc

      DO WHILE (floor.NE.extreme+inc.AND.keep_going)

C     ------------------------------------------------------------
C     Modified to look not at hall_calls (mcnulty 3/4/94).
C     ------------------------------------------------------------
C
C        IF (hall_calls(car,1,floor).GT.0.0 .OR.
C     .      hall_calls(car,2,floor).GT.0.0 .OR. 

        IF (car_calls (car,1,floor).GT.0.0 .OR. 
     .      car_calls (car,2,floor).GT.0.0 ) THEN 
          keep_going         = .FALSE.
          more_work_this_dir = .TRUE.
        END IF        

        floor = floor + inc

      END DO

      RETURN
      END

C  ***************************************************************************
C  **
C  **  Module Name : going_up(car)  
C  **  Module Type : function 
C  **  Description : This function returns true if the current travel 
C  **                direction of 'car' is up.
C  **
C  ***************************************************************************

      LOGICAL FUNCTION going_up(car)  

      INCLUDE  'siman.h'
      INCLUDE  'my.h'                  

      INTEGER car                                      

      IF ( cur_dir(car) .eq. 1 ) THEN
        going_up = .TRUE.
      ELSE
        going_up = .FALSE.
      END IF

      RETURN              
      END

C  ***************************************************************************
C  **
C  **  Module Name : ind_car(car)
C  **  Module Type : function 
C  **  Description : This function returns the SIMAN queue index of 'car'
C  **
C  ***************************************************************************

      INTEGER FUNCTION ind_car(car)
      
      INCLUDE  'siman.h'                                                    
      INCLUDE  'my.h'

      INTEGER car
      LOGICAL going_up          

      IF (going_up(car) ) THEN
        ind_car = car + 82 
      ELSE
        ind_car = car + 90
      END IF                  
                      
      RETURN
      END             

C  ***************************************************************************
C  **
C  **  Module Name : ind_up(f)
C  **  Module Type : function 
C  **  Description : This function returns the SIMAN queue index for
C  **                upward moving passengers at floor 'f'.    
C  **
C  ***************************************************************************
     
      INTEGER FUNCTION ind_up(f)

      INCLUDE  'siman.h'                                                    
      INCLUDE  'my.h'   
    
      INTEGER f

      ind_up = f + 1

      RETURN
      END
                       
C  ***************************************************************************
C  **
C  **  Module Name : ind_dn(f)
C  **  Module Type : function 
C  **  Description : This function returns the SIMAN queue index for 
C  **                downward moving passengers at floor 'f'.    
C  **
C  ***************************************************************************

      INTEGER FUNCTION ind_dn(f)
                                                                              
      INCLUDE  'siman.h'
      INCLUDE  'my.h'   

      INTEGER f    

      ind_dn = f + 41

      RETURN
      END              

C  ***************************************************************************
C  **
C  **  Module Name : num_in_car(car)
C  **  Module Type : function 
C  **  Description : This function returns the number of passengers in 'car'.
C  **
C  ***************************************************************************

      INTEGER FUNCTION num_in_car(car)

      INCLUDE  'siman.h'
      INCLUDE  'my.h'                                                       
             
      INTEGER car
      INTEGER ind_car,nq

      num_in_car = nq(ind_car(car)) 

      RETURN
      END
       
C  ***************************************************************************
C  **
C  **  Module Name : num_waiting()
C  **  Module Type : function 
C  **  Description : This function returns the total number of
C  **                passengers waiting in floor lobbies. 
C  **
C  ***************************************************************************

      INTEGER FUNCTION num_waiting()
                                                                              
      INCLUDE  'siman.h'
      INCLUDE  'my.h'           
           
      INTEGER floor
      INTEGER ind_up,ind_dn,nq

      num_waiting = 0
      DO floor=1,tot_flrs
        num_waiting = num_waiting +  nq(ind_up(floor))
        num_waiting = num_waiting +  nq(ind_dn(floor))
      END DO

      RETURN
      END

C  **********************************************************************
C  **
C  **  Module Name : get_system_statistics  
C  **  Module Type : subroutine 
C  **  Description : This subroutine updates the system statistics
C  **                after a system state change. 
C  **
C  **********************************************************************

      SUBROUTINE get_system_statistics()     

      INCLUDE  'siman.h'
      INCLUDE  'my.h'                 
            
      INTEGER num_riders,car
      REAL    candidate
      INTEGER num_waiting,num_in_car
            
      num_riders = 0
      DO car=1,tot_cars
        num_riders = num_riders + num_in_car(car)
      END DO
                     
      x( 1 )  =  float(num_sys) 
      x( 2 )  =  float(num_riders)  
      x( 3 )  =  float(num_waiting())  

      CALL timst ( x(1),tnow, 1 )
      CALL timst ( x(2),tnow, 2 )
      CALL timst ( x(3),tnow, 3 )
       
      RETURN
      END

C  **********************************************************************
C  **
C  **  Module Name : get_statistics(car)   
C  **  Module Type : subroutine 
C  **  Description : This subroutine updates the system car statistics
C  **                after a car state change.  For efficiency, only 
C  **                the statistics of 'car' are updated.
C  **
C  **********************************************************************

      SUBROUTINE get_car_statistics(car)

      INCLUDE  'siman.h'
      INCLUDE  'my.h'  
                                  
      LOGICAL more_calls
      INTEGER car,num_in_car     
           
      IF (car.LE.5) THEN

        x(car+3) = float(cur_flr(car))
        x(car+8) = float(num_in_car(car))

        IF (state(car).EQ.loading.OR.more_calls(car)) THEN
          x(car+13) = 1.0
        ELSE
          x(car+13) = 0.0
        END IF

        IF (num_in_car(car).GT.0) THEN
          x(car+18) = 1.0
        ELSE
          x(car+18) = 0.0
        END IF
      
        CALL timst ( x(car+3)  ,tnow, car+3 )
        CALL timst ( x(car+8)  ,tnow, car+8 )
        CALL timst ( x(car+13) ,tnow, car+13)
        CALL timst ( x(car+18) ,tnow, car+18 )

      END IF

      RETURN
      END

C  **********************************************************************
C  **
C  **  Module Name : get_parameters()
C  **  Module Type : subroutine 
C  **  Description : This subroutine reads the simulation input
C  **                parameters from file 'input.dat'.
C  **                           
C  **********************************************************************

      SUBROUTINE get_parameters()

      INCLUDE  'my.h'  
      INCLUDE  'agent.h'
                                               
      DIMENSION narrivals(25),inter(20,25),uni(20,25)
                                                              
      REAL    big_number,arrivals,inter,uni,percent,smin,smax
      INTEGER car,floor,period,narrivals,factor  
      INTEGER ngraphics,nprint,ndebug                  
      big_number = 1000001.0 

      OPEN ( unit=1 , file= 'input.dat' , status='unknown' )

      READ ( 1 , 100 ) ngraphics
      READ ( 1 , 100 ) max_wait
      READ ( 1 , 100 ) start
      READ ( 1 , 100 ) nprint
      READ ( 1 , 100 ) nalg       
      READ ( 1 , 100 ) ndebug    
      READ ( 1 , 100 ) tot_cars 
      READ ( 1 , 100 ) capacity
      READ ( 1 , 100 ) tot_flrs 
      READ ( 1 , 100 ) ground_flr 
      READ ( 1 , 150 ) flr_time 
      READ ( 1 , 150 ) entrance_time 
      READ ( 1 , 150 ) exit_time 
      READ ( 1 , 150 ) stop_time 
      READ ( 1 , 200 ) cur_dir 
      READ ( 1 , 200 ) cur_flr
      READ ( 1 , 200 ) park_floor    
                     
      IF (ngraphics.EQ.0) THEN
        graphics = .FALSE.
      ELSE
        graphics = .TRUE.
      END IF

      IF (ndebug.EQ.0) THEN
        debug = .FALSE.
      ELSE
        debug = .TRUE.
      END IF
                     
      IF (nalg.EQ.0) THEN
        stationary_load = .TRUE.
      ELSE
        stationary_load = .FALSE.
      END IF

      IF (nprint.EQ.0) THEN
        print = .FALSE.
      ELSE
        print = .TRUE.
      END IF

      DO floor = 1,tot_flrs
        read ( 1 , 250 ) narrivals
        DO period = 1,25 
          uni(floor,period) = narrivals(period)
        END DO                       
      END DO

      smin = +1000000.0
      smax = -1000000.0 
      DO period = 2,25 
        IF (uni(1,period) + uni(2,period) .GT. smax) THEN
          smax = uni(1,period) + uni(2,period)
        END IF
        IF (uni(1,period) + uni(2,period) .LT. smin) THEN
          smin = uni(1,period) + uni(2,period)
        END IF
      END DO                       

      DO floor = 1,tot_flrs
        DO period = 2,25 
          percent = 0.5 + 
     .       (1.5 * (uni(1,period) + uni(2,period) - smin) / (smax-smin))
          inter(floor,period) = uni(floor,1) * percent / 100.0
          IF (inter_traffic .EQ. 0) THEN
             inter(floor,period) = 0.0
          END IF
        END DO                       
      END DO


      DO floor = 1,tot_flrs                                               
        IF (floor.EQ.1) THEN
          factor = tot_flrs
        ELSE
          factor = 1
        END IF
        narrivals(1) = uni(floor,1)
        DO period = 2,25 
          narrivals(period) = inter(floor,period) + (uni(floor,period)*factor)
          down(floor,period-1) = uni(floor,period) /
     .             MAX(1.0,inter(floor,period) + uni(floor,period))
          IF ( narrivals(1).EQ.0.OR.narrivals(period).EQ.0 ) THEN
            arr_int(floor,period-1) = max_interval + 1 
          ELSE 
            arrivals =  FLOAT(narrivals(period)*narrivals(1)) / 100.0
            arr_int(floor,period-1) = 300.0 / arrivals 
          END IF
        END DO
      END DO
            
      CLOSE(1)
      
100   FORMAT(i5,a1)
150   FORMAT(f4.1,a1)
200   FORMAT(10i5,a1)             
250   FORMAT(25i5,a1) 
      
      RETURN
      END

C  **********************************************************************
C  **
C  **  Module Name : print_parameters()
C  **  Module Type : subroutine                             
C  **  Description : This subroutine prints the simulation input parameters.
C  **
C  **********************************************************************

      SUBROUTINE print_parameters()

      INCLUDE  'my.h'                                      

      INTEGER ihour,i
                                       
      WRITE (*,25)
      WRITE (*,25)
      WRITE (*,50)        
      WRITE (*,75)
      WRITE (*,100) tot_flrs,tot_cars,capacity
      WRITE (*,150) flr_time,stop_time
      WRITE (*,200) entrance_time,exit_time

      ihour = 1
      DO i=1,tot_flrs,5
        WRITE (*,250) i,i+4,
     .         INT(300.0/arr_int( (i-1) + 1 , ihour )),  
     .         INT(300.0/arr_int( (i-1) + 2 , ihour )),  
     .         INT(300.0/arr_int( (i-1) + 3 , ihour )),  
     .         INT(300.0/arr_int( (i-1) + 4 , ihour )),  
     .         INT(300.0/arr_int( (i-1) + 5 , ihour ))  
      END DO

 
 25   FORMAT ('   ')
 50   FORMAT ('                 Elevator Parameters for this Run ')
 75   FORMAT ('                 -------- ---------- --- ---- --- ')
100   FORMAT (' total floors : ',i2 ,'   total cars : ',i2,
     .                                   '    capacity  : ',i2 )
150   FORMAT (' floor time   : ',f4.1,' stop time  : ',f4.1)
200   FORMAT (' entrance time: ',f4.1,' exit time  : ',f4.1)
250   FORMAT (' arrivals per hour floors ',i2,' to ',i2,' : ',5i5)
      
      RETURN
      END

C  **********************************************************************
C  **
C  **  Module Name : sch_car_arrival ( car , delay )
C  **  Module Type : subroutine 
C  **  Description : This subroutine schedules the car_arrival event for
C  **                'car' to occur in 'delay' seconds.   
C  **
C  **********************************************************************

      SUBROUTINE sch_car_arrival ( car , delay )

      INCLUDE  'my.h'

      INTEGER job,car
      REAL delay     
                                           
      CALL create ( job )
      CALL seta ( job , 3 , float(car) )
      CALL sched ( job , 2 , delay )

      RETURN
      END
 

C  **********************************************************************
C  **
C  **  Module Name : sch_button ( direction , floor , delay )
C  **  Module Type : subroutine 
C  **  Description : This subroutine schedules the car_full event for 
C  **                'floor' to occur in 'delay' seconds. 
C  **                
C  **********************************************************************
       
      SUBROUTINE sch_button ( direction , floor , delay )

      INCLUDE  'my.h'

      INTEGER job,direction,floor
      REAL delay     
                                                                 
      CALL create ( job )        
      CALL seta ( job , 4 , float(direction) )
      CALL seta ( job , 5 , float(floor) )
      CALL sched ( job , 4 , delay )

      RETURN
      END

C  **********************************************************************
C  **
C  **  Module Name : sch_pass_arrival ( floor , delay )
C  **  Module Type : subroutine 
C  **  Description : This subroutine schedules the pass_arrival event for 
C  **                'floor' to occur in 'delay' seconds.   
C  **
C  **********************************************************************

      SUBROUTINE sch_pass_arrival ( floor , delay )
       
      INCLUDE  'my.h'
              
      INTEGER job,floor
      REAL delay
                          
      CALL create ( job )
      CALL seta ( job , 5 , float(floor) )
      CALL sched ( job , 1 , delay )
      
      RETURN
      END


C  **********************************************************************
C  **
C  **  Module Name : sch_transfer ( car , delay )
C  **  Module Type : subroutine 
C  **  Description : This subroutine schedules the transfer event for
C  **                'car' to occur in 'delay' seconds.   
C  **
C  **********************************************************************

      SUBROUTINE sch_transfer ( car , delay )

      INCLUDE  'my.h'
                                                 
      INTEGER job,car
      REAL delay
                              
      CALL create ( job )
      CALL seta ( job , 3 , float(car) )
      CALL sched ( job , 3 , delay )
      
      RETURN
      END            

C **********************************************************************
C
C 	passengers_waiting
C
C **********************************************************************

      LOGICAL FUNCTION passengers_waiting(car)
                      
      INCLUDE  'my.h'    

      INTEGER car

      INTEGER floor, dir

      floor = cur_flr ( car )
      dir   = cur_dir ( car ) 

      passengers_waiting = .FALSE.
      IF ( buttons ( dir+1, floor ) .GE. 0.0 ) THEN
        passengers_waiting = .TRUE.
      END IF

      RETURN
      END

C **********************************************************************
C
C     waiting_same_dir
C
C     Returns true if there are passengers waiting to travel in the
C     same direction the elevator is going at the current floor of 
C     the elevator.
C
C **********************************************************************

      LOGICAL FUNCTION waiting_same_dir(car)
                      
      INCLUDE  'my.h'    

      INTEGER car
      LOGICAL going_up   
      INTEGER ind_dn,ind_up,nq   

      IF ( going_up(car) ) THEN
        IF (nq(ind_up(cur_flr(car))).eq.0) THEN 
          waiting_same_dir = .FALSE. 
        ELSE                                      
          waiting_same_dir = .TRUE.
       END IF
      ELSE
        IF (nq(ind_dn(cur_flr(car))).eq.0) THEN 
          waiting_same_dir = .FALSE.
        ELSE
          waiting_same_dir = .TRUE.
        END IF
      END IF 

      RETURN
      END

C **********************************************************************
C
C     waiting_next_floor
C
C     Returns true if there are passengers waiting to travel in the
C     same direction the elevator is going at the next floor.
C
C **********************************************************************

      LOGICAL FUNCTION waiting_next_floor(car)
                      
      INCLUDE  'my.h'    

      INTEGER car
      LOGICAL going_up   
      INTEGER next_floor
      INTEGER ind_dn,ind_up,nq   

      next_floor = cur_flr(car) + 2*cur_dir(car) - 1
      IF ((next_floor .GE. 1) .OR. (next_floor .LE. tot_flrs)) THEN

         IF ( going_up(car) ) THEN
           IF (nq(ind_up(next_floor)).eq.0) THEN 
             waiting_next_floor = .FALSE. 
           ELSE                                      
             waiting_next_floor = .TRUE.
          END IF
         ELSE
           IF (nq(ind_dn(next_floor)).eq.0) THEN 
             waiting_next_floor = .FALSE.
           ELSE
             waiting_next_floor = .TRUE.
           END IF
         END IF 
         
      END IF

      RETURN
      END

C **********************************************************************
C
C     waiting_either_dir
C
C     Returns true if there are passengers waiting to travel in the
C     same direction the elevator is going at the current floor of 
C     the elevator.
C
C **********************************************************************

      LOGICAL FUNCTION waiting_either_dir(car)
                      
      INCLUDE  'my.h'    

      INTEGER car

      INTEGER ind_dn,ind_up,nq   

      IF ((nq(ind_up(cur_flr(car))).eq.0) .AND.
     .    (nq(ind_dn(cur_flr(car))).eq.0)) THEN 
         waiting_either_dir = .FALSE. 
      ELSE                                      
         waiting_either_dir = .TRUE.
      END IF

      RETURN
      END

C **********************************************************************
C
C     waiting_both_dir
C
C     Returns true if there are passengers waiting to travel in the
C     same direction the elevator is going at the current floor of 
C     the elevator.
C
C **********************************************************************

      LOGICAL FUNCTION waiting_both_dir(car)
                      
      INCLUDE  'my.h'    

      INTEGER car

      INTEGER ind_dn,ind_up,nq   

      IF ((nq(ind_up(cur_flr(car))).eq.0) .OR.
     .    (nq(ind_dn(cur_flr(car))).eq.0)) THEN 
         waiting_both_dir = .FALSE. 
      ELSE                                      
         waiting_both_dir = .TRUE.
      END IF

      RETURN
      END

C **********************************************************************
C
C     oldest_dir
C
C     Returns true if there are passengers waiting to travel in the
C     same direction the elevator is going at the current floor of 
C     the elevator.
C
C **********************************************************************

      INTEGER FUNCTION oldest_dir(floor)
                      
      INCLUDE  'my.h'    

      INTEGER floor

      INTEGER ind_dn,ind_up,nq   

      IF ((buttons(1, floor) .EQ. -1.0) .AND.
     .    (buttons(2, floor) .EQ. -1.0)) THEN
	oldest_dir = -1
      ELSE IF (buttons(1,floor) .EQ. -1.0) THEN
	oldest_dir = 1
      ELSE IF (buttons(2,floor) .EQ. -1.0) THEN
	oldest_dir = 0
      ELSE IF (buttons(1, floor) .LT. buttons(2, floor)) THEN
         oldest_dir = 0
      ELSE
         oldest_dir = 1
      END IF

      RETURN
      END

C **********************************************************************
C
C     waiting_other_dir
C
C     Returns true if there are passengers waiting to travel in the
C     same direction the elevator is going at the current floor of 
C     the elevator.
C
C **********************************************************************

      LOGICAL FUNCTION waiting_other_dir(car)
                      
      INCLUDE  'my.h'    

      INTEGER car

      INTEGER ind_dn,ind_up,nq   

      ! If current direction is down, look for passengers going up.

      IF (cur_dir(car) .EQ. 0) THEN
        IF (nq(ind_up(cur_flr(car))).eq.0) THEN 
           waiting_other_dir = .FALSE. 
        ELSE                                      
           waiting_other_dir = .TRUE.
        END IF
      ELSE
        IF (nq(ind_dn(cur_flr(car))).eq.0) THEN
           waiting_other_dir = .FALSE. 
        ELSE                                      
           waiting_other_dir = .TRUE.
        END IF
      END IF

      RETURN
      END

C **********************************************************************
C
C     init_waiting_list
C
C **********************************************************************

      SUBROUTINE init_waiting_list

      INCLUDE 'agent.h'
      INTEGER i

      DO i=1, MAX_PASSENGERS
         waiting_list(i) = -1.0
      END DO

      passenger_count    = 0
      total_squared_wait = 0.0

      RETURN
      END

C **********************************************************************
C
C     get_total_squared_wait
C
C     Sum of squared waited times of all passengers who were previously
C     in the system and are currently in the system (in this run).
C
C **********************************************************************

      REAL*8 FUNCTION get_total_squared_wait ( time )
      
      INCLUDE 'my.h'
      INCLUDE 'agent.h'

      REAL time

      REAL*8 total, wait
      INTEGER i, count

      total = 0.0
      count = 0
	
      IF (max_sys .GT. MAX_PASSENGERS) THEN
         print *, "Max passengers too small ", max_sys, "!!!"
      END IF

      DO i=1,max_sys
         IF (waiting_list(i) .GT. -0.5) THEN
            wait = time - waiting_list(i)
            total = total + wait*wait
	    count = count + 1
         END IF
      END DO

C  account for passengers that have already boarded an elevator

      count = count + passenger_count
      total = total + total_squared_wait

      IF (count .NE. 0.0) THEN
         get_total_squared_wait = total/count
      ELSE
	 get_total_squared_wait = 0.0
      END IF

      RETURN
      END

C **********************************************************************
C
C     clean_up
C
C **********************************************************************

      SUBROUTINE clean_up

      CLOSE (12) !! wait.stats file
      CLOSE (13) !! critic.stats file
      CLOSE (49) !! rand.out file

C      CLOSE (60) !! floor1.stats file
C      CLOSE (61) !! floor2.stats file
C      CLOSE (62) !! floor3.stats file
C      CLOSE (63) !! floor4.stats file
C      CLOSE (64) !! floor5.stats file
C      CLOSE (65) !! floor6.stats file
C      CLOSE (66) !! floor7.stats file
C      CLOSE (67) !! floor8.stats file
C      CLOSE (68) !! floor9.stats file
C      CLOSE (69) !! floor10.stats file

      RETURN
      END

C **********************************************************************
C
C     add_waiting_time
C
C     Save the total squared waiting time of a passenger who just 
C     entered an elevator.
C
C **********************************************************************

      SUBROUTINE add_waiting_time ( wait )
      
      INCLUDE 'agent.h'
      REAL wait
      
      passenger_count = passenger_count + 1
      total_squared_wait = total_squared_wait + wait*wait

      RETURN
      END

C **********************************************************************
C
C 	dir_string
C
C **********************************************************************

      CHARACTER*4 FUNCTION dir_string ( i )

      INTEGER i

      IF (i .EQ. 0) THEN
         dir_string = "DOWN"
      ELSE
         dir_string = "UP"
      END IF

      RETURN
      END

C **********************************************************************
C
C 	state_string
C
C **********************************************************************

      CHARACTER*20 FUNCTION state_string ( car )

      INCLUDE 'my.h'
      INTEGER car

      if (state(car).EQ.moving) then
	state_string = "MOVING"
      else if (state(car).EQ.stopped) then
	state_string = "STOPPED"
      else if (state(car).EQ.accel) then
	state_string = "ACCEL"
      else if (state(car).EQ.decel) then
	state_string = "DECEL"
      else if (state(car).EQ.turning) then
	state_string = "TURNING"
      else if (state(car).EQ.parking) then
	state_string = "PARKING"
      else if (state(car).EQ.loading) then
	state_string = "LOADING"
      else if (state(car).EQ.awake) then
	state_string = "AWAKE"
      else
	state_string = "UNKNOWN"
      end if
      
      RETURN
      END 


C **********************************************************************
C
C     init_floor_wait
C
C **********************************************************************

      SUBROUTINE init_floor_wait
      
      INCLUDE 'agent.h'
      INCLUDE 'my.h'

      DO i=1,tot_flrs
         avg_floor_wait(i) = 0.0
         num_floor_wait(i) = 0
      END DO

      RETURN 
      END 

C **********************************************************************
C
C     add_floor_wait ( floor, wait )
C
C **********************************************************************

      SUBROUTINE add_floor_wait ( floor, wait )
      
      INCLUDE 'agent.h'
      INTEGER floor
      REAL*4 wait

      avg_floor_wait(floor) = avg_floor_wait(floor) + wait*wait
      num_floor_wait(floor) = num_floor_wait(floor) + 1

      RETURN 
      END

C **********************************************************************
C
C     get_average_floor_wait ( floor )
C
C **********************************************************************

      REAL*8 FUNCTION get_average_floor_wait ( floor )
      
      INCLUDE 'agent.h'
      INTEGER floor

      get_average_floor_wait = 0.0
      IF (num_floor_wait(floor) .GT. 0) THEN
         get_average_floor_wait = avg_floor_wait(floor)/num_floor_wait(floor)
      END IF

      avg_floor_wait(floor) = 0.0
      num_floor_wait(floor) = 0

      RETURN
      END


