C **********************************************************************
C
C	init_net
C
C **********************************************************************

	SUBROUTINE init_net

	INCLUDE 'agent.h'

	INTEGER i,h,o,n
	REAL get_rand

	OPEN (UNIT=19, FILE='weights', status='old', ERR=300)
	
	DO n = 1,INUM_NETS
	   DO h = 1,INUM_HIDDEN_UNITS
	      DO i=1,INUM_INPUT_UNITS
		 READ (19, 100) ih_weights(i,h,n)
 100		 FORMAT (f16.8)
		 ih_dw_old(i,h,n) = 0.0D0
	      END DO
	   END DO

	   DO o = 1,INUM_OUTPUT_UNITS
	      DO h=1,INUM_HIDDEN_UNITS
		 READ (19, 100) ho_weights(h,o,n)
		 ho_dw_old(h,o,n) = 0.0D0
	      END DO
	   END DO
	END DO

	CLOSE (19)

	RETURN

C	------------------------------------------------------------
C       If there are no pre-existing weights then create some.
C	------------------------------------------------------------

 300	CONTINUE

	DO n=1, INUM_NETS
	   DO h=1, INUM_HIDDEN_UNITS
	      DO i=1, INUM_INPUT_UNITS
		 ih_weights(i,h,n) = 2.0*get_rand(0.0, 1.0) - 1.0
	      END DO
	   END DO

	   DO o=1, INUM_OUTPUT_UNITS
	      DO h=1, INUM_HIDDEN_UNITS
		 ho_weights(h,o,n) = 2.0*get_rand(0.0, 1.0) - 1.0
	      END DO
	   END DO
	END DO

	CALL write_net

	RETURN
	END

C **********************************************************************
C
C       write_net
C
C **********************************************************************

	SUBROUTINE write_net

	INCLUDE 'agent.h'

	INTEGER i,h,o,n

	OPEN (UNIT=19, FILE='weights', status='unknown')
	
	DO n = 1,INUM_NETS
	   DO h = 1,INUM_HIDDEN_UNITS
	      DO i=1,INUM_INPUT_UNITS
		 WRITE (19, 100) ih_weights(i,h,n)
 100		 FORMAT (f16.8)
	      END DO
	   END DO

	   DO o = 1,INUM_OUTPUT_UNITS
	      DO h=1,INUM_HIDDEN_UNITS
		 WRITE (19, 100) ho_weights(h,o,n)
	      END DO
	   END DO
	END DO

	CLOSE (19)

	RETURN
	END

C **********************************************************************
C
C       forward_prop
C
C **********************************************************************

	SUBROUTINE forward_prop ( input_units, n, omin, omax )

	INCLUDE 'agent.h'

	REAL*8 input_units (INUM_INPUT_UNITS)
	INTEGER n, omin, omax

	INTEGER i, h, o
	REAL*8 sum
	REAL*8 compute_logistic

	DO h=1, INUM_HIDDEN_UNITS
	  sum = 0.0D0
	  DO i=1, INUM_INPUT_UNITS
	    sum = sum + ih_weights(i,h,n)*input_units(i)
	  END DO
	  hidden_units(h) = compute_logistic ( sum, slope )
C	  print *, "Hidden(", sum, ") --> ", hidden_units(h)
	END DO

	DO o = omin, omax
	  sum = 0.0D0
	  DO h=1, INUM_HIDDEN_UNITS
	    sum = sum + ho_weights(h,o,n)*hidden_units(h)
	  END DO
	  output_units(o) = sum
C	  print *, "Output = ", output_units(o)
	END DO

	RETURN
	END

C **********************************************************************
C
C	back_prop
C
C   forward_prop should always be called before running this routine
C   in order to set the proper activations within the network.
C
C **********************************************************************

	SUBROUTINE back_prop ( input_units, error, n, onum )

	INCLUDE 'agent.h'

	REAL*8 input_units (INUM_INPUT_UNITS)
	REAL*8 error
	INTEGER n, onum

	REAL*8 delta
        REAL*8 hidden_deltas(INUM_HIDDEN_UNITS)
        REAL*8 output_deltas(INUM_OUTPUT_UNITS)
        REAL*8 ih_dw(INUM_INPUT_UNITS,INUM_HIDDEN_UNITS)
        REAL*8 ho_dw(INUM_HIDDEN_UNITS,INUM_OUTPUT_UNITS)

	INTEGER i, h, o

C	------------------------------------------------------------
C       Compute delta and set output unit.
C       ------------------------------------------------------------

	output_deltas(onum) = error

	!* -------------------------------------------------------- *!
	!* Note:  we don't multiply by the derivative of the        *!
	!*        activation function here because the output units *!
	!*        are linear in their inputs.                       *!
	!* -------------------------------------------------------- *!

C       ------------------------------------------------------------
C       Compute deltas for the hidden units.
C       ------------------------------------------------------------

	DO h=1, INUM_HIDDEN_UNITS
	  delta = 0.0D0
	  DO o=onum,onum
	     delta = delta + output_deltas(o)*ho_weights(h, o, n)
	  END DO
	  delta = delta*hidden_units(h)*(1.0D0 - hidden_units(h))
	  hidden_deltas(h) = delta
	END DO

C       ------------------------------------------------------------
C       Update weights...
C       ------------------------------------------------------------

C	------------------------------------------------------------
C       ... from input units to hidden units.
C       ------------------------------------------------------------

	DO i=1, INUM_INPUT_UNITS
	  DO h=1, INUM_HIDDEN_UNITS
	    ih_dw(i,h) = learning_rate*hidden_deltas(h)*input_units(i)
	    ih_dw(i,h) = ih_dw(i,h) + momentum*ih_dw_old(i,h,n)
	    ih_dw_old(i,h,n) = ih_dw(i,h)
            ih_weights(i,h,n) = ih_weights(i,h,n) + ih_dw(i,h)
          END DO
	END DO

C	------------------------------------------------------------
C       ... from hidden units to output units.
C       ------------------------------------------------------------

	DO h=1, INUM_HIDDEN_UNITS
	  DO o=onum,onum
            ho_dw(h,o) = learning_rate*output_deltas(o)*hidden_units(h)
	    ho_dw(h,o) = ho_dw(h,o) + momentum*ho_dw_old(h,o,n)
	    ho_dw_old(h,o,n) = ho_dw(h,o)
	    ho_weights(h,o,n) = ho_weights(h,o,n) + ho_dw(h,o)
          END DO
	END DO

	RETURN 
	END

C **********************************************************************
C
C	compute_logistic
C
C **********************************************************************

	REAL*8 FUNCTION compute_logistic ( x, slope )

	REAL*8 x, slope
	REAL*8 expo

	expo = -slope * x
	IF (expo .LT. -709.0D0) THEN
	   compute_logistic = 0.0D0
	ELSE IF (expo .GT. 709.0D0) THEN
	   compute_logistic = 1.0D0
        ELSE
	   compute_logistic = 1.0D0 / (1.0D0 + dexp(expo))
	END IF

	RETURN
	END


