C
C ****************************  SIMAN STUFF  ****************************
C

      subroutine seta(l,n,val)
      include 'siman.h'
      include 'my.h'
        atrib(n) = val
      return
      end

      subroutine create(job)
      return
      end

      subroutine dispos(job)
      return                    
      end

      subroutine insert(job,n)
      include 'siman.h'
      include 'my.h'
        call filem(n)
      return
      end

      subroutine intlc
      include 'siman.h'
      include 'my.h'
        call prime
      return
      end

      function nq(i)
      include 'siman.h'
      include 'my.h'
        nq = nnq(i)
      return
      end

      function lfr(i)
      include 'siman.h'
      include 'my.h'
        lfr = mfe(i)
      return
      end                                                            

      subroutine tally (n,value)
      include 'siman.h'
      include 'my.h'
        call colct(value,n)     
        IF (n.EQ.1) THEN
          call histo(value,1)
        END IF
      return
      end

      function a(job,i)
      include 'siman.h'
      include 'my.h'
        a = atrib(i)
      return
      end


      subroutine sched (job,n,dt)
      include 'siman.h'
      include 'my.h'          
        atrib(1) = tnow + dt
        atrib(2) = float(n)
        call filem(1)
      return
      end

      subroutine remove ( job , ifile )
      include 'siman.h'
      include 'my.h'          
        call rmove( job , ifile)
      return
      end

      function ex(ipar,istr)
    
      include 'my.h'
                   
      if (ipar .eq. 1) then
        ex = expon(1.0,1)
      elseif (ipar .eq. 2) then
        ex = expon(1.0,2)
      elseif (ipar .eq. 3) then
        ex = expon(1.0,3)
      end if             

      return
      end


      function tavg(ivar)
      include 'siman.h'
      IF (ssobv(ivar,3).GT.0) THEN
        tavg = ssobv(ivar,1) / ssobv(ivar,3)
      ELSE
        tavg = 0.0
      END IF
      return
      end

      function un(ipar,istr)
    
      include 'my.h'

      if (ipar .eq. 4) then
        un = unfrm(0.0,1.0,4)
      elseif (ipar .eq. 5) then
        un = unfrm(0.0,1.0,5)
      elseif (ipar .eq. 6) then
        un = unfrm(0.0,1.0,6)
      end if

      return
      end

C
C *********************************************************************
C

      REAL FUNCTION er(k,istrm,min_val,max_val)

      INTEGER k,istrm
      REAL    min_val,max_val

      INTEGER i
      REAL    r,val
      REAL    drand

      LOGICAL done

      done = .FALSE.

      DO WHILE (.NOT.done)

        r = 1
        DO i=1,k
          r=r*drand(istrm)
        END DO

        val=-(1.0/float(k))*alog(r)

        IF (val.GT.min_val .AND. val.LT.max_val) THEN
          done = .TRUE.
        ELSE
          done = .FALSE.
        END IF

      END DO

      er = val

      RETURN
      END

C     
C  ***************************  MAIN PROGRAM  ******************************
C

      include 'siman.h'
      include 'my.h'

      ncrdr = 1
      nprnt = 20
      call gasp()

      call clean_up()

      stop
      end


C*****  ATTENTION:
C*****      THIS CODE COMPILES ON A DEC-SYSTEM 10 F10 AND F4 COMPILERS.
C*****      TO IMPLEMENT ON OTHER COMPUTERS, THE RANDOM NUMBER GENERATOR
C*****      MAY NEED CHANGING.  SEE ALSO FUNCTION IPACK.  IN THE USERS
C*****      MAIN PROGRAM NCRDR SHOULD BE SET EQUAL TO THE INPUT DEVICE,
C*****      AND NPRNT TO THE OUTPUT DEVICE.  TO RUN THE SAMPLE TANKER
C*****      PROGRAM THE DATA VALUE IITAP MUST BE SET EQUAL TO A FORTRAN
C*****      LOGICAL DISK AREA FOR USE BY THE PLOTTING ROUTINE.
      SUBROUTINE GASP
      include 'siman.h'
      IICRD=0
  101 CALL DATIN
      MSTPP=MSTOP
      IF(LLSUP(1).NE.-1)WRITE(NPRNT,207)
      RESLS=0.01*DTSAV
      LSAVE=LLSAV
      DTACC=DTMAX
      CALL SSAVE
      JJBEG=0
C
C*****IF TNOW=TTNEX, PROCESS NEXT TIME EVENT.  IF TNOW.LT.TTNEX,
C*****ADVANCE TNOW TO TTNEX, TTFIN, OR THE FIRST STATE EVENT.
C
  102 IF (TTFIN-TTNEX) 103,104,104
  103 TTNEX=TTFIN
  104 IF (TTNEX-TNOW) 106,185,105
  105 IF (NNEQT) 107,185,108
  106 WRITE (NPRNT,208) TTNEX,TNOW
      CALL ERROR (101)
  107 CALL ERROR (102)
  108 DTFUL=DTACC
      IITES=0
      TTLAS=TNOW
      DTNOW=0.0
      CALL SCOND
      DO 109 I=1,NNEQT
      DDL(I)=DD(I)
  109 SSL(I)=SS(I)
      CALL STATE
      CALL SSAVE
      IF(ISEES)112,110,177
  110 CALL SCOND
      DO 111 I=1,NNEQT
      DDL(I)=DD(I)
  111 SSL(I)=SS(I)
      IF(ISEES)112,113,177
  112 ISEES=-ISEES
      GO TO 177
C
C*****PREPARE FOR NEW STEP.
C
  113 DTFUL=DTACC
  114 IF (TNOW+1.01*DTFUL-TTNEX) 117,115,115
  115 IITES=1
      IF(TTNEX-TNOW)106,185,116
  116 DTFUL=TTNEX-TNOW
  117 IF (TNOW+DTFUL+RESLS-TTSAV) 123,122,118
  118 IF (TNOW+DTFUL-RESLS-TTSAV) 122,122,119
  119 IF (ABS(TNOW-TTSAV)-RESLS) 120,120,121
  120 TTSAV=TTSAV+DTSAV
      LSAVE=0
      GO TO 117
  121 DTFUL=TTSAV-TNOW
      IITES=0
  122 LSAVE=1
C
C*****CHECK TO SEE IF RUNGE-KUTTA INTEGRATION IS REQUIRED.
C
  123 IF (NNEQD) 124,125,126
  124 CALL ERROR (103)
  125 TNOW=TTLAS+DTFUL
      DTNOW=DTFUL
      CALL STATE
      IBT=2
      GO TO 154
C
C*****BEGIN NEW STEP.
C
  126 LDBL=1
      DTHLF=0.5*DTFUL
      DTQRT=0.5*DTHLF
      DO 127 I=1,NNEQD
      A1(I)=DTHLF*DDL(I)
  127 SS(I)=SSL(I)+0.5*A1(I)
      TNOW=TTLAS+DTQRT
      DTNOW=TNOW-TTLAS
      CALL STATE
      DO 128 I=1,NNEQD
      A2(I)=DTHLF*DD(I)
  128 SS(I)=SSL(I)+0.25*(A1(I)+A2(I))
      CALL STATE
      DO 129 I=1,NNEQD
      A3(I)=DTHLF*DD(I)
  129 SS(I)=SSL(I)-A2(I)+A3(I)+A3(I)
      TNOW=TTLAS+DTHLF
      DTNOW=TNOW-TTLAS
      CALL STATE
      DO 130 I=1,NNEQD
      A4(I)=DTHLF*DD(I)
  130 SS(I)=SSL(I)+(A1(I)+4.0*A3(I)+A4(I))/6.0
C
C*****CHECK FOR STATE EVENTS AT HALF STEP.
C
      CALL SCOND
      IF (ISEES) 131,132,132
  131 IBT=0
      IF (DTFUL-DTMIN) 132,132,164
C
C*****STORE HALF STEP VALUES.
C
  132 DO 133 I=1,NNEQT
      DI(I)=DD(I)
  133 SI(I)=SS(I)
      CALL STATE
      DO 134 I=1,NNEQD
      A5(I)=DTHLF*DD(I)
  134 SS(I)=SI(I)+0.5*A5(I)
      TNOW=TTLAS+DTHLF+DTQRT
      DTNOW=TNOW-TTLAS
      CALL STATE
      DO 135 I=1,NNEQD
      A6(I)=DTHLF*DD(I)
  135 SS(I)=SI(I)+0.25*(A5(I)+A6(I))
      CALL STATE
      DO 136 I=1,NNEQD
      A7(I)=DTHLF*DD(I)
  136 SS(I)=SSL(I)+(-A1(I)-96.0*A2(I)+92.0*A3(I)-121.0*A4(I)+144.0*A5(I)
     1+6.0*A6(I)-12.0*A7(I))/6.0
      TNOW=TTLAS+DTFUL
      DTNOW=DTFUL
      CALL STATE
C
C*****CHECK FOR ACCEPTABLE ACCURACY AT FULL STEP.
C
      DO 149 I=1,NNEQD
      EERR=ABS((-A1(I)+4.0*A3(I)+17.0*A4(I)-23.0*A5(I)+4.0*A7(I)-DTHLF*D
     1D(I))/90.0)
      TERR=AAERR+ABS(RRERR*SI(I))
      IF (EERR-TERR) 137,148,138
  137 IF (EERR-0.02*TERR) 149,149,148
  138 IF (DTFUL-DTMIN) 141,141,139
  139 DTACC=0.5*DTFUL
      IBT=1
      IF (DTACC-DTMIN) 140,165,165
  140 DTACC=DTMIN
      GO TO 165
  141 IF (ISEES) 142,144,143
  142 IBT=-1
      GO TO 155
  143 ERTIM=TTLAS+DTHLF
      GO TO 145
  144 ERTIM=TNOW
  145 IF (LLERR) 148,147,146
  146 WRITE (NPRNT,209) I,ERTIM
      CALL ERROR (104)
  147 WRITE (NPRNT,209) I,ERTIM
  148 LDBL=0
  149 CONTINUE
C
C*****ACCURACY IS ACCEPTABLE.  CHECK FOR STATE EVENT AT HALF STEP.
C
      IF (ISEES) 155,150,170
C
C*****NO STATE EVENT AT HALF STEP.  UPDATE STATUS TO HALF STEP AND
C*****CONTINUE.
C
  150 DO 151 I=1,NNEQT
      DDL(I)=DI(I)
  151 SSL(I)=SI(I)
      TTLAS=TTLAS+DTHLF
      DTNOW=TNOW-TTLAS
      DO 152 I=1,NNEQD
  152 SS(I)=SI(I)-A6(I)+A7(I)+A7(I)
      CALL STATE
      DO 153 I=1,NNEQD
  153 SS(I)=SI(I)+(A5(I)+4.0*A7(I)+DTHLF*DD(I))/6.0
      IF(NNEQS.GT.0)CALL STATE
C
C*****CHECK FOR STATE EVENTS AT FULL STEP.
C
      IBT=1
  154 CALL SCOND
      IF (ISEES) 155,172,172
C
C*****PASSED STATE EVENT.
C
  155 IF (DTFUL-DTMIN) 157,157,156
  156 IF(IBT-1)164,165,165
  157 ERTIM=TNOW
      IF (IBT.LE.0) ERTIM=TTLAS+DTHLF
      IF (LLERR) 161,158,158
  158 IF (ISEES+1000) 160,159,159
  159 I=-ISEES
      WRITE (NPRNT,210) I,ERTIM
      GO TO 161
  160 I=-ISEES-1000
      WRITE (NPRNT,211) I,ERTIM
  161 ISEES=-ISEES
      IF (LLERR) 162,162,163
  162 IF (IBT) 170,170,172
  163 CALL ERROR (105)
  164 DTFUL=0.5*DTFUL
  165 ISEES=0
C
C*****REDUCE STEP SIZE, RETURN TO TTLAS, AND CONTINUE.
C
      IITES=0
      LSAVE=LLSAV
      TNOW=TTLAS
      DTFUL=0.5*DTFUL
      IF (DTFUL-DTMIN) 166,167,167
  166 DTFUL=DTMIN
  167 IF(IBT-1)126,114,168
  168 DO 169 I=1,NNEQT
      DD(I)=DDL(I)
  169 SS(I)=SSL(I)
      GO TO 125
C
C*****STATE EVENT AT HALF STEP. UPDATE STATUS TO HALF STEP.
C
  170 IITES=0
      LSAVE=LLSAV
      DO 171 I=1,NNEQT
      DD(I)=DI(I)
      DDL(I)=DD(I)
      SS(I)=SI(I)
  171 SSL(I)=SS(I)
      TNOW=TTLAS+DTHLF
      TTLAS=TNOW
      DTNOW=0.0
      GO TO 174
C
C*****FULL STEP VALUES ARE GOOD.  UPDATE STATUS TO FULL STEP AND
C*****CONTINUE.
C
  172 DO 173 I=1,NNEQT
      DDL(I)=DD(I)
  173 SSL(I)=SS(I)
      TTLAS=TNOW
      DTNOW=0.0
C
C*****CHECK TO SEE IF TNOW IS A SAVE TIME.
C
      IF (LSAVE+IITES+ISEES) 176,176,174
C
C*****SAVE VALUES.
C
  174 CALL SSAVE
      IF (LSAVE-1) 176,175,176
  175 TTSAV=TTSAV+DTSAV
      LSAVE=0
C
C*****IF TNOW IS NOT AN EVENT TIME, START NEW STEP. IF TNOW IS A
C*****STATE EVENT TIME, PROCESS STATE EVENT. IF TNOW IS A TIME EVENT
C*****TIME BUT NOT A STATE EVENT TIME, PROCESS TIME EVENT.
C
  176 IF (ISEES+ISEES+IITES-1) 180,185,177
C
C*****TNOW IS A STATE EVENT TIME. PROCESS STATE EVENT.
C
  177 IF(MMNIT.GT.0) CALL MONTR
      CALL EVNTS(IIEVT)
      ISEES=0
      IITES=1
      IF (NFLAG) 194,194,178
  178 DO 179 I=1,NFLAG
  179 LFLAG(I)=0
      IF(TNOW-TTNEX)194,185,106
C
C*****TNOW IS NOT AN EVENT TIME.  CHECK TO SEE IF STEP SIZE CAN BE
C*****INCREASED.  CONTINUE.
C
  180 IF (NNEQD) 113,113,181
  181 IF (DTACC-DTMAX) 182,113,184
  182 IF (LDBL) 113,113,183
  183 DTACC=DTACC+DTACC
      IF (DTACC-DTMAX) 113,113,184
  184 DTACC=DTMAX
      GO TO 113
C
C*****FIRST ENTRY IN FILE 1 IS NEXT EVENT. IF FILE 1 IS EMPTY,
C*****TNOW=TTNEX=TTFIN, RUN IS COMPLETED.
C
  185 IF (NNQ(1)) 187,186,188
186	WRITE(NPRNT,212)TNOW
	GO TO 197
  187 CALL ERROR (106)
C
C*****SET TNOW=ATRIB(1) AND JEVNT=ATRIB(2) AND CALL RMOVE TO LOAD ENTRY
C*****INTO ATRIB.
C
  188 NEXTE=MFE(1)
      TNOW=QSET(NEXTE+1)
      JEVNT=QSET(NEXTE+2)
      IF (TNOW-TTFIN) 190,190,189
  189 TNOW=TTFIN
      GO TO 197
  190 CALL RMOVE (NEXTE,1)
C
C*****TEST TO SEE IF THIS EVENT IS A MONITOR EVENT.
C
      IF (JEVNT) 202,203,191
  191 IF (MMNIT) 204,193,192
  192 CALL MONTR
C
C*****CALL PROGRAMMERS EVENT ROUTINES.
C
  193 CALL EVNTS (JEVNT)
C
C*****TEST METHOD FOR STOPPING.
C
  194 IF(MSTOP) 196,195,195
  195 IF (TNOW-TTFIN) 102,197,197
  196 MSTOP=MSTPP
C
C*****TEST FOR NO SUMMARY REPORT.
C
  197 CALL SSAVE
      CALL OTPUT
      IF (LLSUP(15)) 198,198,199
  198 CALL SUMRY
C
C*****TEST NUMBER OF RUNS REMAINING.
C
  199 CALL compute_stats (TNOW,NNRUN)  !! call added by crites 6/95
      IF (NNRNS-1) 201,206,200
  200 NNRNS=NNRNS-1
      NNRUN=NNRUN+1
      GO TO 101
  201 CALL ERROR (107)
  202 CALL MONTR
      GO TO 102
C
C*****RESET MMNIT.
C
  203 IF (MMNIT) 204,204,205
  204 MMNIT=1
      GO TO 102
  205 MMNIT=0
      GO TO 102
C
C*****ALL RUNS ARE COMPLETED.  RETURN TO MAIN PROGRAM.
C
  206 RETURN
C
  207 FORMAT (1H1,45X,24H**INTERMEDIATE RESULTS**//)
  208 FORMAT (///36X,6HTTNEX=,E17.9,5X,5HTNOW=,E17.9)
  209 FORMAT (/2X,38HSPECIFIED LOCAL ERROR EXCEEDED FOR SS(,I3,9H) AT TI
     1ME,E12.4)
  210 FORMAT (/2X,38HSPECIFIED	TOLERANCE  EXCEEDED FOR SS(,I3,9H) AT TI
     1ME,E12.4)
  211 FORMAT (/2X,38HSPECIFIED	TOLERANCE  EXCEEDED FOR DD(,I3,9H) AT TI
     1ME,E12.4)
  212 FORMAT (12X,24HSIMULATION ENDED AT TIME,F14.4,2X,28HWITH NO EVENTS
     1 IN EVENT FILE)
      END

      SUBROUTINE DATIN
      INTEGER IINNA(4)
      INTEGER KREAD(16)
      include 'siman.h'
C
C*****(CHANGES TO THE FOLLOWING DATA STATEMENT SHOULD ALSO BE MADE
C*****IN SUBROUTINE DFAUT)
C
      DATA MEQT,MHIST,MCELS,MCLCT,MSTAT,MATRB,MFILS,MPRMS,MPLOT,MVARP,MS
     1TRM,MFLAG/100,25,500,25,25,25,100,50,10,10,6,50/
      DATA LY/1HY/,LN/1HN/,ICOMA/1H,/,ISTAR/1H*/
      DATA IINNA(1),IINNA(2),IINNA(3),IINNA(4)/4HLVF ,4HHVF ,4HFIFO,4HLIFO/
      DATA IBLNK/1H /
C
C*****(CHANGES TO THE FOLLOWING DATA STATEMENT SHOULD ALSO
C*****BE MADE IN SUBROUTINE DFAUT)
C
      DATA HIVAL/1.E20/
C
C*****ASSIGN DEFAULT VALUE IF FIRST EXECUTION OF DATIN / (SUBROUTINE
C*****GASP INITIALIZES IICRD TO 0 PRIOR TO 1ST CALL OF DATIN)
C
      IF (IICRD.EQ.1) GO TO 105
      CALL DFAUT (0)
      IIFIN=0
      MORE=0
      NNFLD=50
      GO TO 110
  105 JJBEG=JBEGG
  110 IERRW=0
      IERRF=0
      DO 115 I=1,16
  115 KREAD(I)=0
      IP=0
C
C*****IF NO INPUT CARDS THIS RUN, BRANCH TO INITIALIZE
C
      IF (IIFIN.EQ.1) GO TO 805
C*****
C****************
C***** READ *****
C****************
C*****
      WRITE (NPRNT,1110)
  120 READ (NCRDR,1100) KARD
      IF (IIECH.EQ.LY) WRITE (NPRNT,1105) KARD
      CALL BUILD
      IF (MORE .EQ.1) GO TO 120
      KRDNO=IMAP(1)
      IF (KRDNO.GT.0) GO TO 125
C
C*****KARDNO = 0  / IF BLANK CARD, ASSUME END OF INPUT	/ ELSE, ERROR
C
      KRDNO=16
      IF ((NNFLD.EQ.1).AND.(IFLAG(1).EQ.4)) GO TO 125
      CALL ERRIN (171)
      GO TO 120
  125 KREAD(KRDNO)=KREAD(KRDNO)+1
      GO TO (130,235,265,320,345,375,415,455,515,560,605,630,665,685,720
     1,725), KRDNO
C*****
C********************
C***** GEN CARD *****
C********************
C*****
C
C*****FIELD 1 - USERS NAME
C
C*****(ESTABLISH VALUE FOR NPRT2 (FIELD 8) FIRST SINCE NPRT2 WILL BE
C*****USED IN PROCESSING REMAINDER OF CARD)
C
  130 IF (IFLAG(8).EQ.4) GO TO 135
      IF (IVALU(8).LE.0) GO TO 135
      NPRT2=IVALU(8)
  135 IF (IFLAG(2).EQ.4) GO TO 170
C
C*****(BLANKS ARE SIGNIFICANT IN THE NAME FIELD / HENCE CHARACTERS
C*****OF NAME (UP TO TWELVE)
C*****MUST BE EXTRACTED FROM INPUT CARD ITSELF RATHER THAN FROM IALPH
C*****ARRAY / THE NAME FIELD BEGINS IMMEDIATELY FOLLOWING THE 1ST COMMA
C*****OF GEN CARD )
C
      DO 140 I=1,79
	 IF (KARD(I).EQ.ICOMA) GO TO 145
  140 CONTINUE
      I=79
  145 IOVER=0
      DO 165 K=1,3
	 DO 160 J=1,4
            IF (IOVER.EQ.1) GOTO 155
            I=I+1
            ICHAR=KARD(I)
            IF (ICHAR.EQ.ICOMA) GOTO 150
            IF (I.GT.80) GOTO 150
            IF (ICHAR.NE.ISTAR) GOTO 160
  150	    IOVER=1
  155	    ICHAR=IBLNK
  160	 IALPH(J,2)=ICHAR
	 NNAME(K)=IPACK(1,4,2)
  165 CONTINUE
  170 IF (IFLAG(3).EQ.4) GO TO 175
      IF (IFLAG(3).EQ.3) CALL ERRIN (180)
      NNPRJ=IVALU(3)
C
C*****(FIELDS 4 - 8 SHOULD BE NUMERIC OR DEFAULT)
C
  175 DO 180 I=4,8
	 IF (IFLAG(I).EQ.3) CALL ERRIN (180)
  180 CONTINUE
      IF (IFLAG(4).EQ.4) GO TO 185
      MMON=IVALU(4)
  185 IF (IFLAG(5).EQ.4) GO TO 190
      NNDAY=IVALU(5)
  190 IF (IFLAG(6).EQ.4) GO TO 195
      NNYR=IVALU(6)
  195 IF (IFLAG(7).EQ.4) GO TO 200
      NNRNS=IVALU(7)
C
C*****(FIELDS 9 - 13 SHOULD BE 'YES' OR 'NO')
C
  200 DO 205 I=9,13
	 IF (IFLAG(I).EQ.4) GO TO 205
	 IF (IALPH(1,I).EQ.LN) GO TO 205
	 IF (IALPH(1,I).EQ.LY) GO TO 205
	 CALL ERRIN (178)
	 IALPH(1,I)=LY
  205 CONTINUE
      IF (IFLAG(9).EQ.4) GO TO 210
      IIECH=IALPH(1,9)
  210 IF (IFLAG(10).EQ.4) GO TO 215
      IIPOF=IALPH(1,10)
  215 IF (IFLAG(11).EQ.4) GO TO 220
      IIPOS=IALPH(1,11)
  220 IF (IFLAG(12).EQ.4) GO TO 225
      IISUM=IALPH(1,12)
      LLSUP(15)=1
      IF (IISUM.EQ.LN) GO TO 230
  225 LLSUP(15)=0
  230 IF (IFLAG(13).EQ.4) GO TO 232
      IIPIR=IALPH(1,13)
      LLSUP(1)=-1
      IF (IIPIR.EQ.LN) GO TO 234
  232 LLSUP(1)=0
  234 IF (NNFLD.GT.13) CALL ERRIN(170)
      GO TO 120
C*****
C*********************
C***** STAT CARD *****
C*********************
C*****
C*****(FIELDS 2 - 4 SHOULD BE NUMERIC OR DEFAULT / ALL NUMERIC VALUES
C*****SHOULD BE NON-NEGATIVE)
C
  235 DO 240 I=2,5
	 IF (IFLAG(I).EQ.3) CALL ERRIN (180)
	 IF (IVALU(I).LT.0) IVALU(I)=0
  240 CONTINUE
      IF (IFLAG(2).EQ.4) GO TO 245
      NNCLT=IVALU(2)
      IF (NNCLT.LE.MCLCT) GO TO 245
      CALL ERRIN (204)
      NNCLT=MCLCT
  245 IF (IFLAG(3).EQ.4) GO TO 250
      NNSTA=IVALU(3)
      IF (NNSTA.LE.MSTAT) GO TO 250
      CALL ERRIN(205)
      NNSTA=MSTAT
  250 IF (IFLAG(4).EQ.4) GO TO 255
      NNHIS=IVALU(4)
      IF (NNHIS.LE.MHIST) GO TO 255
      CALL ERRIN(206)
      NNHIS=MHIST
  255 IF (IFLAG(5).EQ.4) GO TO 260
      NNPLT=IVALU(5)
      IF (NNPLT.LE.MPLOT) GO TO 260
      CALL ERRIN(207)
      NNPLT=MPLOT
  260 IF (NNFLD.GT.5) CALL ERRIN(170)
      GO TO 120
C*****
C***********************
C***** LIMITS CARD *****
C***********************
C*****
C*****(FIELDS 2 - 10 SHOULD BE NUMERIC OR DEFAULT / ALL NUMERIC VALUES
C*****SHOULD BE NON-NEGATIVE)
C
  265 DO 270 I=2,10
	 IF (IFLAG(I).EQ.3) CALL ERRIN (180)
	 IF (IVALU(I).LT.0) IVALU(I)=0
  270 CONTINUE
      IF (IFLAG(2).EQ.4) GO TO 275
      NNPRM=IVALU(2)
      IF (NNPRM.LE.MPRMS) GO TO 275
      CALL ERRIN(199)
      NNPRM=MPRMS
  275 IF (IFLAG(3).EQ.4) GO TO 280
      NNSTR=IVALU(3)
      IF (NNSTR.LE.0) NNSTR=1
      IF (NNSTR.LE.MSTRM) GO TO 280
      CALL ERRIN(197)
      NNSTR=MSTRM
  280 IF (IFLAG(4).EQ.4) GO TO 285
      NNTRY=IVALU(4)
  285 IF (IFLAG(5).EQ.4) GO TO 290
      NNATR=IVALU(5)
      IF (NNATR.LE.MATRB) GO TO 290
      CALL ERRIN(208)
      NNATR=MATRB
  290 NNAPO=NNATR+1
      NNAPT=NNATR+2
      NNCFI=NNTRY*NNAPT
      IF (IFLAG(6).EQ.4) GO TO 295
      NNFIL=IVALU(6)
      IF (NNFIL.LE.MFILS) GO TO 295
      CALL ERRIN(209)
      NNFIL=MFILS
  295 IF (IFLAG(7).EQ.4) GO TO 300
      NNSET=IVALU(7)
  300 IF (NNCFI.GT.NNSET) CALL ERRIN (202)
      IF (IFLAG(8).EQ.4) GO TO 305
      NNEQD=IVALU(8)
  305 IF (IFLAG(9).EQ.4) GO TO 310
      NNEQS=IVALU(9)
  310 NNEQT=NNEQD+NNEQS
      IF (NNEQT.LE.MEQT) GO TO 313
      CALL ERRIN(198)
      NNEQD=0
      NNEQS=0
  313 IF (IFLAG(10).EQ.4) GO TO 315
      NFLAG=IVALU(10)
      IF (NFLAG.LE.MFLAG) GO TO 315
      CALL ERRIN(200)
      NFLAG=MFLAG
  315 IF (NNFLD.GT.10) CALL ERRIN(170)
      GO TO 120
C*****
C**********************
C***** COLCT CARD *****
C**********************
C*****
  320 K=2
  325 ICLCT=IVALU(K)
      IF ((ICLCT.LE.0).OR.(ICLCT.GT.MCLCT)) GO TO 335
      IF (ICLCT.GT.NNCLT) NNCLT=ICLCT
      K=K+1
      IF (IFLAG(K).EQ.4) GO TO 330
      LLABC(ICLCT,1)=IPACK(1,4,K)
      LLABC(ICLCT,2)=IPACK(5,8,K)
  330 IF (K.GE.NNFLD) GO TO 340
      K=K+1
      GO TO 325
  335 CALL ERRIN (185)
  340 GO TO 120
C*****
C**********************
C***** TIMST CARD *****
C**********************
C*****
  345 K=2
  350 ISTAT=IVALU(K)
      IF ((ISTAT.LE.0).OR.(ISTAT.GT.MSTAT)) GO TO 365
      IF (ISTAT.GT.NNSTA) NNSTA=ISTAT
      K=K+1
      IF (IFLAG(K).EQ.4) GO TO 355
      LLABT(ISTAT,1)=IPACK(1,4,K)
      LLABT(ISTAT,2)=IPACK(5,8,K)
  355 K=K+1
      IF (IFLAG(K).EQ.4) GO TO 360
      IF (IFLAG(K).EQ.3) CALL ERRIN (180)
      SSTPV(ISTAT,6)=RVALU(K)
  360 IF (K.GE.NNFLD) GO TO 370
      K=K+1
      GO TO 350
  365 CALL ERRIN (185)
  370 GO TO 120
C****
C*****
C**********************
C***** HISTO CARD *****
C**********************
C*****
  375 K=2
  380 IHIST=IVALU(K)
      IF ((IHIST.LE.0).OR.(IHIST.GT.MHIST)) GO TO 405
      IF (IHIST.GT.NNHIS) NNHIS=IHIST
      K=K+1
      IF (IFLAG(K).EQ.4) GO TO 385
      LLABH(IHIST,1)=IPACK(1,4,K)
      LLABH(IHIST,2)=IPACK(5,8,K)
  385 K=K+1
      IF (IFLAG(K).EQ.4) GO TO 390
      IF (IFLAG(K).EQ.3) CALL ERRIN (180)
      IF (IVALU(K).LE.0) GO TO 390
      NNCEL(IHIST)=IVALU(K)
  390 K=K+1
      IF (IFLAG(K).EQ.4) GO TO 395
      IF (IFLAG(K).EQ.3) CALL ERRIN (180)
      HHLOW(IHIST)=RVALU(K)
  395 K=K+1
      IF (IFLAG(K).EQ.4) GO TO 400
      IF (IFLAG(K).EQ.3) CALL ERRIN (180)
      IF (RVALU(K).LE.0.) GO TO 400
      HHWID(IHIST)=RVALU(K)
  400 IF (K.GE.NNFLD) GO TO 410
      K=K+1
      GO TO 380
  405 CALL ERRIN (185)
  410 GO TO 120
C*****
C**********************
C***** PLOTS CARD *****
C**********************
C*****
  415 IP=IVALU(2)
      CALL DFAUT (1)
      IF ((IP.LE.0).OR.(IP.GT.MPLOT)) GO TO 445
      IF (IP.GT.NNPLT) NNPLT=IP
      IF (IFLAG(3).EQ.4) GO TO 420
      LLABP(11,1)=IPACK(1,4,3)
      LLABP(11,2)=IPACK(5,8,3)
C
C*****(FIELDS 4 - 7 SHOULD BE NUMERIC OR DEFAULT)
C
  420 DO 425 I=4,7
	 IF (IFLAG(I).EQ.3) CALL ERRIN (180)
  425 CONTINUE
      IF (IFLAG(4).EQ.4) GO TO 430
      IF (IVALU(4).LT.0) GO TO 430
      IITAP(IP)=IVALU(4)
      IF ((IITAP(IP).EQ.0).AND.(NNPLT.GT.1)) CALL ERRIN(193)
  430 IF (IFLAG(5).EQ.4) GO TO 435
      IF (IVALU(5).LE.0) GO TO 435
      NNVAR(IP)=IVALU(5)
      IF (NNVAR(IP).LE.MVARP) GO TO 435
      CALL ERRIN(182)
      NNVAR(IP)=MVARP
  435 IF (IFLAG(6).EQ.4) GO TO 440
      LLPLT=IVALU(6)
  440 IF (IFLAG(7).EQ.4) GO TO 450
      DTPLT(IP)=RVALU(7)
      GO TO 450
  445 CALL ERRIN (185)
  450 IF (NNFLD.GT.7) CALL ERRIN(170)
      GO TO 120
C*****
C***********************
C***** VARPLT CARD *****
C***********************
C*****
  455 K=3
      IF (IVALU(2).EQ.IP) GO TO 460
      CALL ERRIN (187)
      GO TO 510
  460 IJ=IVALU(K)
      IF ((IJ.LE.0).OR.(IJ.GT.MVARP)) GO TO 505
      IF (IJ.GT.NNVAR(IP)) NNVAR(IP)=IJ
      K=K+1
      IF (IFLAG(K).EQ.4) GO TO 465
      LLSYM(IJ)=IALPH(1,K)
  465 K=K+1
      IF (IFLAG(K).EQ.4) GO TO 470
      LLABP(IJ,1)=IPACK(1,4,K)
      LLABP(IJ,2)=IPACK(5,8,K)
C
C*****(NEXT 4 FIELDS SHOULD BE NUMERIC OR DEFAULT)
C
  470 K=K+1
      LIMIT=K+3
      DO 475 I=K,LIMIT
	 IF (IFLAG(I).EQ.3) CALL ERRIN (180)
  475 CONTINUE
      IF (IFLAG(K).EQ.4) GO TO 480
      IF ((IVALU(K).LT.0).OR.(IVALU(K).GT.2)) GO TO 480
      LLPLO(IJ)=IVALU(K)
  480 K=K+1
      IF (IFLAG(K).EQ.4) GO TO 485
      IF ((IVALU(K).LT.0).OR.(IVALU(K).GT.2)) GO TO 485
      LLPHI(IJ)=IVALU(K)
  485 K=K+1
      IF (IFLAG(K).EQ.4) GO TO 490
      PPLO(IJ)=RVALU(K)
  490 K=K+1
      IF (IFLAG(K).EQ.4) GO TO 495
      PPHI(IJ)=RVALU(K)
  495 IF (K.GE.NNFLD) GO TO 500
      K=K+1
      GO TO 460
  500 IT=IITAP(IP)
      IF (IT.EQ.0) GO TO 510
      REWIND IT
      WRITE (IT) LLPLT,LLSYM,LLABP,LLPLO,PPLO,LLPHI,PPHI
      GO TO 510
  505 CALL ERRIN (185)
  510 GO TO 120
C****
C*************************
C***** PRIORITY CARD *****
C*************************
C*****
  515 K=2
  520 I=IVALU(K)
      IF ((I.LE.0).OR.(I.GT.MFILS)) GO TO 550
      IF (I.GT.NNFIL) NNFIL=I
      K=K+1
      IF (IFLAG(K).EQ.4) GO TO 535
      ITEMP=IPACK(1,4,K)
      DO 525 J=1,4
	 IF (ITEMP.EQ.IINNA(J)) GO TO 530
  525 CONTINUE
      CALL ERRIN (188)
      GO TO 555
  530 IINN(I)=J
  535 K=K+1
      IF (IFLAG(K).EQ.4) GO TO 545
      IF (IINN(I).GT.2) GO TO 545
      IF ((IVALU(K).GT.0).AND.(IVALU(K).LE.NNATR)) GO TO 540
      CALL ERRIN (184)
      GO TO 545
  540 KKRNK(I)=IVALU(K)
  545 IF (K.GE.NNFLD) GO TO 555
      K=K+1
      GO TO 520
  550 CALL ERRIN (185)
  555 GO TO 120
C*****
C*********************
C***** CONT CARD *****
C*********************
C*****
C*****(FIELDS 2 - 8 SHOULD BE NUMERIC OR DEFAULT)
C
  560 IF ((NNEQS+NNEQD).LE.0) CALL ERRIN (176)
      DO 565 I=2,8
	 IF (IFLAG(I).EQ.3) CALL ERRIN (180)
  565 CONTINUE
      IF (IFLAG(2).EQ.4) GO TO 570
      IIEVT=IVALU(2)
  570 IF (IFLAG(3).EQ.4) GO TO 575
      IF ((IVALU(3).LT.-1).OR.(IVALU(3).GT.1)) GO TO 575
      LLERR=IVALU(3)
  575 IF (IFLAG(4).EQ.4) GO TO 580
      AAERR=RVALU(4)
  580 IF (IFLAG(5).EQ.4) GO TO 585
      RRERR=RVALU(5)
  585 IF (IFLAG(6).EQ.4) GO TO 590
      DTMIN=RVALU(6)
  590 IF (IFLAG(7).EQ.4) GO TO 595
      DTMAX=RVALU(7)
  595 IF (IFLAG(8).EQ.4) GO TO 600
      DTSAV=RVALU(8)
  600 IF (NNFLD.GT.8) CALL ERRIN(170)
      GO TO 120
C*****
C********************
C***** PAR CARD *****
C********************
C*****
  605 K=2
  610 J=IVALU(K)
      IF ((J.LE.0).OR.(J.GT.MPRMS)) GO TO 620
      IF (J.GT.NNPRM) NNPRM=J
      DO 615 I=1,4
	 K=K+1
	 IF (IFLAG(K).EQ.4) GO TO 615
	 IF (IFLAG(K).EQ.3) CALL ERRIN (180)
	 PPARM(J,I)=RVALU(K)
  615 CONTINUE
      IF (K.GE.NNFLD) GO TO 625
      K=K+1
      GO TO 610
  620 CALL ERRIN (186)
  625 GO TO 120
C*****
C*********************
C***** INIT CARD *****
C*********************
C*****
  630 IF (IFLAG(2).EQ.4) GO TO 635
      IF (IFLAG(2).EQ.3) CALL ERRIN (180)
      MSTOP=IVALU(2)
  635 IF (IFLAG(3).EQ.4) GO TO 640
      JJCLR=0
      IF (IALPH(1,3).EQ.LN) GO TO 640
      JJCLR=1
      IF (IALPH(1,3).NE.LY) CALL ERRIN (178)
  640 IF (IFLAG(4).EQ.4) GO TO 645
      JJBEG=0
      IF (IALPH(1,4).EQ.LN) GO TO 645
      JJBEG=1
      IF (IALPH(1,4).NE.LY) CALL ERRIN (178)
  645 IF (IFLAG(5).EQ.4) GO TO 650
      IF (IFLAG(5).EQ.3) CALL ERRIN (180)
      TTBEG=RVALU(5)
  650 IF (IFLAG(6).EQ.4) GO TO 655
      IF (IFLAG(6).EQ.3) CALL ERRIN (180)
      TTFIN=RVALU(6)
  655 IF (IFLAG(7).EQ.4) GO TO 660
      JJFIL=0
      IF (IALPH(1,7).EQ.LN) GO TO 660
      JJFIL=1
      IF (IALPH(1,7).NE.LY) CALL ERRIN (178)
  660 IF (NNFLD.GT.7) CALL ERRIN(170)
      GO TO 120
C*****
C**********************
C***** SEEDS CARD *****
C**********************
C*****
  665 IF (NNFLD.EQ.1) GO TO 680
      LIMIT=NNFLD
      IF (LIMIT.LE.(MSTRM+1)) GO TO 670
      CALL ERRIN (186)
      LIMIT=MSTRM+1
  670 DO 675 I=2,LIMIT
	 K=I-1
	 IF (IFLAG(I).EQ.4) GO TO 675
	 IF (IFLAG(I).EQ.3) CALL ERRIN (180)
	 IISED(K)=IVALU(I)
  675 SSEED(K)=IISED(K)
      IF (K.GT.NNSTR) NNSTR=K
  680 GO TO 120
C*****
C**********************
C***** ENTRY CARD *****
C**********************
C*****
  685 K=2
C
C*****IF FIRST ENTRY CARD FOR THIS RUN, CALL SET TO INITIALIZE FILES
C*****PRIOR TO STORING ENTRY
C
      IF (KREAD(14).GT.1) GO TO 690
      IF (JJBEG.EQ.1) TNOW=TTBEG
      IF (JJFIL.EQ.1) CALL SET
  690 IFILE=IVALU(K)
      IF ((IFILE.LE.0).OR.(IFILE.GT.MFILS)) GO TO 710
      IF (IFILE.GT.NNFIL) GO TO 705
      DO 695 J=1,NNATR
	 K=K+1
	 ATRIB(J)=0.
	 IF (IFLAG(K).EQ.4) GO TO 695
	 IF (IFLAG(K).EQ.3) CALL ERRIN (180)
	 ATRIB(J)=RVALU(K)
  695 CONTINUE
      CALL FILEM (IFILE)
      IF (K.GE.NNFLD) GO TO 715
      K=K+1
      GO TO 690
  705 CALL ERRIN (191)
      GO TO 715
  710 CALL ERRIN (185)
  715 GO TO 120
C*****
C********************
C***** SIM CARD *****
C********************
C*****
  720 GO TO 730
C*****
C********************
C***** FIN CARD *****
C********************
C*****
  725 IIFIN=1
C*****
C***************************
C***** EDIT/INITIALIZE *****
C***************************
C*****
  730 IF (IICRD.EQ.1) GO TO 735
      NNRUN=1
      NRTOT=NNRNS
  735 JBEGG=JJBEG
      IF (NNPLT.EQ.1) MMPTS=(NNSET-NNCFI)/(NNVAR(1)+1)
      IF (DTMAX) 755,755,760
  755 DTMAX=HIVAL
  760 IF (DTSAV.GT.0.0.AND.DTMAX.GT.DTSAV) DTMAX=DTSAV
      IF (DTMIN) 765,765,770
  765 DTMIN=0.01*DTMAX
  770 IF (DTMAX-DTMIN) 775,780,780
  775 DTMIN=DTMAX
  780 IF ((AAERR+RRERR).GT.0.) GO TO 785
      AAERR=.00001
      RRERR=.00001
  785 IF (MSTOP.LT.0) MSTOP=0
      IF (MSTOP.GT.1) MSTOP=1
C
C*****(BYPASS THIS SECTION IF NO HISTO CARD READ)
C*****(EXCEPTION -- 1ST RUN AND NNHIS .GT. 0)
C
      IF (KREAD(6).GT.0) GO TO 790
      IF ((IICRD.EQ.1).OR.(NNHIS.EQ.0)) GO TO 805
  790 NNCEL(1)=NNCEL(1)+2
      IF (NNHIS-1) 805,803,795
  795 DO 800 I=2,NNHIS
  800 NNCEL(I)=NNCEL(I)+NNCEL(I-1)+2
  803 IF (NNCEL(NNHIS).LE.MCELS) GO TO 805
      NNCEL(NNHIS)=MCELS
C
C*****JJBEG POSITIVE
C
  805 IF (JJBEG) 850,850,810
  810 DO 815 I=1,NNSTR
  815 RNUM=DRAND(-I)
      TNOW=TTBEG
      TTLAS=TNOW
      IF (TTFIN.LE.0.0) TTFIN=HIVAL
      IF (MSTOP.EQ.0) TTFIN=HIVAL
C*****(IF NO EVENTS HAVE BEEN SCHEDULED, SET TTNEX TO TTFIN)
      IF (KREAD(14).EQ.0) GO TO 820
      IF (NNQ(1).GT.0) GO TO 825
  820 TTNEX=TTFIN
  825 IF (DTSAV) 835,840,830
  830 LLSAV=0
      TTSAV=TTBEG+DTSAV
      GO TO 850
  835 LLSAV=0
      GO TO 845
  840 LLSAV=2
  845 TTSAV=HIVAL
C
C*****JJFIL POSITIVE
C
  850 IF (NNFIL.EQ.0) JJFIL=0
      IF (JJFIL) 860,860,855
C*****(IF ENTRY CARD WAS INPUT FOR THIS RUN, THEN SET HAS ALREADY BEEN
C*****CALLED AND THIS CALL MUST BE BYPASSED )
  855 IF  (KREAD(14).EQ.0) CALL SET
C
C*****JJCLR POSITIVE
C
  860 IF  (JJCLR.EQ.1) CALL CLEAR
C
C*****JJBEG POSITIVE
C
      IF (JJBEG) 915,915,875
  875 IF (NNEQT.EQ.0) GO TO 885
      DO 880 I=1,NNEQT
	 SS(I)=0.0
  880 DD(I)=0.0
  885 CALL INTLC
      IF (NNEQT) 915,915,890
  890 DTFUL=DTMAX
      DTNOW=0.
      ISEES=0
      DO 895 I=1,NNEQT
	 DDL(I)=DD(I)
  895 SSL(I)=SS(I)
      CALL STATE
      DO 900 I=1,NNEQT
	 DDL(I)=DD(I)
  900 SSL(I)=SS(I)
      IF (NFLAG) 915,915,905
  905 DO 910 I=1,NFLAG
  910 LFLAG(I)=0
  915 MMNIT=0
C*****
C**********************
C***** ECHO CHECK *****
C**********************
C*****
C*****(IF NO INPUT CARDS THIS RUN, BYPASS ECHO CHECK)
C
      IF ((IIFIN.EQ.1).AND.(KREAD(16).EQ.0)) GO TO 1005
      IF (IIECH.EQ.LN) GO TO 1000
      WRITE (NPRNT,1025) NNPRJ,NNAME,MMON,NNDAY,NNYR,NNRUN,NRTOT
      WRITE (NPRNT,1035) NNCLT,NNSTA,NNHIS,NNPRM,NNPLT,NNSTR,NNTRY,NNATR
     1,NNFIL,NNSET,NNEQD,NNEQS,NFLAG
      WRITE (NPRNT,1040) IIPOF,IIPOS,IISUM,IIPIR
      IF (NNCLT.LE.0) GO TO 925
      WRITE (NPRNT,1085)
      DO 920 I=1,NNCLT
  920 WRITE (NPRNT,1045) I,LLABC(I,1),LLABC(I,2)
  925 IF (NNSTA.LE.0) GO TO 935
      WRITE (NPRNT,1085)
      DO 930 I=1,NNSTA
  930 WRITE (NPRNT,1050) I,LLABT(I,1),LLABT(I,2),SSTPV(I,6)
  935 IF (NNHIS.LE.0) GO TO 945
      WRITE (NPRNT,1085)
      NPREV=0
      DO 940 I=1,NNHIS
	 IF (I.GT.1) NPREV=NNCEL(I-1)
	 NXCEL=NNCEL(I)-NPREV-2
  940 WRITE (NPRNT,1055) I,LLABH(I,1),LLABH(I,2),NXCEL,HHLOW(I),HHWID(I)
  945 IF (NNPLT.LE.0) GO TO 960
      WRITE (NPRNT,1085)
      DO 955 I=1,NNPLT
	 IT=IITAP(I)
	 IF (IT.LE.0) GO TO 950
	 REWIND IT
	 READ (IT) LLPLT,LLSYM,LLABP,LLPLO,PPLO,LLPHI,PPHI
  950	 WRITE (NPRNT,1060) I,LLABP(11,1),LLABP(11,2),IITAP(I),NNVAR(I),
     1	 LLPLT,DTPLT(I)
	 NVAR=NNVAR(I)
      DO 955 IJ=1,NVAR
  955 WRITE (NPRNT,1065) IJ,LLSYM(IJ),LLABP(IJ,1),LLABP(IJ,2),LLPLO(IJ),
     1LLPHI(IJ),PPLO(IJ),PPHI(IJ)
  960 IF (NNFIL.LE.0) GO TO 980
      WRITE (NPRNT,1085)
      DO 975 I=1,NNFIL
	 ITEMP=IINN(I)
	 GO TO (965,965,970,970), ITEMP
  965	 WRITE (NPRNT,1070) I,IINNA(ITEMP),KKRNK(I)
	 GO TO 975
  970	 WRITE (NPRNT,1075) I,IINNA(ITEMP)     
  975 CONTINUE
  980 IF (NNEQT.LE.0) GO TO 985
  985 IF (NNPRM.LE.0) GO TO 995
      WRITE (NPRNT,1080) IIEVT,LLERR,AAERR,RRERR,DTMIN,DTMAX,DTSAV
      WRITE (NPRNT,1085)
      DO 990 I=1,NNPRM
  990 WRITE (NPRNT,1090) I,(PPARM(I,J),J=1,4)
  995 JACLR=LY
      JABEG=LY
      JAFIL=LY
      IF (JJCLR.EQ.0) JACLR=LN
      IF (JJBEG.EQ.0) JABEG=LN
      IF (JJFIL.EQ.0) JAFIL=LN
      WRITE (NPRNT,1095) MSTOP,JACLR,JABEG,TTBEG,TTFIN,JAFIL,(IISED(I),I
     1=1,NNSTR)
 1000 CONTINUE
      IF ((IIPOF.EQ.LY).AND.(NNFIL.GT.0)) CALL PRNTQ (0)
      IF ((IIPOS.EQ.LY).AND.(NNEQT.GT.0)) CALL PRNTS
C*****
C****************
C***** EXIT *****
C****************
C*****
 1005 IF (IICRD.EQ.0) IICRD=1
      IF (NNRNS) 1010,1010,1015
 1010 WRITE (NPRNT,1030)
      STOP
 1015 IF (IERRF.EQ.0) RETURN
      STOP
C
 1025 FORMAT (1H1,33X,25HSIMULATION PROJECT NUMBER,I4,2X,2HBY,2X,3A4//34
     1X,4HDATE,I3,1H/,I3,1H/,I5,7X,10HRUN NUMBER,I5,3H OF,I5/46X,23HGASP
     2 IV VERSION 01JAN76)
 1030 FORMAT (///47X,18HNO OUTPUT, NNRNS=0)
 1035 FORMAT (//2X,6HNNCLT=,I6,4X,6HNNSTA=,I6,4X,6HNNHIS=,I6,4X,6HNNPRM=
     1,I6,4X,6HNNPLT=,I6,4X,6HNNSTR=,I6,4X,6HNNTRY=,I6/2X,6HNNATR=,I6,4X
     2,6HNNFIL=,I6,4X,6HNNSET=,I6,4X,6HNNEQD=,I6,4X,6HNNEQS=,I6,4X,6HNFL
     3AG=,I6)
 1040 FORMAT (2X,6HIIPOF=,5X,A1,4X,6HIIPOS=,5X,A1,4X,6HIISUM=,5X,A1,
     1 4X,6HIIPIR=,5X,A1)
 1045 FORMAT (2X,9HCOLCT NO.,I3,4X,6HLLABC=,2A4)
 1050 FORMAT (2X,9HTIMST NO.,I3,4X,6HLLABT=,2A4,2X,6HI.C. =,3X,E12.4)
 1055 FORMAT (2X,9HHISTO NO.,I3,4X,6HLLABH=,2A4,18X,6HNNCEL=,I6,4X,6HHHL
     1OW=,3X,E12.4,3X,6HHHWID=,3X,E12.4)
 1060 FORMAT (2X,9HGPLOT NO.,I3,4X,6HLLABP=,2A4,2X,6HIITAP=,I6,4X,6HNNVA
     1R=,I6,4X,6HLLPLT=,I6,12X,6HDTPLT=,3X,E12.4)
 1065 FORMAT (4X,7HVAR NO.,I3,8X,A1,1H=,2A4,2X,6HLLPLO=,I6,4X,6HLLPHI=,I
     16,4X,6HPPLO =,3X,E12.4,3X,6HPPHI =,3X,E12.4)
 1070 FORMAT (2X, 13HPRIORITY FILE,I4,	1H=,A4,  1H(,I2,  1H))
 1075 FORMAT (2X, 13HPRIORITY FILE,I4,	1H=,A4)
 1080 FORMAT (/2X,6HIIEVT=,I6,4X,6HLLERR=,I6,4X,6HAAERR=,3X,E12.4,11X,6H
     1RRERR=,3X,E12.4/2X,6HDTMIN=,3X,E12.4,11X,6HDTMAX=,3X,E12.4,11X,6HD
     2TSAV=,3X,E12.4)
 1085 FORMAT (1X)
 1090 FORMAT (2X,13HPARAMETER SET,I7,2H =,4(3X,E12.4,1X))
 1095 FORMAT (/2X,6HMSTOP=,I6,4X,6HJJCLR=,5X,A1,4X,6HJJBEG=,5X,A1,4X,  6
     1HTTBEG=,3X,E12.4,3X,  6HTTFIN=,3X,E12.4/2X,  6HJJFIL=,5X,A1/(2X,6H
     2IISED=,I6,5I16))
 1100 FORMAT (80A1)
 1105 FORMAT (1X,80A1)
 1110 FORMAT (1H1)
C
      END
      FUNCTION IPACK(I1ST,ILAST,IIPTR)
      include 'siman.h'
C
C*****PACK UP TO FOUR A1 ELEMENTS INTO AN A4 FIELD
C
C*********   THE FOLLOWING ROUTINE IS MACHINE DEPENDANT; THEREFORE
C*********   TO  ENABLE THIS SUBROUTINE TO WORK ON UNIVAC OR IBM
C*********   MACHINES, THE FOLLOWING CODE MUST REPLACE LINE NUMBERS
C*********   10-25.
C*********
      LOGICAL*1 X(4),Y(4)
      EQUIVALENCE (X(1),IX),(Y(1),IY)
      I=1
      DO 1 K=I1ST,ILAST
      IX=IALPH(K,IIPTR)
      Y(I)=X(1)
1     I=I+1
      IPACK=IY
      RETURN
c10    ENCODE(4,15,B)IALPH(I1ST,IIPTR),IALPH(I1ST+1,IIPTR),IALPH(I1ST+2,I
c    1IPTR),IALPH(I1ST+3,IIPTR)
c15    FORMAT(4A1)
c     DECODE(4,20,B)IY
c20    FORMAT(A4)
c     IPACK=IY
c25    RETURN
      END
      FUNCTION IMAP(IIPTR)
C
C*****THIS FUNCTION MAPS ALPHANUMERIC CARD CODES INTO CORRESPONDING CARD
C*****NUMBERS
C
      INTEGER KARDA(48),KKARD(3,16)
      include 'siman.h'
      EQUIVALENCE(KARDA(1),KKARD(1,1))
      DATA KARDA(1),KARDA(2),KARDA(3),KARDA(4),KARDA(5),KARDA(6),KARDA(7
     1),KARDA(8),KARDA(9),KARDA(10)/1HG,1HE,1HN,1HS,1HT,1HA,1HL,1HI,1HM,
     21HC/
      DATA KARDA(11),KARDA(12),KARDA(13),KARDA(14),KARDA(15),KARDA(16),K
     1ARDA(17),KARDA(18),KARDA(19),KARDA(20)/1HO,1HL,1HT,1HI,1HM,1HH,1HI
     2,1HS,1HP,1HL/
      DATA KARDA(21),KARDA(22),KARDA(23),KARDA(24),KARDA(25),KARDA(26),K
     1ARDA(27),KARDA(28),KARDA(29),KARDA(30)/1HO,1HV,1HA,1HR,1HP,
     2 1HR,1HI,1HC,1HO,1HN/
      DATA KARDA(31),KARDA(32),KARDA(33),KARDA(34),KARDA(35),
     1 KARDA(36),KARDA(37),KARDA(38),KARDA(39),KARDA(40),KARDA(41),
     2 KARDA(42),KARDA(43),KARDA(44),KARDA(45),KARDA(46),KARDA(47),
     3 KARDA(48)/1HP,1HA,1HR,1HI,1HN,1HI,1HS,1HE,1HE,1HE,1HN,
     4 1HT,1HS,1HI,1HM,1HF,1HI,1HN/
      L1=IALPH(1,IIPTR)
      L2=IALPH(2,IIPTR)
      L3=IALPH(3,IIPTR)
      DO 105 J=1,16
      IF (L1.NE.KKARD(1,J)) GO TO 105
      IF (L2.NE.KKARD(2,J)) GO TO 105
      IF (L3.EQ.KKARD(3,J)) GO TO 110
  105 CONTINUE
      J=0
  110 IMAP=J
      RETURN
C
      END
      SUBROUTINE DFAUT (KFLAG)
      INTEGER LLET(26)
      include 'siman.h'
      DATA MEQT,MHIST,MCELS,MCLCT,MSTAT,MATRB,MFILS,MPRMS,MPLOT,MVARP,MS
     1TRM,MFLAG/100,25,500,25,25,25,100,50,10,10,6,50/
      DATA LLET(1),LLET(2),LLET(3),LLET(4),LLET(5),LLET(6),LLET(7),
     1 LLET(8),LLET(9),LLET(10),LLET(11),LLET(12),LLET(13),LLET(14),
     2 LLET(15),LLET(16),LLET(17),LLET(18),LLET(19),LLET(20),LLET(21),
     3 LLET(22),LLET(23),LLET(24),LLET(25),LLET(26)/1HA,1HB,1HC,
     4 1HD,1HE,1HF,1HG,1HH,1HI,1HJ,1HK,1HL,1HM,1HN,1HO,
     5 1HP,1HQ,1HR,1HS,1HT,1HU,1HV,1HW,1HX,1HY,1HZ/
      DATA LABP1,LABP2/4HIND ,4HVAR /
      DATA NAME1/4HWHOM/
      DATA LY/1HY/,LN/1HN/
      DATA IBLNK/1H /
      DATA ISTAR/1H*/
      DATA HIVAL/1.E20/
      IF (KFLAG.EQ.1) GO TO 150
C
C*****GEN CARD
C
      NNAME(1)=NAME1
      NNAME(2)=IBLNK
      NNAME(3)=IBLNK
      NNPRJ=580
      MMON=1
      NNDAY=1
      NNYR=2001
      NNRNS=1
      NPRT2=7
      IIECH=LY
      IIPOF=LY
      IIPOS=LY
      IISUM=LY
      IIPIR=LY
      DO 100 I=1,15
  100 LLSUP(I)=0
C
C*****STAT CARD
C
      NNCLT=0
      NNSTA=0
      NNHIS=0
      NNPLT=0
C
C*****LIMITS CARD
C
      NNPRM=0
      NNSTR=1
      NNTRY=0
      NNATR=1
      NNAPO=NNATR+1
      NNAPT=NNATR+2
      NNCFI=NNTRY*NNAPT
      NNFIL=0
      NNSET=1
      NNEQD=0
      NNEQS=0
      NNEQT=0
      NFLAG=0
C
C*****COLCT CARD
C
      DO 110 I=1,MCLCT
	 IF (I.GT.26) GO TO 105
	 LLABC(I,1)=LLET(I)
	 GO TO 110
  105	 LLABC(I,1)=IBLNK
  110 LLABC(I,2)=IBLNK
C
C*****TIMST CARD
C
      DO 125 I=1,MSTAT
	 IF (I.GT.26) GO TO 115
	 LLABT(I,1)=LLET(I)
	 GO TO 120
  115	 LLABT(I,1)=IBLNK
  120	 LLABT(I,2)=IBLNK
  125 SSTPV(I,6)=0.0
C
C*****HISTO CARD
C
      DO 140 I=1,MHIST
	 IF (I.GT.26) GO TO 130
	 LLABH(I,1)=LLET(I)
	 GO TO 135
  130	 LLABH(I,1)=IBLNK
  135	 LLABH(I,2)=IBLNK
	 NNCEL(I)=10
	 HHLOW(I)=0.0
  140 HHWID(I)=1.0
C
C*****PLOTS CARD
C
C*****(THE FOLLOWING CODE FOR PLOTS INPUT IS EXECUTED ONLY ONCE (WHEN
C*****SUBROUTINE DFAUT	IS INITIALLY  CALLED))
C
      NNPT=0
      MMPTS=0
      DO 145 I=1,MPLOT
	 NNPTS(I)=0
	 IITAP(I)=0
	 NNVAR(I)=1
  145 DTPLT(I)=5.0
C
C*****(THE FOLLOWING CODE FOR PLOTS INPUT AND VARPLT INPUT IS EXECUTED
C*****INITIALLY AND AGAIN EACH TIME A PLOTS CARD IS READ)
C
  150 LLABP(11,1)=LABP1
      LLABP(11,2)=LABP2
      LLPLT=0
C
C*****VARPLT CARD
C
      DO 165 I=1,MVARP
	 IF (I.GT.26) GO TO 155
	 LLSYM(I)=LLET(I)
	 LLABP(I,1)=LLET(I)
	 GO TO 160
  155	 LLSYM(I)=ISTAR
	 LLABP(I,1)=IBLNK
  160	 LLABP(I,2)=IBLNK
	 LLPLO(I)=0
	 LLPHI(I)=0
	 PPLO(I)=0.0
  165 PPHI(I)=0.0
      IF (KFLAG.EQ.1) RETURN
C
C*****PRIORITY CARD
C
  170 DO 175 I=1,MFILS
	 IINN(I)=3
  175 KKRNK(I)=1
C
C*****CONT CARD
C
      IIEVT=0
      LLERR=0
      AAERR=1.E-5
      RRERR=1.E-5
C
C*****(DTMIN DEFAULTS TO .01*DTMAX / DTMAX DEFAULTS TO MIN(HIVAL,DTSAV)/
C*****SEE EDIT/INITIALIZE SECTION OF DATIN)
C
      DTMIN=0.
      DTMAX=0.0
      DTSAV=HIVAL
C
C*****PAR CARD
C
      DO 180 I=1,MPRMS
	 PPARM(I,1)=0.0
	 PPARM(I,2)=0.0
	 PPARM(I,3)=HIVAL
  180 PPARM(I,4)=0.0
C
C*****INIT CARD
C
      MSTOP=1
      JJCLR=1
      JJBEG=1
      TTBEG=0.0
      TTFIN=HIVAL
      JJFIL=1
C
C*****SEEDS CARD
C
      DO 185 I=1,MSTRM
      IISED(I)=0
  185 SSEED(I)=0.
C
C*****ENTRY CARD
C
      DO 190 I=1,MATRB
  190 ATRIB(I)=0.0
      RETURN
C
      END
      SUBROUTINE ERRIN (KODE)
      include 'siman.h'
      WRITE (NPRNT,115) KODE
      IF (KODE.GE.196) GO TO 105
      ITEST=KODE/2
      IF (2*ITEST-KODE) 105,110,105
  105 IERRF=IERRF+1
      RETURN
  110 IERRW=IERRW+1
      RETURN
C
  115 FORMAT (38X, 23H**GASP INPUT ERROR TYPE,I4,  3H **)
C
      END
      SUBROUTINE BUILD
      INTEGER IDIG(9)
      include 'siman.h'
      DATA IDIG(1),IDIG(2),IDIG(3),IDIG(4),IDIG(5),IDIG(6),IDIG(7),IDIG(
     18),IDIG(9)/1H1,1H2,1H3,1H4,1H5,1H6,1H7,1H8,1H9/
      DATA IZERO/1H0/,IPLUS/1H+/,IDASH/1H-/,IDEC/1H./,LE/1HE/
      DATA IBLNK/1H /,KOMMA/1H,/,ISTAR/1H*/,ILEFT/1H(/,IRGHT/1H)/
      DATA MXFLD/50/,MXEXP/99/,KKEND/80/,FUDGE/.0001/
C
C*****FIELD STATUS (KSTAT) SETTINGS
C
      DATA KNEW/1/,KINT/2/,KREAL/3/,KNEWE/4/,KEXP/5/,KSKIP/6/,KALPH/7/
C*****
C****************
C***** NEW CARD *
C****************
C*****
      IF (MORE) 102,102,101
C
C*****SPECIAL HANDLING IF CONTINUATION CARD
C
  101 MORE=0
      KOLUM=0
      GO TO 107
C
C*****INITIALIZE ARRAYS, NUMBER OF FIELDS, AND CURRENT COLUMN
C
  102 DO 104 K=1,NNFLD
	 IFLAG(K)=4
	 IVALU(K)=0
	 RVALU(K)=0.
	 DO 103 J=1,8
  103	 IALPH(J,K)=IBLNK
  104 CONTINUE
      NNFLD=0
      KOLUM=0
C*****
C*****************
C***** NEW FIELD *
C*****************
C*****
C*****TEST FOR EXCESSIVE FIELDS
C
  105 IF (NNFLD.LT.MXFLD) GO TO 106
      CALL ERRIN (160)
      GO TO 134
  106 NNFLD=NNFLD+1
  107 VALUE=0.
      NNDIG=0
      NDIGL=-1
      NNLET=0
      MINUS=0
      KSTAT=KNEW
C*****
C*************
C***** PARSE *
C*************
C*****
  108 KOLUM=KOLUM+1
C
C*****CHECK FOR END OF FIELD
C
      IF (KOLUM.LE.KKEND) GO TO 109
      ICHAR=ISTAR
      GO TO 128
  109 ICHAR=KARD(KOLUM)
      IF (ICHAR.EQ.KOMMA) GO TO 128
      IF (ICHAR.EQ.ISTAR) GO TO 128
C
C*****IGNORE BLANKS
C
      IF (ICHAR.EQ.IBLNK) GO TO 108
C
C*****STORE ICHAR IN ALPHA ARRAY
C
      NNLET=NNLET+1
      IF (NNLET.LE.8) IALPH(NNLET,NNFLD)=ICHAR
      IF (KSTAT.EQ.KALPH) GO TO 108
C
C*****DIGITS
C
      DO 110 K=1,9
	 IF (ICHAR.EQ.IDIG(K)) GO TO 111
  110 CONTINUE
      IF (ICHAR.NE.IZERO) GO TO 112
      K=0
  111 VALUE=VALUE*10.+FLOAT(K)
      NNDIG=NNDIG+1
      IF (KSTAT.EQ.KNEW) KSTAT=KINT
      IF (KSTAT.EQ.KNEWE) KSTAT=KEXP
      GO TO 108
C
C*****LEFT PAREN
C
  112 IF (ICHAR.NE.ILEFT) GO TO 113
      IF (KSTAT.NE.KNEW) GO TO 126
      KSTAT=KSKIP
      GO TO 108
C
C*****DECIMAL POINT
C
  113 IF (ICHAR.NE.IDEC) GO TO 115
      IF ((KSTAT.EQ.KNEW).OR.(KSTAT.EQ.KINT)) GO TO 114
      GO TO 126
  114 KSTAT=KREAL
      NDIGL=NNDIG
      GO TO 108
C
C*****NEGATIVE
C
  115 IF (ICHAR.NE.IDASH) GO TO 118
      IF (KSTAT.NE.KNEW) GO TO 116
      KSTAT=KINT
      GO TO 117
  116 IF (KSTAT.NE.KNEWE) GO TO 126
      KSTAT=KEXP
  117 MINUS=1
      GO TO 108
C
C*****PLUS
C
  118 IF (ICHAR.NE.IPLUS) GO TO 121
      IF (KSTAT.NE.KNEW) GO TO 119
      KSTAT=KINT
      GO TO 120
  119 IF (KSTAT.NE.KNEWE) GO TO 126
      KSTAT=KEXP
  120 GO TO 108
C
C*****LETTER E
C
  121 IF (ICHAR.NE.LE) GO TO 123
      IF ((KSTAT.EQ.KREAL).OR.(KSTAT.EQ.KINT)) GO TO 122
      IF (KSTAT-KNEW) 126,127,126
  122 BASE=VALUE
      IF (MINUS.EQ.1) BASE=-BASE
      IF (NDIGL.GE.0) BASE=BASE/(10.**(NNDIG-NDIGL))
      KSTAT=KNEWE
      VALUE=0.
      NNDIG=0
      MINUS=0
      GO TO 108
C
C*****RIGHT PAREN
C
  123 IF (ICHAR.NE.IRGHT) GO TO 127
      IF (KSTAT.NE.KSKIP) GO TO 126
      DO 124 J=1,8
  124 IALPH(J,NNFLD)=IBLNK
      I=VALUE
      IF ((I.GT.0).AND.(I.LE.MXEXP)) GO TO 125
      CALL ERRIN (166)
      GO TO 134
  125 NNFLD=I
      GO TO 107
C
C*****WARNING -- UNRECOGNIZABLE CHARACTERS
C
  126 CALL ERRIN (162)
C
C*****INITIALIZE FIELD STATUS TO ALPHA
C
  127 IFLAG(NNFLD)=3
      KSTAT=KALPH
      GO TO 108
C*****
C********************
C***** END OF FIELD *
C********************
C*****
  128 GO TO (133,129,130,126,131,126,133), KSTAT
C
C*****INTEGER
C
  129 IFLAG(NNFLD)=1
      IVAL=VALUE+FUDGE
      IF (MINUS.EQ.1) IVAL=-IVAL
      IVALU(NNFLD)=IVAL
      RVALU(NNFLD)=IVAL
      GO TO 133
C
C*****REAL
C
  130 IFLAG(NNFLD)=2
      IF (MINUS.EQ.1) VALUE=-VALUE
      IF (NDIGL.GE.0) VALUE=VALUE/(10.**(NNDIG-NDIGL))
      RVALU(NNFLD)=VALUE
      IVALU(NNFLD)=VALUE
      GO TO 133
C
C*****E-FORMAT REAL
C
  131 IFLAG(NNFLD)=2
      IVAL=VALUE+FUDGE
      IF (MINUS.EQ.1) IVAL=-IVAL
      IF (IABS(IVAL).LE.MXEXP) GO TO 132
      CALL ERRIN (166)
      IVAL=ISIGN(MXEXP,IVAL)
  132 RVALU(NNFLD)=BASE*(10.**IVAL)
C
C*****IF NOT END OF CARD, LOOP BACK TO PROCESS NEXT FIELD
C
  133 IF (ICHAR.NE.ISTAR) GO TO 105
C
C*****CHECK FOR CONTINUATION CARD
C
      IF ((KOLUM.GT.KKEND).AND.(KSTAT.EQ.KNEW).AND.(NNFLD.GT.1)) MORE=1
  134 RETURN
C
      END
      SUBROUTINE MONTR
      include 'siman.h'
      DATA IX/1/
      IF (JEVNT) 101,103,103
  101 JX=-JEVNT
      IF (JX.EQ.2) GO TO 108
      IF (ATRIB(3).LE.0.0) GO TO 102
      ATRIB(1)=TNOW+ATRIB(3)
      ATRIB(2)=JEVNT
      CALL FILEM (1)
  102 GO TO (107,108,110,107,111,112), JX
  103 CALL UMONT(IX)
      IF(IX.EQ.0) GO TO 113
      IF (MFE(1)) 106,105,104
C
C*****JMNIT.EQ.1 AND JEVNT.GE.1! PRINT TNOW, ATTRIBUTES OF CURRENT
C*****EVENT, TTNEX, AND ATTRIBUTES OF NEXT EVENT.
C
  104 IFA=MFE(1)+1
      ILA=MFE(1)+NNATR
      WRITE (NPRNT,114) TNOW,(ATRIB(I),I=1,NNATR)
      WRITE (NPRNT,115) TTNEX,(QSET(I),I=IFA,ILA)
      GO TO 113
  105 WRITE (NPRNT,114) TNOW,(ATRIB(I),I=1,NNATR)
      WRITE (NPRNT,116) TTFIN
      GO TO 113
  106 CALL ERROR(602)
C
C*****JEVNT.EQ.-1, PRINT FILE STORAGE AREA DUMP.
C
  107 CALL PRNTQ (0)
      IF (JEVNT+3) 110,113,113
C
C*****JEVNT.EQ.-2, RESET FILE STATISTICS AND CLEAR STATISTICAL
C*****STORAGE ARRAYS.
C
  108 DO 109 J=1,NNFIL
      QQTIM(J)=TNOW
      EENQ(J)=0.0
      VVNQ(J)=0.0
  109 MMAXQ(J)=NNQ(J)
      TTSET=TNOW
      CALL CLEAR
      GO TO 113
C
C*****JEVNT.EQ.-3, PRINT STATE STORAGE AREA DUMP.
C
  110 CALL PRNTS
      GO TO 113
C
C***** IF JEVNT EQUALS -4 --- PRINT FILES AND STATE STORAGE.
C
C
C*****IF JEVNT= -5   PRINT SUMMARY REPORT.
C
  111 CALL SUMRY
      GO TO 113
C
C*****JEVNT.LE.-6, CAUSE ERROR EXIT, TYPE 601 ERROR.
C
  112 CALL ERROR (601)
  113 RETURN
C
  114 FORMAT (/2X,23HCURRENT EVENT.....TNOW=,E11.4/(7(3X,E12.4,1X)))
  115 FORMAT (2X,23HNEXT EVENT.......TTNEX=,E11.4/(7(3X,E12.4,1X)))
  116 FORMAT (2X,23HNEXT EVENT.......TTNEX=,E11.4/7X,36HTTNEX=TTFIN, THE
     1 EVENT FILE IS EMPTY)
C
      END
      SUBROUTINE SUMRY
      REAL XXXX(10)
      include 'siman.h'
      DATA XXX,XXXX(1)/2*0./
      WRITE (NPRNT,117)
      NRTOT=NNRNS+NNRUN-1
      WRITE (NPRNT,118) NNPRJ,NNAME,MMON,NNDAY,NNYR,NNRUN,NRTOT,TNOW
C
C*****PRINT PARAMETER SETS.
C
      KODE=561
      IF (NNPRM) 104,103,101
  101 DO 102 I=1,NNPRM
  102 WRITE (NPRNT,119) I,(PPARM(I,J),J=1,4)
C
C*****PRINT STATISTICS GATHERED BY COLCT.
C
  103 KODE=562
      IF (NNCLT) 104,106,105
  104 CALL ERROR(KODE)
  105 CALL COLCT (XXXX(1),0)
C
C*****PRINT STATISTICS GATHERED BY TIMST.
C
  106 KODE=563
      IF (NNSTA) 104,108,107
  107 CALL TIMST (XXXX(1),TNOW,0)
C
C*****PRINT FILES AND FILE STATISTICS.
C
  108 KODE=564
      IF (NNFIL) 104,110,109
  109 CALL PRNTQ (0)
C
C*****PRINT STATE STORAGE ARRAY.
C
  110 KODE=565
      IF (NNEQT) 104,112,111
  111 CALL PRNTS
C
C******PRINT HISTOGRAMS.
C
  112 KODE=566
      IF (NNHIS) 104,114,113
  113 CALL HISTO (XXXX(1),0)
C
C*****PRINT TABLES AND PLOTS.
C
  114 KODE=567
      IF (NNPLT) 104,116,115
  115 CALL GPLOT (XXXX(1),XXX,0)
  116 RETURN
C
  117 FORMAT (1H1,45X,23H**GASP SUMMARY REPORT**/)
  118 FORMAT (34X,25HSIMULATION PROJECT NUMBER,I4,2X,2HBY,2X,3A4//34X,4H
     1DATE,I3,1H/,I3,1H/,I5,7X,10HRUN NUMBER,I5,3H OF,I5//,34X,14HCURREN
     2T TIME =,E12.4//)
  119 FORMAT (2X,13HPARAMETER SET,I7,2H =,4(3X,E12.4,1X))
C
      END
      SUBROUTINE CANCL (NTRY)
      INTEGER NTRY(1)
C
C*****REMOVE NTRY FROM EVENT FILE, UPDATE TTNEX, DO NOT UPDATE TNOW OR
C*****JEVNT, COPY ENTRY TO ATRIB.
C
      CALL RMOVE (NTRY(1),-1)
      RETURN
C
      END
      SUBROUTINE CLEAR
      include 'siman.h'
      KODE=211
      TTCLR=TNOW
      IF (NNCLT) 101,105,102
  101 CALL ERROR (KODE)
  102 DO 104 J=1,NNCLT
      DO 103 I=1,3
  103 SSOBV(J,I)=0.
      SSOBV(J,4)=1.0E20
  104 SSOBV(J,5)=-1.0E20
  105 KODE=212
      IF (NNSTA) 101,108,106
  106 DO 107 J=1,NNSTA
      SSTPV(J,1)=0.0
      SSTPV(J,2)=0.0
      SSTPV(J,3)=TNOW
      SSTPV(J,4)=SSTPV(J,6)
  107 SSTPV(J,5)=SSTPV(J,6)
  108 KODE=213
      IF (NNHIS) 101,111,109
  109 NCELT=NNCEL(NNHIS)
      DO 110 I=1,NCELT
  110 JJCEL(I)=0
  111 RETURN
C
      END
      SUBROUTINE COLCT (XX,ICLCT)
      REAL XX(1)
      include 'siman.h'
      IF (ICLCT) 101,102,103
  101 IFC=-ICLCT
      ILC=IFC
      GO TO 109
  102 IFC=1
      ILC=NNCLT
      GO TO 109
  103 IF (ICLCT-NNCLT) 105,105,104
  104 CALL ERROR (501)
  105 SSOBV(ICLCT,1)=SSOBV(ICLCT,1)+XX(1)
      SSOBV(ICLCT,2)=SSOBV(ICLCT,2)+XX(1)*XX(1)
      SSOBV(ICLCT,3)=SSOBV(ICLCT,3)+1.
      IF (XX(1)-SSOBV(ICLCT,4)) 106,107,107
  106 SSOBV(ICLCT,4)=XX(1)
  107 IF (XX(1)-SSOBV(ICLCT,5)) 117,117,108
  108 SSOBV(ICLCT,5)=XX(1)
      GO TO 117
  109 WRITE (NPRNT,118)
      DO 116 J=IFC,ILC
      IF (SSOBV(J,3)) 110,111,112
  110 CALL ERROR (502)
  111 WRITE (NPRNT,119) LLABC(J,1),LLABC(J,2)
      GO TO 116
  112 XS=SSOBV(J,1)
      XSS=SSOBV(J,2)
      XN=SSOBV(J,3)
      AVG=XS/XN
      NXN=XN+.000001
      IF (NXN-1) 113,113,114
  113 STD=0.
      GO TO 115
  114 YSS=XSS-XS*XS/XN
      IF(YSS.LE.0.0) GO TO 113
      STD=SQRT(YSS/(XN-1.0))
  115 STDM=STD/SQRT(XN)
      CV=99999.
      IF (AVG.NE.0.0) CV=STD/AVG
      WRITE (NPRNT,120) LLABC(J,1),LLABC(J,2),AVG,STD,STDM,CV,SSOBV(J,4)
     1,SSOBV(J,5),NXN
  116 CONTINUE
  117 RETURN
C
  118 FORMAT (//33X,49H**STATISTICS FOR VARIABLES BASED ON OBSERVATION**
     1/16X,4HMEAN,10X,7HSTD DEV,8X,10HSD OF MEAN,10X,2HCV,11X,7HMINIMUM,
     29X,7HMAXIMUM,6X,3HOBS/)
  119 FORMAT (2X,2A4,39X,18HNO VALUES RECORDED)
  120 FORMAT (2X,2A4,1X,E12.4,1X,5(3X,E12.4,1X),I6)
C
      END
      SUBROUTINE COPY (NTRY)
      DIMENSION NTRY(1)
      include 'siman.h'
C
      
      NTRYG=NTRY(1)
      IF (NTRYG) 101,101,102
  101 CALL ERROR (313)
  102 DO 103 I=1,NNATR
      NSISA=NTRYG+I
  103 ATRIB(I)=QSET(NSISA)
      RETURN
C
      END
      SUBROUTINE ERROR (KODE)
      include 'siman.h'
      DATA NERR,XX/0,-1.0/
      IF (NERR) 104,101,104
  101 NERR=NERR+1
      WRITE (NPRNT,107) KODE,TNOW
C
C ##### AN ERROR MESSAGE TO THE TERMINAL ADDED HERE  18 FEB 1976  LRH
C
      WRITE (*,1077) KODE,TNOW
      IF (NNATR) 103,103,102
  102 WRITE (NPRNT,108) (ATRIB(I),I=1,NNATR)
  103 CALL UERR (KODE)
C
C*****PRINT SUMMARY REPORT UP TO PRESENT
C
      CALL SUMRY
  104 WRITE (NPRNT,109) KODE
C
C ##### THE FOLLOWING TWO STATEMENTS COMMENTED OUT AND
C ##### REPLACED WITH THE ERROR CODE OUTPUT TO THE TERMINAL
C #####					LRH     JAN 1976
C
C      IF (XX) 105,106,106
C  105 XX=SQRT(XX)
      WRITE(*,1099) KODE
      STOP
C 106 RETURN  ##### This stmt commented by Bob Crites 12/93
C
  107 FORMAT (1H1,37X,23H**GASP ERROR EXIT, TYPE,I4,14H ERROR AT TIME,E1
     12.4,2H**)
  108 FORMAT (/46X,38HTHE CURRENT VALUES IN THE BUFFER ATRIB/(1X,E14.4,6
     1E16.4))
  109 FORMAT (///44X,16HERROR EXIT, TYPE,I4,7H ERROR.)
C
C ##### NEXT TWO FORMAT STATEMENTS ADDED FOR THE OUTPUT
C ##### TO THE TERMINAL                 18 FEB 1976   LRH
C
 1077 FORMAT(//23H**GASP ERROR EXIT, TYPE,I4,14H ERROR AT TIME,
     1E12.4,2H**)
 1099 FORMAT (//16HERROR EXIT, TYPE,I4,7H ERROR.)
C
      END
      SUBROUTINE FILEM (IFILE)
      include 'siman.h'
C
C*****TEST TO SEE IF THERE IS SPACE AVAILABLE FOR ANOTHER ENTRY.
C
      IF (MFA) 101,101,102
  101 CALL ERROR (301)
C
C*****PUT ATTRIBUTE VALUES INTO FILE AS ENTRY MFA.
C
  102 DO 103 I=1,NNATR
      NSISA=MFA+I
  103 QSET(NSISA)=ATRIB(I)
C
C*****NEW IS ENTRY BEING FILED
C
      NEW=MFA
      MFA=NSET(NSISA+1)
C
C*****TEST WHETHER THERE ARE ENTRIES IN FILE IFILE.
C
      IF (NNQ(IFILE)) 109,104,112
C
C*****NEW HAS NO PREDECESSOR. FIRST ENTRY IN FILE IS MFA.
C
  104 NSET(NEW)=0
      MFE(IFILE)=NEW
C
C*****NEW HAS NO SUCCESSOR. LAST ENTRY IN FILE IS NEW.
C
  105 NSISB=NNAPO+NEW
      NSET(NSISB)=0
      MLE(IFILE)=NEW
C
C*****UPDATE STATISTICS FOR FILE IFILE.
C
  106 XNQ=NNQ(IFILE)
      EENQ(IFILE)=EENQ(IFILE)+XNQ*(TNOW-QQTIM(IFILE))
      VVNQ(IFILE)=VVNQ(IFILE)+XNQ*XNQ*(TNOW-QQTIM(IFILE))
      QQTIM(IFILE)=TNOW
      NNQ(IFILE)=NNQ(IFILE)+1
      IF (NNQ(IFILE)-MMAXQ(IFILE)) 108,108,107
  107 MMAXQ(IFILE)=NNQ(IFILE)
C
C*****IF IFILE.EQ.1, UPDATE TTNEX.
C
  108 IF (IFILE-1) 109,110,111
  109 CALL ERROR (302)
  110 NEXTE=MFE(1)
      TTNEX=QSET(NEXTE+1)
  111 RETURN
C
C*****MFEX AND MLEX ARE FIRST AND LAST ENTRIES IN FILE IFILE WHICH HAVE
C*****NOT BEEN TESTED AGAINST NEW.
C
  112 MFEX=MFE(IFILE)
      MLEX=MLE(IFILE)
C
C*****JSEC INDICATES WHETHER RANKING FOR FILE 1 IS PRIMARY (LVF),
C*****OR SECONDARY (USER SPECIFIED).
C
      IF (IFILE-1) 109,113,114
  113 KS=1
      INNS=1
      QQIND=1.
      IF(IINN(1).EQ.2)QQIND=-1.
      GO TO 117
C
C*****KS IS RANKING ATTRIBUTE OF ENTRY.
C
  114 KS=KKRNK(IFILE)
      INNS=IINN(IFILE)
C
C*****CHECK TO SEE HOW FILE IS RANKED.
C
      IF(INNS-2)117,116,115
  115 IF (INNS-4) 124,127,101
C
C*****TEST RANKING ATTRIBUTE OF NEW AGAINST MLEX.
C
  116 QIND=-1.
      GO TO 118
  117 QIND=+1.
  118 NSISA=KS+NEW
  119 NSISB=KS+MLEX
      IF ((QSET(NSISA)-QSET(NSISB))*QIND) 126,120,124
C
C*****A TIE EXISTS.  IF IFILE=1 AND JSEC=0, SWITCH TO SECONDARY
C*****RANKING, OTHERWISE, BREAK TIE BY FIFO.
C
  120 IF (IFILE-1) 109,121,124
  121 IF(IINN(1)-3)122,124,123
  122 NSISA=KKRNK(1)+NEW
      NSISB=KKRNK(1)+MLEX
C
C*****TEST RANKING ATTRIBUTE OF NEW AGAINST MLEX.
C
      IF ((QSET(NSISA)-QSET(NSISB))*QQIND) 123,124,124
  123 MLEX=NSET(MLEX)
      IF(MLEX)127,127,118
C
C*****MSU IS OLD SUCCESSOR OF MLEX. NEW SUCCESSOR OF MLEX IS NEW.
C*****PREDECESSOR OF NEW IS MLEX.
C
  124 NSISA=NNAPO+MLEX
      MSU=NSET(NSISA)
      NSET(NSISA)=NEW
      NSET(NEW)=MLEX
      IF (MSU) 105,105,125
C
C*****SUCCESSOR OF NEW IS MSU. PREDECESSOR OF MSU IS NEW.
C
  125 NSISA=NNAPO+NEW
      NSET(NSISA)=MSU
      NSET(MSU)=NEW
      GO TO 106
C
C*****NEW MLEX IS PREDECESSOR OF OLD MLEX.
C
  126 MLEX=NSET(MLEX)
      IF (MLEX) 127,127,119
C
C*****NEW HAS NO PREDECESSOR. FIRST ENTRY IN FILE IS NEW.
C
  127 NSET(NEW)=0
      MFE(IFILE)=NEW
C
C*****SUCCESSOR OF NEW IS MFEX. PREDECESSOR OF NEW IS MFEX.
C
      NSISA=NNAPO+NEW
      NSET(NSISA)=MFEX
      NSET(MFEX)=NEW
      GO TO 106
C
      END
      SUBROUTINE GDLAY (IFS,ILS,XIN,DEL)
      include 'siman.h'
      DELXR=FLOAT(ILS-IFS+1)/DEL
      IF (JJBEG) 104,104,101
  101 IF (ILS-IFS) 105,102,102
  102 DO 103 I=IFS,ILS
  103 SS(I)=SS(ILS)
  104 DD(IFS)=(XIN-SS(IFS))*DELXR
      IF (ILS-IFS) 105,108,106
  105 CALL ERROR (831)
  106 ISS=IFS+1
      DO 107 I=ISS,ILS
  107 DD(I)=(SS(I-1)-SS(I))*DELXR
  108 RETURN
C
      END
      SUBROUTINE GPLOT (XX,T,IPLOT)
      include 'siman.h'
      REAL XX(10), PLOG(10), PHIG(10), RANGE(10)
      INTEGER NOUT(117)
      DATA IPLUS,IBLNK,IAST,IPRD/1H+,1H ,1H*,1H./
      IF (IPLOT) 108,109,101
  101 IT=IITAP(IPLOT)
      NVAR=NNVAR(IPLOT)
      IF (IT) 102,102,106
  102 IF (NNPTS(IPLOT)-MMPTS) 104,103,103
  103 NNPT=NNPT+1
      GO TO 187
  104 IP=NNPTS(IPLOT)*(NVAR+1)+NNCFI
      DO 105 I=1,NVAR
      J=IP+I
  105 QSET(J)=XX(I)
      QSET(J+1)=T
      GO TO 107
  106 WRITE (IT) T,(XX(I),I=1,NVAR)
  107 NNPTS(IPLOT)=NNPTS(IPLOT)+1
      GO TO 187
  108 IFP=-IPLOT
      ILP=IFP
      GO TO 110
  109 IFP=1
      ILP=NNPLT
  110 DO 186 N=IFP,ILP
      DTPLG=DTPLT(N)
      DTPLP=ABS(DTPLG)
      IT=IITAP(N)
      NVAR=NNVAR(N)
      IF (IT) 112,112,111
  111 REWIND IT
      READ (IT) LLPLT,LLSYM,LLABP,LLPLO,PPLO,LLPHI,PPHI
  112 NPT=NNPTS(N)
      IF (LLPLT) 128,113,113
  113 WRITE (NPRNT,194) N,NNRUN
      WRITE (NPRNT,192) LLABP(11,1),LLABP(11,2),(LLABP(I,1),LLABP(I,2),I
     1=1,NVAR)
      DO 114 I=1,NVAR
      PLOG(I)=1.E20
  114 PHIG(I)=-1.E20
      DO 127 J=1,NPT
      IF (IT) 115,115,121
  115 IP=(J-1)*(NVAR+1)+NNCFI
      DO 119 I=1,NVAR
      JJ=IP+I
      IF (QSET(JJ)-PLOG(I)) 116,117,117
  116 PLOG(I)=QSET(JJ)
  117 IF (QSET(JJ)-PHIG(I)) 119,119,118
  118 PHIG(I)=QSET(JJ)
  119 CONTINUE
      IF (LLPLT-1) 127,120,120
  120 IL=IP+NVAR
      IP=IP+1
      WRITE (NPRNT,193) QSET(IL+1),(QSET(I),I=IP,IL)
      GO TO 127
  121 READ (IT) XTIME,(XX(I),I=1,NVAR)
      DO 125 IP=1,NVAR
      IF (XX(IP)-PLOG(IP)) 122,123,123
  122 PLOG(IP)=XX(IP)
  123 IF (XX(IP)-PHIG(IP)) 125,125,124
  124 PHIG(IP)=XX(IP)
  125 CONTINUE
      IF (LLPLT-1) 127,126,126
  126 WRITE (NPRNT,193) XTIME,(XX(I),I=1,NVAR)
  127 CONTINUE
      WRITE (NPRNT,195) (PLOG(I),I=1,NVAR)
      WRITE (NPRNT,196) (PHIG(I),I=1,NVAR)
      IF (LLPLT-1) 128,183,128
  128 WRITE (NPRNT,188) N,NNRUN
      DO 139 I=1,NVAR
      IF (LLPLO(I)-1) 133,132,129
  129 IF (PLOG(I)) 130,131,131
  130 PLOG(I)=PPLO(I)*FLOAT(IFIX((PLOG(I)-PPLO(I)+1.E-20)/PPLO(I)))
      GO TO 133
  131 PLOG(I)=PPLO(I)*FLOAT(IFIX(PLOG(I)/PPLO(I)))
      GO TO 133
  132 PLOG(I)=PPLO(I)
  133 IF (LLPHI(I)-1) 138,137,134
  134 IF (PHIG(I)) 135,135,136
  135 PHIG(I)=PPHI(I)*FLOAT(IFIX(PHIG(I)/PPHI(I)))
      GO TO 138
  136 PHIG(I)=PPHI(I)*FLOAT(IFIX((PHIG(I)+PPHI(I)-1.E-20)/PPHI(I)))
      GO TO 138
  137 PHIG(I)=PPHI(I)
  138 RANGE(I)=PHIG(I)-PLOG(I)
      QR=RANGE(I)*.25
      Q1=PLOG(I)+QR
      Q2=Q1+QR
      Q3=Q2+QR
  139 WRITE (NPRNT,189) LLSYM(I),LLABP(I,1),LLABP(I,2),PLOG(I),Q1,Q2,Q3,
     1PHIG(I)
      WRITE (NPRNT,190) LLABP(11,1),LLABP(11,2)
      IF (IT) 140,140,142
  140 IP=NNTRY*NNAPT
      DO 141 I=1,NVAR
      JJ=IP+I
  141 XX(I)=QSET(JJ)
      XTIME=QSET(JJ+1)
      GO TO 143
  142 REWIND IT
      READ (IT) LLPLT
      READ (IT) XTIME,(XX(I),I=1,NVAR)
  143 IPT=1
      IDIF=1
      IF (DTPLG) 145,144,146
  144 ISN=0
      TSN=XTIME
      TSL=TSN
      GO TO 148
  145 ISN=((XTIME-TTBEG)/DTPLP)-0.499999
      GO TO 147
  146 ISN=((XTIME-TTBEG)/DTPLP)+0.5
  147 TSN=TTBEG+FLOAT(ISN)*DTPLP
  148 DO 149 J=1,117
      NOUT(J)=IBLNK
  149 CONTINUE
      DO 150 J=1,101,25
  150 NOUT(J)=IPLUS
      NCOUN=103
      IF (IDIF-1) 151,154,152
  151 CALL ERROR(531)
  152 DO 153 J=2,IDIF
      TSL=TSL+DTPLG
      WRITE (NPRNT,191) TSL,NOUT
  153 CONTINUE
  154 DO 168 IP=1,NVAR
      PLIP=XX(IP)
      IF (PLIP-PLOG(IP)) 168,155,155
  155 IF (PLIP-PHIG(IP)) 156,156,168
  156 IF (RANGE(IP)) 168,168,157
  157 NPCT=(PLIP-PLOG(IP))*100./RANGE(IP)+1.5
      NONP=NOUT(NPCT)
C
C ##### ALTERATIONS TO REPLACE ARITHMETIC COMPARISONS OF
C ##### CHARACTERS WITH LOGICAL COMPARISONS.  DONE
C ##### BECAUSE THE COMMENTED CODING GENERATED INTEGER
C ##### OVERFLOWS 			LRH    OCT 1975
C
C ##### THE FOLLOWING LINES WERE DELETED
C
C      IF (NONP-IBLNK) 158,166,158
C  158 IF (NONP-LLSYM(IP)) 159,168,159
C  159 IF (NONP-IPLUS) 160,166,160
C  160 IF (NONP-IPRD) 161,166,161
C  161 IF (LLSYM(IP)-IPRD) 162,168,162
C
C ##### THE FOLLOWING LINES WERE ADDED
C
      IF(NONP .EQ. IBLNK) GOTO 166
      IF(NONP .EQ. LLSYM(IP)) GOTO 168
      IF(NONP .EQ. IPLUS) GOTO 166
      IF(NONP .EQ. IPRD) GOTO 166
      IF(LLSYM(IP) .EQ. IPRD) GOTO 168
  162 IF(NCOUN-117) 1162,167,167
 1162 DO 164 J=103,NCOUN,3
C
C ##### THE FOLLOWING TWO LINES MUST BE REPLACED ALSO
C #####				LRH   OCT 1975
C
C      IF (NOUT(J+1)-LLSYM(IP)) 164,163,164
C  163 IF (NOUT(J)-NONP) 164,168,164
C
C ##### AND HERE ARE THE REPLACEMENTS
C
      IF(NOUT(J+1) .NE. LLSYM(IP)) GOTO 164
      IF(NOUT(J) .EQ. NONP) GOTO 168
  164 CONTINUE
      NOUT(NCOUN)=NOUT(NPCT)
      NOUT(NCOUN+1)=LLSYM(IP)
      NCOUN=NCOUN+3
      GO TO 168
  166 NOUT(NPCT)=LLSYM(IP)
      GO TO 168
  167 NOUT(117)=IAST
  168 CONTINUE
      TSL=TSN
      ISL=ISN
      IF (IPT-NPT) 169,182,182
  169 IF (IT) 170,170,172
  170 IP=IPT*(NVAR+1)+NNCFI
      DO 171 I=1,NVAR
      JJ=IP+I
  171 XX(I)=QSET(JJ)
      XTIME=QSET(JJ+1)
      GO TO 173
  172 READ (IT) XTIME,(XX(I),I=1,NVAR)
  173 IPT=IPT+1
      IF (DTPLG) 175,174,176
  174 TSN=XTIME
      GO TO 181
  175 ISN=((XTIME-TTBEG)/DTPLP)-0.499999
      GO TO 177
  176 ISN=((XTIME-TTBEG)/DTPLP)+0.5
  177 TSN=TTBEG+FLOAT(ISN)*DTPLP
      IF (DTPLG) 178,151,179
  178 IDIF=ISL-ISN
      GO TO 180
  179 IDIF=ISN-ISL
  180 IF (IDIF) 151,154,181
  181 WRITE (NPRNT,191) TSL,NOUT
      GO TO 148
  182 WRITE (NPRNT,191) TSL,NOUT
      WRITE (NPRNT,190) LLABP(11,1),LLABP(11,2)
  183 I=NPT*NVAR
      WRITE (NPRNT,197) NPT,I
      NNPTS(N)=0
      IF (IT) 184,184,185
  184 I=MMPTS*(NVAR+1)
      J=NPT+NNPT
      JJ=J*(NVAR+1)
      WRITE (NPRNT,198) MMPTS,I,J,JJ
      NNPT=0
      GO TO 187
  185 REWIND IT
      READ (IT) LLPLT
      IF (IPLOT) 187,186,187
  186 CONTINUE
  187 RETURN
C
  188 FORMAT (1H1,56X,13H**PLOT NUMBER,I3,2H**/59X,11HRUN  NUMBER,I3//59
     1X,14HSCALES OF PLOT)
  189 FORMAT (2X,A1,1H=,2A4,2X,E11.4,4(14X,E11.4))
  190 FORMAT (1H0,3X,2A4,3X,1H0,4X,1H5,3X,2H10,3X,2H15,3X,2H20,3X,2H25,3
     1X,2H30,3X,2H35,3X,2H40,3X,2H45,3X,2H50,3X,2H55,3X,2H60,3X,2H65,3X,
     22H70,3X,2H75,3X,2H80,3X,2H85,3X,2H90,3X,2H95,2X,3H100,1X,10HDUPLIC
     3ATES/)
  191 FORMAT (1X,E12.4,2X,117A1)
  192 FORMAT (3X,2A4,10(4X,2A4)/)
  193 FORMAT (11(1X,E11.4))
  194 FORMAT (1H1,48X,14H**TABLE NUMBER,I3,2H**/51X,12HRUN  NUMBER ,I3/)
  195 FORMAT (/5X,7HMINIMUM,10E12.4)
  196 FORMAT (5X,7HMAXIMUM,10E12.4)
  197 FORMAT (///5X,21HOUTPUT  CONSISTS  OF ,I6,13H POINT SETS (,I6,8H P
     1OINTS))
  198 FORMAT (5X,21HSTORAGE ALLOCATED FOR,I6,13H POINT SETS (,I6,8H WORD
     1S )/5X,21HSTORAGE  NEEDED   FOR,I6,13H POINT SETS (,I6,8H WORDS ))
C
      END
      FUNCTION GTABL(TAB,X,XLOW,XHIGH,XINCR)
      REAL TAB(1)
      IF (X-XLOW) 103,103,101
  101 IF (X-XHIGH) 102,104,104
  102 INTVL=((X-XLOW)/XINCR)+1.
      XINT=INTVL-1
      XLOI=XINCR*XINT+XLOW
      GTABL=TAB(INTVL)+(TAB(INTVL+1)-TAB(INTVL))*(X-XLOI)/XINCR
      GO TO 105
  103 GTABL=TAB(1)
      GO TO 105
  104 INTMX=((XHIGH-XLOW)/XINCR)+1.5
      GTABL=TAB(INTMX)
  105 RETURN
C
      END
      SUBROUTINE HISTO (XX,IHIST)
      include 'siman.h'
      REAL XX(1)
      INTEGER  NOUT(50)
      DATA IPLUS,IBLNK,IAST,ICEE/1H+,1H ,1H*,1HC/
      IF (IHIST) 101,103,105
  101 IFH=-IHIST
      ILH=IFH
      IF (IFH-1) 104,104,102
  102 NFCX=NNCEL(IFH-1)+1
      GO TO 115
  103 IFH=1
      ILH=NNHIS
  104 NFCX=1
      GO TO 115
  105 IF (IHIST-NNHIS) 107,107,106
  106 CALL ERROR (521)
  107 IF (IHIST-1) 108,108,109
  108 FXX=0.
      GO TO 110
  109 FXX=NNCEL(IHIST-1)
C
C*****TRANSLATE XX BY SUBTRACTING HHLOW(IHIST)
C
  110 X=XX(1)-HHLOW(IHIST)
      IF (X) 111,111,112
  111 IC=FXX+1.
      GO TO 114
C
C*****DETERMINE CELL NUMBER IC. ADD 1 FOR LOWER LIMIT CELL AND 1 FOR
C*****TRUNCATION.
C
  112 IC=X/HHWID(IHIST)+1.999999+FXX
      IF (IC-NNCEL(IHIST)) 114,114,113
  113 IC=NNCEL(IHIST)
  114 JJCEL(IC)=JJCEL(IC)+1
      GO TO 128
  115 DO 127 I=IFH,ILH
      XLOW=HHLOW(I)
      NLCX=NNCEL(I)
      NTOT=0
      DO 116 K=NFCX,NLCX
  116 NTOT=NTOT+JJCEL(K)
      XTOT=NTOT
      WRITE (NPRNT,129) I,LLABH(I,1),LLABH(I,2)
      IF (NTOT) 117,117,118
  117 WRITE (NPRNT,130)
      GO TO 126
  118 CUML=0.
      DO 125 J=NFCX,NLCX
      RELA=FLOAT(JJCEL(J))/XTOT
      CUML=CUML+RELA
      MR=RELA*50.+.5
      MC=CUML*50.+.5
      DO 119 N=1,50
  119 NOUT(N)=IBLNK
      NOUT(50)=IPLUS
      IF (MC.GE.1) NOUT(MC)=ICEE
      IF (MR) 122,122,120
  120 DO 121 N=1,MR
  121 NOUT(N)=IAST
  122 IF (J-NLCX) 123,124,125
  123 WRITE (NPRNT,132) JJCEL(J),RELA,CUML,XLOW,NOUT
      XLOW=XLOW+HHWID(I)
      GO TO 125
  124 WRITE (NPRNT,131) JJCEL(J),RELA,CUML,NOUT
  125 CONTINUE
      WRITE (NPRNT,133) NTOT
  126 NFCX=NLCX+1
  127 CONTINUE
  128 RETURN
C
  129 FORMAT (1H1,54X,18H**HISTOGRAM NUMBER,I3,2H**//61X,2A4///20X,4HOBS
     1V,5X,4HRELA,5X,4HCUML,6X,10H  UPPER   /20X,3(4HFREQ,5X),1X,10HCELL
     2 LIMIT,6X,1H0,8X,2H20,8X,2H40,8X,2H60,8X,2H80,7X,3H100/60X,11(4X,1
     3H+))
  130 FORMAT (///20X,19HNO VALUES RECORDED.)
  131 FORMAT (19X,I5,2(4X,F5.3),9X,3HINF,10X,1H+,50A1)
  132 FORMAT (19X,I5,2(4X,F5.3),5X,E11.4,6X,1H+,50A1)
  133 FORMAT (21X,3H---,40X,1H+,10(4X,1H+)/19X,I5,40X,1H0,8X,2H20,8X,2H4
     10,8X,2H60,8X,2H80,7X,3H100)
C
      END

      FUNCTION KROSS(IKRSG,IKRSD,CMULT,CADD,LDIR,TOL)
      include 'siman.h'
      JKRSG=IKRSG
      JKRSD=IKRSD
      IF (JKRSG) 101,126,102
  101 JKRSG=-JKRSG
      CRSGL=DDL(JKRSG)
      CRSGN=DD(JKRSG)
      GO TO 103
  102 CRSGL=SSL(JKRSG)
      CRSGN=SS(JKRSG)
  103 IF (JKRSD) 104,105,106
  104 JKRSD=-JKRSD
      CRSDL=DDL(JKRSD)*CMULT+CADD
      CRSDN=DD(JKRSD)*CMULT+CADD
      GO TO 107
  105 CRSDL=CADD
      CRSDN=CADD
      GO TO 107
  106 CRSDL=SSL(JKRSD)*CMULT+CADD
      CRSDN=SS(JKRSD)*CMULT+CADD
  107 IF (CRSGL-CRSDL) 108,126,109
  108 IF (CRSGN-CRSDN) 126,110,110
  109 IF (CRSGN-CRSDN) 113,113,126
  110 IF (LDIR) 126,111,111
  111 IF (CRSGN-CRSDN-TOL) 112,112,120
  112 KROSS=1
      GO TO 116
  113 IF (LDIR) 114,114,126
  114 IF (CRSGN-CRSDN+TOL) 121,115,115
  115 KROSS=-1
  116 IF (ISEES) 127,117,127
  117 IF (IKRSG) 118,127,119
  118 ISEES=JKRSG+1000
      GO TO 127
  119 ISEES=JKRSG
      GO TO 127
  120 KROSS=2
      GO TO 122
  121 KROSS=-2
  122 IF (ISEES) 127,123,123
  123 IF (IKRSG) 124,127,125
  124 ISEES=-JKRSG-1000
      GO TO 127
  125 ISEES=-JKRSG
      GO TO 127
  126 KROSS=0
  127 RETURN
C
      END

      FUNCTION NFIND(XVAL,MCODE,IFILE,JATT,TOL)
      REAL XVAL(1)
      include 'siman.h'
C
C*****THE ENTRY WHICH IS THE BEST CANDIDATE IS KBEST
C
      KBEST=0
C
C*****THE NEXT ENTRY TO BE CONSIDERED IS NEXTK.
C
      NEXTK=MFE(IFILE)
      KODE=411
      IF (NEXTK) 101,102,103
  101 CALL ERROR (KODE)
  102 NFIND=KBEST
      GO TO 119
C
C*****XGRNV IS +1 FOR GREATER THAN SEARCH AND -1 FOR LESS THAN SEARCH
C*****XMAMN IS +1 FOR MAXIMUM AND -1 FOR MINIMUM
C*****FOR SEARCH FOR EQUALITY THE SIGN OF XGRNV AND XMAMN ARE NOT USED.
C
  103 GO TO (104,105,106,107,104), MCODE
  104 XGRNV=1.
      XMAMN=1.
      GO TO 108
  105 XGRNV=1.
      XMAMN=-1.
      GO TO 108
  106 XGRNV=-1.
      XMAMN=1.
      GO TO 108
  107 XGRNV=-1.
      XMAMN=-1.
  108 NSISA=JATT+NEXTK
      TEMP=XGRNV*(QSET(NSISA)-XVAL(1))
      TEM=TEMP
      IF (TEMP) 109,110,110
  109 TEM=-TEMP
  110 IF (TEM-TOL) 112,112,111
  111 IF (TEMP) 117,112,113
C
C*****WHEN EQUALITY IS OBTAINED TEST FOR MCODE=5, THE SEARCH FOR A
C*****SPECIFIED VALUE.
C
  112 IF (MCODE-5) 117,118,117
  113 IF (MCODE-5) 114,117,114
  114 KODE=412
      IF (KBEST) 101,116,115
  115 NSISB=JATT+KBEST
      IF (XMAMN*(QSET(NSISA)-QSET(NSISB))) 117,117,116
  116 KBEST=NEXTK
  117 NSISA=NNAPO+NEXTK
      NEXTK=NSET(NSISA)
      IF (NEXTK) 102,102,108
  118 NFIND=NEXTK
  119 RETURN
C
      END

      FUNCTION NPRED(NTRY)
      include 'siman.h'
      INTEGER NTRY(1)
      INDEX=NTRY(1)
      NPRED=NSET(INDEX)
      RETURN
C
      END

      FUNCTION NSUCR(NTRY)
      include 'siman.h'
      INTEGER NTRY(1)
      INDEX=NTRY(1)+NNAPO
      NSUCR=NSET(INDEX)
      RETURN
C
      END

      SUBROUTINE PRNTQ (IFILE)
      include 'siman.h'
C
C ************  PATCH ****************
C
      GOTO 117
C
C ************  PATCH ****************
C ##### following commented by Bob Crites 12/93
C
C     IF (IFILE) 101,101,107
C 101 WRITE (NPRNT,124) TNOW
C     IF (NNFIL) 102,102,103
C 102 WRITE (NPRNT,126)
C     GO TO 117
C 103 DO 104 I=1,NNTRY
C     IXX=(I-1)*NNAPT+1
C     IF (NSET(IXX)) 105,104,104
C 104 CONTINUE
C     I=NNTRY
C     GO TO 106
C 105 I=IXX/NNAPT
C 106 WRITE (NPRNT,125) I
C     IFF=1
C     ILF=NNFIL
C     GO TO 108
C 107 IFF=IFILE
C     ILF=IFF
C 108 DO 116 JQG=IFF,ILF
C     WRITE (NPRNT,119) JQG,TNOW,QQTIM(JQG)
C     TPFS=TNOW-TTSET
C     IF (TPFS) 110,110,109
C
C*****COMPUTE FILE STATISTICS
C
C 109 XNQ=NNQ(JQG)
C     X=(EENQ(JQG)+XNQ*(TNOW-QQTIM(JQG)))/TPFS
C     STD=((VVNQ(JQG)+XNQ*XNQ*(TNOW-QQTIM(JQG)))/TPFS-X*X)
C     STD=SIGN(SQRT(ABS(STD)),STD)
C     WRITE (NPRNT,123) TPFS,X,STD,MMAXQ(JQG)
C
C*****PRINT FILE IN PROPER ORDER REQUIRES TRACING THROUGH THE POINTERS
C*****OF THE FILE
C
C 110 LINE=MFE(JQG)
C     IF (LINE) 111,111,112
C 111 WRITE (NPRNT,121)
C     GO TO 116
C 112 WRITE (NPRNT,120)
C     IXX=0
C 113 IXX=IXX+1
C     DO 114 I=1,NNATR
C     NSISA=I+LINE
C 114 TTRIB(I)=QSET(NSISA)
C     WRITE (NPRNT,122) IXX,(TTRIB(I),I=1,NNATR)
C     NSISA=NNAPO+LINE
C     LINE=NSET(NSISA)
C     IF (LINE) 115,116,113
C 115 WRITE (NPRNT,118)
C     STOP
C 116 CONTINUE
  117 RETURN
C
  118 FORMAT (///45X,27HERROR EXIT, TYPE 541 ERROR.)
  119 FORMAT (//45X,23HPRINTOUT OF FILE NUMBER,I4/49X,6HTNOW =,E12.4/49X
     1,6HQQTIM=,E12.4)
  120 FORMAT (/51X,13HFILE CONTENTS)
  121 FORMAT (/49X,17HTHE FILE IS EMPTY)
  122 FORMAT (2X,5HENTRY,I4,4X,1H=,6(3X,E12.4,1X)/(16X,6(3X,E12.4,1X)))
  123 FORMAT (/39X,26HTIME PERIOD FOR STATISTICS,E11.4/39X,22HAVERAGE NU
     1MBER IN FILE,4X,F11.4/39X,18HSTANDARD DEVIATION,8X,F11.4/39X,22HMA
     2XIMUM NUMBER IN FILE,6X,I4)
  124 FORMAT (1H1,32X,37H**GASP FILE STORAGE AREA DUMP AT TIME,E12.4,2H*
     1*)
  125 FORMAT (//33X,48HMAXIMUM NUMBER OF ENTRIES IN FILE STORAGE AREA =,
     1I3)
  126 FORMAT (//41X,35HFILE STORAGE AREA NOT USED, NNFIL=0)
C
      END        

      SUBROUTINE PRNTS
      include 'siman.h'
      WRITE (NPRNT,105) TNOW
      IF (NNEQT) 101,102,103
  101 CALL ERROR (551)
  102 WRITE (NPRNT,106)
      GO TO 104
  103 WRITE (NPRNT,107)
      WRITE (NPRNT,108) (I,SS(I),DD(I),I=1,NNEQT)
  104 RETURN
C
  105 FORMAT (1H1,32X,38H**GASP STATE STORAGE AREA DUMP AT TIME,E12.4,2H
     1**)
  106 FORMAT (//41X,36HSTATE STORAGE AREA NOT USED, NNEQT=0)
  107 FORMAT (//43X,3H(I),8X,5HSS(I),12X,5HDD(I),13X)
  108 FORMAT (41X,I4,5X,E12.4,4X,E12.4)
C
      END

      FUNCTION PRODQ(JATT,IFILE)
      include 'siman.h'
      PRODQ=1.
      IF (IFILE-NNFIL) 102,102,101
  101 CALL ERROR (811)
  102 IF (NNQ(IFILE)) 103,103,104
  103 PRODQ=0.
      RETURN
  104 MTEM=MFE(IFILE)
  105 NSISA=JATT+MTEM
      PRODQ=PRODQ*QSET(NSISA)
      NSISA=NNAPO+MTEM
      MTEM=NSET(NSISA)
      IF (MTEM) 106,106,105
  106 RETURN
C
      END

      SUBROUTINE RMOVE (NTRY,IFILE)
      include 'siman.h'
      INTEGER NTRY(1)
      NTRYG=NTRY(1)
      IF (NTRYG) 101,101,102
  101 CALL ERROR (311)
C
C*****PUT VALUES OF NTRY IN ATRIB
C
  102 DO 103 I=1,NNATR
      NSISA=NTRYG+I
  103 ATRIB(I)=QSET(NSISA)
      IFILG=IFILE
      IF (IFILE) 104,101,105
  104 IFILG=-IFILE
C
C*****REMOVAL OF AN ENTRY FROM IFILE.
C*****UPDATE POINTERS TO ACCOUNT FOR REMOVAL OF NTRY.
C*****LET JL EQUAL SUCCESSOR OF NTRY AND JK EQUAL PREDECESSOR OF NTRY.
C*****IF JL=0, NTRY WAS LAST ENTRY. IF JK=0, NTRY WAS FIRST ENTRY.
C
  105 NSISA=NNAPO+NTRYG
      JL=NSET(NSISA)
      JK=NSET(NTRYG)
      NSET(NSISA)=MFA
      MFA=NTRYG
      NSISA=NNAPO+JK
      IF (JL) 107,107,106
  106 IF (JK) 109,109,108
  107 IF (JK) 111,111,110
C
C*****NTRY WAS NOT FIRST OR LAST ENTRY. UPDATE POINTERS SO THAT
C*****JL IS SUCCESSOR OF JK AND JK IS PREDECESSOR OF JL.
C
  108 NSET(NSISA)=JL
      NSET(JL)=JK
      GO TO 112
C
C*****NTRY WAS FIRST ENTRY BUT NOT LAST ENTRY. UPDATE POINTERS.
C
  109 NSET(JL)=0
      MFE(IFILG)=JL
      GO TO 112
C
C*****NTRY WAS LAST ENTRY BUT NOT FIRST ENTRY. UPDATE POINTERS.
C
  110 NSET(NSISA)=0
      MLE(IFILG)=JK
      GO TO 112
C
C*****NTRY WAS ONLY ENTRY. UPDATE POINTERS.
C
  111 MFE(IFILG)=0
      MLE(IFILG)=0
C
C*****IF IFILG=1 UPDATE TTNEX
C
  112 IF (IFILG-1) 114,113,117
  113 NEXTE=MFE(1)
      IF (NEXTE) 114,116,115
  114 WRITE (NPRNT,118)
      CALL ERROR (312)
  115 TTNEX=QSET(NEXTE+1)
      IF (TTNEX-TTFIN) 117,117,116
  116 TTNEX=TTFIN
C
C*****UPDATE FILE STATISTICS.
C
  117 XNQ=NNQ(IFILG)
      EENQ(IFILG)=EENQ(IFILG)+XNQ*(TNOW-QQTIM(IFILG))
      VVNQ(IFILG)=VVNQ(IFILG)+XNQ*XNQ*(TNOW-QQTIM(IFILG))
      QQTIM(IFILG)=TNOW
      NNQ(IFILG)=NNQ(IFILG)-1
      RETURN
C
  118 FORMAT (//5X,44HPOSSIBLE CAUSE OF ERROR IS USER BLANK COMMON)
C
      END

      SUBROUTINE SET
      include 'siman.h'
      IF (NNTRY.LE.0) CALL ERROR (221)
      TTSET=TNOW
      MFA=1
C
C*****INITIALIZE POINTING CELLS OF NSET.
C
      DO 101 I=1,NNTRY
      ICSUC=I*NNAPT
      ICPRD=ICSUC-NNAPO
      NSET(ICPRD)=-1
  101 NSET(ICSUC)=ICSUC+1
      NSET(ICSUC)=0
      DO 102 K=1,NNFIL
      NNQ(K)=0
      MFE(K)=0
      MMAXQ(K)=0
      MLE(K)=0
      EENQ(K)=0.0
      VVNQ(K)=0.0
  102 QQTIM(K)=TNOW
      RETURN
C
      END

      FUNCTION SUMQ(JATT,IFILE)
      include 'siman.h'
      SUMQ=0.0
      IF (IFILE-NNFIL) 102,102,101
  101 CALL ERROR (801)
  102 IF (NNQ(IFILE)) 103,103,104
  103 RETURN
  104 MTEM=MFE(IFILE)
  105 NSISA=JATT+MTEM
      SUMQ=SUMQ+QSET(NSISA)
      NSISA=NNAPO+MTEM
      MTEM=NSET(NSISA)
      IF (MTEM) 106,106,105
  106 RETURN
C
      END

      SUBROUTINE TIMSA (XX,T,ISTAT)
      include 'siman.h'
      REAL XX(1)
      X=(SSTPV(ISTAT,6)+XX(1))*0.5
      SSTPV(ISTAT,6)=XX(1)
      IF (ISTAT-NNSTA) 102,102,101
  101 CALL ERROR (511)
  102 TT=T-SSTPV(ISTAT,3)
      SSTPV(ISTAT,1)=SSTPV(ISTAT,1)+X*TT
      SSTPV(ISTAT,2)=SSTPV(ISTAT,2)+X*X*TT
      SSTPV(ISTAT,3)=T
      IF (XX(1)-SSTPV(ISTAT,4)) 103,104,104
  103 SSTPV(ISTAT,4)=XX(1)
  104 IF (XX(1)-SSTPV(ISTAT,5)) 106,106,105
  105 SSTPV(ISTAT,5)=XX(1)
  106 RETURN
C
      END

      SUBROUTINE TIMST (XX,T,ISTAT)
      include 'siman.h'
      REAL XX(1)
      IF (ISTAT) 101,102,103
  101 IFC=-ISTAT
      ILC=IFC
      GO TO 109
  102 IFC=1
      ILC=NNSTA
      GO TO 109
  103 IF (ISTAT-NNSTA) 105,105,104
  104 CALL ERROR (511)
  105 TT=T-SSTPV(ISTAT,3)
      YY=SSTPV(ISTAT,6)
      SSTPV(ISTAT,1)=SSTPV(ISTAT,1)+YY*TT
      SSTPV(ISTAT,2)=SSTPV(ISTAT,2)+YY*YY*TT
      SSTPV(ISTAT,6)=XX(1)
      SSTPV(ISTAT,3)=T
      IF (XX(1)-SSTPV(ISTAT,4)) 106,107,107
  106 SSTPV(ISTAT,4)=XX(1)
  107 IF (XX(1)-SSTPV(ISTAT,5)) 114,114,108
  108 SSTPV(ISTAT,5)=XX(1)
      GO TO 114
  109 WRITE (NPRNT,115)
      T=TNOW
      DO 113 J=IFC,ILC
      IF (SSTPV(J,3)-TTCLR) 110,111,112
  110 CALL ERROR (512)
  111 WRITE (NPRNT,116) LLABT(J,1),LLABT(J,2)
      GO TO 113
  112 XS=SSTPV(J,1)+SSTPV(J,6)*(T-SSTPV(J,3))
      XSS=SSTPV(J,2)+SSTPV(J,6)*SSTPV(J,6)*(T-SSTPV(J,3))
      XT=T-TTCLR
      AVG=XS/XT
      STD=(XSS/XT-AVG*AVG)
      IF(STD.LT.0.0) STD=0.0
      STD=SQRT(STD)
      WRITE (NPRNT,117) LLABT(J,1),LLABT(J,2),AVG,STD,SSTPV(J,4),SSTPV(J
     1,5),XT,SSTPV(J,6)
  113 CONTINUE
  114 RETURN
C
  115 FORMAT (/36X,44H**STATISTICS FOR TIME-PERSISTENT VARIABLES**/16X,4
     1HMEAN,10X,7HSTD DEV,9X,7HMINIMUM,9X,7HMAXIMUM,7X,13HTIME INTERVAL,
     23X,10HCUR. VALUE/)
  116 FORMAT (2X,2A4,39X,18HNO VALUES RECORDED)
  117 FORMAT (2X,2A4,1X,6(E12.4,4X))
C
      END

      FUNCTION BETA(IPAR,ISTRM)
      include 'siman.h'
      A=PPARM(IPAR,1)
      B=PPARM(IPAR,4)
      X=GAM(A,ISTRM)
      BETA=X/(X+GAM(B,ISTRM))
      BETA=BETA*(PPARM(IPAR,3)-PPARM(IPAR,2))+PPARM(IPAR,2)
      RETURN
C
      END

      FUNCTION ERLNG(IPAR,ISTRM)
      include 'siman.h'
      K=PPARM(IPAR,4)
      IF (K-1) 101,102,102
  101 CALL ERROR (741)
  102 R=1
      DO 103 I=1,K
  103 R=R*DRAND(ISTRM)
      ERLNG=-PPARM(IPAR,1)*ALOG(R)
      IF (ERLNG-PPARM(IPAR,2)) 104,107,105
  104 ERLNG=PPARM(IPAR,2)
      GO TO 107
  105 IF (ERLNG-PPARM(IPAR,3)) 107,107,106
  106 ERLNG=PPARM(IPAR,3)
  107 RETURN
C
      END

      FUNCTION EXPON(AVETM,ISTRM)
      REAL AVETM(1)
      EXPON = -AVETM(1)*ALOG (DRAND(ISTRM))
      RETURN
C
      END

      FUNCTION GAM(AK,ISTRM)
      K=AK
      FK=K
      GAM=0.
      IF (K) 103,103,101
  101 PROD=1.0
      DO 102 I=1,K
  102 PROD=PROD*DRAND(ISTRM)
      GAM=-ALOG(PROD)
  103 DG=AK-FK
      IF (DG-.015) 110,110,104
  104 IF (DG-.985) 106,105,105
  105 W=1.
      GO TO 109
  106 A=1./DG
      B=1./(1.-DG)
  107 X=DRAND(ISTRM)**A
      Y=DRAND(ISTRM)**B+X
      IF (Y-1.) 108,108,107
  108 W=X/Y
  109 Y=-ALOG(DRAND(ISTRM))
      GAM=GAM+W*Y
  110 RETURN
C
      END

      FUNCTION GAMA(IPAR,ISTRM)
      include 'siman.h'
      A=PPARM(IPAR,4)
      GAMA=GAM(A,ISTRM)*PPARM(IPAR,1)
      IF (GAMA-PPARM(IPAR,2)) 101,104,102
  101 GAMA=PPARM(IPAR,2)
      GO TO 104
  102 IF (GAMA-PPARM(IPAR,3)) 104,104,103
  103 GAMA=PPARM(IPAR,3)
  104 RETURN
C
      END

      FUNCTION NPSSN(IPAR,ISTRM)
      include 'siman.h'
      NPSSN=0
      P=PPARM(IPAR,1)
      IF (P-9.0) 101,101,104
  101 Y=EXP(-P)
      X=1.0
  102 X=X*DRAND(ISTRM)
      IF (X-Y) 105,103,103
  103 NPSSN=NPSSN+1
      GO TO 102
  104 TEMP=PPARM(IPAR,4)
      PPARM(IPAR,4)=SQRT(PPARM(IPAR,1))
      NPSSN=RNORM(IPAR,ISTRM)+.5
      PPARM(IPAR,4)=TEMP
      IF (NPSSN) 104,105,105
  105 KK=PPARM(IPAR,2)
      KKK=PPARM(IPAR,3)
      NPSSN=KK+NPSSN
      IF (NPSSN-KKK) 107,107,106
  106 NPSSN=PPARM(IPAR,3)
  107 RETURN
C
      END

      FUNCTION RLOGN(IPAR,ISTRM)
C
C*****THE PARAMETERS USED WITH RLOGN ARE THE MEAN AND STANDARD DEVIATION
C*****OF A NORMAL DISTRIBUTION
C
      VA=RNORM(IPAR,ISTRM)
      RLOGN=EXP(VA)
      RETURN
C
      END

      FUNCTION RNORM(IPAR,ISTRM)
      include 'siman.h'
      SUM=0.0
      DO 101 I=1,12
  101 SUM=SUM+DRAND(ISTRM)
      V=SUM-6.0
      RNORM=V*PPARM(IPAR,4)+PPARM(IPAR,1)
      IF (RNORM-PPARM(IPAR,2)) 102,105,103
  102 RNORM=PPARM(IPAR,2)
      GO TO 105
  103 IF (RNORM-PPARM(IPAR,3)) 105,105,104
  104 RNORM=PPARM(IPAR,3)
  105 RETURN
C
      END

      FUNCTION TRIAG(IPAR,ISTRM)
      include 'siman.h'
      RN=DRAND(ISTRM)
      BMA=PPARM(IPAR,1)-PPARM(IPAR,2)
      CMA=PPARM(IPAR,3)-PPARM(IPAR,2)
      IF (RN-BMA/CMA) 101,101,102
  101 TRIAG=PPARM(IPAR,2)+SQRT(BMA*CMA*RN)
      GO TO 103
  102 TRIAG=PPARM(IPAR,3)-SQRT(CMA*(1.-RN)*(PPARM(IPAR,3)-PPARM(IPAR,1))
     1)
  103 RETURN
C
      END

      FUNCTION UNFRM(ULO,UHI,ISTRM)
      UNFRM=ULO+(UHI-ULO)*DRAND(ISTRM)
      RETURN
C
      END

      FUNCTION WEIBL(BETA,ALPHA,ISTRM)
      REAL BETA(1),ALPHA(1)
      WEIBL = (-BETA(1)*ALOG(DRAND(ISTRM)))**(1./ALPHA(1))
      RETURN
C
      END

      SUBROUTINE OTPUT
      I=1
      RETURN
C
      END

      SUBROUTINE UERR (KODE)
      I=KODE
      RETURN
C
      END

C ##### commented by Bob Crites 12/93
C     SUBROUTINE INTLC
C     I=1
C     RETURN
C
C     END

      SUBROUTINE STATE
      I=1
      RETURN
C
      END

      SUBROUTINE SCOND
      I=1
      RETURN
C
      END

C ##### commented by Bob Crites 12/93
C     SUBROUTINE EVNTS (IX)
C     I=IX
C     RETURN
C
C     END

      subroutine evnts(n)
      include 'siman.h'
      include 'my.h'
        call event(job,n)
      return
      end

      SUBROUTINE SSAVE
      I=1
      RETURN
C
      END

      SUBROUTINE UMONT(ITRAC)
      ITRAC=0
      RETURN
C
      END

      FUNCTION DPROB(CPROB,VALUE,NVAR,ISTRM)
      REAL CPROB(1),VALUE(1)
      RN=DRAND(ISTRM)
      DO 10 I=1,NVAR
      IF(RN.LE.CPROB(I))GO TO 20
   10 CONTINUE
      CALL ERROR(751)
   20 DPROB=VALUE(I)
      RETURN
      END

      FUNCTION DRAND(ISTRM)
        include 'siman.h'
C
C*****IF NSTRM IS GREATER THAN 6, THE DIMENSION AND DATA STATMENTS
C*****MUST REFLECT THE INCREASE
C
      INTEGER L(6)
C
C*****NBITS SHOULD BE SET EQUAL TO THE NUMBER OF BITS IN A FIXED POINT
C*****NUMBER FOR THE HOST COMPUTING SYSTEM
C
      DATA NBITS/32/
      IF (ISTRM) 102,101,104
101   CALL ERROR(701)
102   ISTRG=-ISTRM
      IF(ISTRG-NNSTR) 103,103,101
103   L(ISTRG)=SSEED(ISTRG)
      L(ISTRG)=IABS(L(ISTRG))
      L(ISTRG)=(L(ISTRG)/2)*2+1
      IF (((L(ISTRG)/5)*5) .EQ. L(ISTRG)) L(ISTRG)=L(ISTRG)-2
      GOTO 105
104   ISTRG=ISTRM
      IF(ISTRG-NNSTR) 105,105,101
105   IOPT=IABS(L(ISTRG))
      IF(IOPT .EQ. 0) IOPT=1
      IF (NBITS) 106,106,107
106   IOPT=IOPT*MULT
      IOPT=IOPT-(IOPT/NBASE)*NBASE
      L(ISTRG)=IOPT
      DRAND=FLOAT(IOPT)/BASE
      RETURN
107   XBITS=NBITS-1
      NB=XBITS/3.0
      NBASE=2.0**(2*NB)
      BASE=NBASE
      MX=2.0**NB
      MULT=(MX/8)*8-3
      IF((MULT/5)*5 .EQ. MULT) MULT=MULT-2
      NBITS= -1
      GOTO 106
C
      END

C **********************************************************************
C
C     end_run
C
C **********************************************************************

      SUBROUTINE end_run

      INCLUDE 'siman.h'

      TNOW = TTFIN

      RETURN
      END


