/*	This is the implementation of the main() function for
	the program that implements an RL system with RMDP task, 
	Sarsa agent with replacing eligibility traces and
	CMAC function approximator.

  Author: Bohdana Ratitch
  Version: April 2002
  file: rmdp_sarsart_cmac.cpp

*/

#include <iostream.h>
#include<time.h>
#include<math.h>
#include<sys/types.h>
#include<stdlib.h>
#include <fstream.h>

//#define DISPLAY_OUTPUT

#ifndef INTERFACE_CLASSES	
#define INTERFACE_CLASSES 1
#include "interface_classes.h"
#endif

#ifndef rmdp	
#define rmdp
#include "rmdp.h"
#endif

#ifndef FA_CMAC	
#define FA_CMAC 1
#include "cmac.h"
#endif

#ifndef SARSA_AGENT	
#define SARSA_AGENT 1
#include "sarsart_agent.h"
#endif

#include "main_init.h"

void run(MainParameters& mainP,  StateActionFA* safa, Agent* agent, bool SaveFA=true);

void main(int argc, char* argv[]){

  int i, d, j;
  char c, *buffer;
  int p=0;
  int steps=0;
	
  if (argc==1){
    cout << "Supply command-line parameters" << endl;
    exit(EXIT_FAILURE);
  }

	
  MainParameters mainP;
  p+=mainP.process(argc,argv);

  RMDPparameters rmdpP;
  p+=rmdpP.process(argc, argv);

  if (p>0){
    cout << "Usage:" << endl;
    cout << "executable_name parameter1=value1 parameter2=value2 ..." << endl;
    CMAC::helpLearningParameters();
    SarsaAgentRT::helpLearningParameters();
    exit(EXIT_SUCCESS);
  }
	
  time_t stime;
  time(&stime);
  struct tm* currentTime;
  currentTime=gmtime(&stime);
  unsigned seed;
  seed=(currentTime->tm_hour+1)*currentTime->tm_min*currentTime->tm_sec;
  srand(seed);
 
  //state space and actions
	
  ActionSet* asr;
  RMDP* mdp = new RMDP(load, rmdpP, &asr, false);
  Environment* env = mdp;

  ActionSet as = (*asr);

  //Set parameters for CMAC and 
  //create approximators for each action with appropriate parameters
	
	

  if (mainP.strFile==NULL){
    cout << "Please provide name of file containing approximator structure or press e to exit" << endl;
    buffer = new char[20];
    cin >> buffer;
    if (strcmp("e", buffer)==0)
      exit(EXIT_SUCCESS);
    else {
      mainP.strFile = new char[strlen(buffer)+1];
      strcpy(mainP.strFile, buffer);
    }
  }

	

  Approximator** cmacSet = new Approximator*[Action::count];
		
  double* left = new double[State::dimensionality];
  double* right = new double[State::dimensionality];
  env->getStateSpaceBounds(left, right);
  CMAC::setInputBounds(left,right);
	
  for(i=0; i<Action::count; i++){
    cmacSet[i] = new CMAC(mainP.strFile);
  }
	
  for(i=0; i<Action::count; i++){
    cmacSet[i]->setLearningParameters(argc, argv);
  }

  StateActionFA* safa = new StateActionFA(Action::count, cmacSet);

  //create a learning agent object
  SarsaAgentRT* sarsa = new SarsaAgentRT(1, as, safa, env);
  Agent* agent = sarsa;
  agent->setLearningParameters(argc, argv);


  run(mainP, safa, agent);


  delete sarsa;
  delete safa;
  delete mdp;
}







