#include <stdlib.h>
#include <string.h>
#include<stdio.h>
#include<stddef.h>
#include<math.h>
#include<sys/types.h>		
#include<iostream.h>
#include<fstream.h>

#ifndef PWC	
	#define PWC
	#include "pwc.h"
#endif

#ifndef INTERFACE_CLASSES	
	#define INTERFACE_CLASSES 1
	#include "interface_classes.h"
#endif

//#define DEBUG

pwc::pwc()
{
  Inputs=0;
  LeftBounds = NULL;
  RightBounds = NULL;
  origin = NULL;
  n = NULL;
  h = NULL;
  IndCoef = NULL;
  weights = NULL;
  N=0;
}

pwc::pwc(int in, double* left, double* right, int* nn, double weightLow, double weightHigh, double* orig=NULL, int DiscreteValues=0)
{
  Inputs=in;
  LeftBounds = new double[Inputs];
  RightBounds = new double[Inputs];
  n = new int[Inputs];
  h = new double[Inputs];
  IndCoef = new int[Inputs];
  origin = new double[Inputs];
	
  if ((LeftBounds==NULL)||(RightBounds==NULL)||(n==NULL)||(h==NULL)||(IndCoef==NULL)){
    cout << "Memory allocation error" << endl;
    exit(EXIT_FAILURE);
  }
	
  int i;
  double offset;
  N=1;	
  IndCoef[Inputs-1]=1;
	
  for(i=Inputs-1; i>=0; i--){
    LeftBounds[i]=left[i];
    RightBounds[i]=right[i];
    h[i]=(RightBounds[i]-LeftBounds[i])/nn[i];
    if (orig!=NULL){
      origin[i]=orig[i];
      if (origin[i]==LeftBounds[i])
	n[i]=nn[i];
      else
	n[i]=nn[i]+1;
    }
    else{
      origin[i]=LeftBounds[i]-((double)rand()/(double)RAND_MAX*h[i]);
      n[i]=nn[i]+1;
    }
      
    N=N*n[i];
    if (i<(Inputs-1))
      IndCoef[i]=IndCoef[i+1]*n[i+1];
  }

  weights = new double[N];
  if (weights==NULL){
    cout << "pwc: Allocation of weights array was not successfull" << endl;
    exit(EXIT_FAILURE);
  }
  
  for (i=0; i<N; i++){
    if (DiscreteValues==0){
      weights[i]=(double)rand()/(double)RAND_MAX;	//weights are in [0,1] range
      weights[i]=weightLow+(weightHigh-weightLow)*weights[i]; // make weights in the specified interval
    }
    else{ //generate weights corresponding to a discrete set
      weights[i]=discreteSample(weightLow,weightHigh,DiscreteValues);
    }
    
  }
  
}

void pwc::weightInterval(const Subset& in, double left, double right,int DiscreteValues)
/*	Randomly generates weights for a subset of input space in
		a specified interval
		Parameters:
		in	:	subset of the input space as a hypercub 
		left	:	left limit of the weights
		right	:	right  limit of the weights
	*/

{

  int i, j;
  int* ind_low = new int[Inputs];
  int* ind_high = new int[Inputs];
  int* ind = new int[Inputs];
  int index;

  
  
  for (i=0; i<Inputs; i++){
    if (in.left[i]>=RightBounds[i]) ind_low[i]=n[i]-1;
    else

      ind_low[i]=(int)(float)((in.left[i]-origin[i])/h[i]);
	  

    if (in.right[i]>=RightBounds[i]) ind_high[i]=n[i]-1;
    else
      ind_high[i]=(int)(float)((in.right[i]-origin[i])/h[i]);
	  
    ind[i]=ind_low[i];
	  
  }
	
	
  /*	The following fragment implements filling a subset (hypercube) with weights
	in a particular interval. ind is an array of indeces of discretized intervals 
	along each dimension and can be regarded as a tuple representing current coordinates 
	of a discretization unit. We are changing those tuples in a lexicographic order.
  */

  j=Inputs-1;
  while (j>=0){
    index=0;
    for (i=0; i<Inputs; i++) //compute index in one dimensional array representation
      index=index+IndCoef[i]*ind[i];
    if (DiscreteValues==0){
      weights[index]=left+(right-left)*((double)rand()/(double)RAND_MAX); //set weights
    }
    else
      weights[index]=discreteSample(left,right, DiscreteValues);
    
		
    //move to the next discretization unit (change tuple of indeces in lexicographic order)
    j=Inputs-1; 
    while (j>=0){
      if ((ind[j]+1)>ind_high[j]){
	ind[j]=0;
	j--;
      }
      else {
	ind[j]++;
	break;
      }
    }
  }
}

int pwc::getSize()
  /* Return the number of parameters in this architecture
   */
{
  return N;
}

void pwc::predict(const State& s, double& output)
  /*	Predicts an output value for a given input.
			Parameters:
				s : reference to the input (state)
				output : returned value of the predicted output
		*/
{
  int i, ind, index;
  int diag;

  
  index=0;
  for(i=0; i<Inputs; i++){
    if (s.x[i]>=RightBounds[i]){ 
      ind=n[i]-1; 
      diag=0;
    }

    else{
      ind=(int)(float)((s.x[i]-origin[i])/h[i]); 
      diag=1;
      if (ind == n[i]) ind=n[i]-1;
      //cout << "ind[" << i << "]=" << ind << " IndCoef[" << i << "]=" << IndCoef[i] << endl;
    }

#ifdef DEBUG
    cout << "s.x[" << i << "]=" << s.x[i] << " i[" << i<< "]=" << ind << " n[" << i << "]=" << n[i] << endl;
#endif
		
    index=index+IndCoef[i]*ind;
  }
		
#ifdef DEBUG
  cout << endl;
  cout << "Index = " << index << " N=" << N << endl;
#endif

  if ((index<0) || (index>=N)) {
    cout << "Error (pwc): region index out of limits" << endl;
    cout << "index=" << index << endl;
    cout << "diagnostic=" << diag << endl;
    cout << "N=" << N << endl;
    for(i=0; i<State::dimensionality; i++)
      cout << "s.x[" << i << "]=" << s.x[i] << " n[" << i << "]=" << n[i] << endl;
    exit(EXIT_FAILURE);
  }

  output=weights[index];

#ifdef DEBUG
  cout << "Active parameter :" << output << endl;
#endif


}

void pwc::learn(const State& s, const double target)
  /* Learns an input-output pair.
     s : input (state)
     target: target output value
  */
{
}

void pwc::computeGradient(const State& s, double* GradientVector)
  /*	Compute the gradient w.r.t. architecture parameters at the current parameters' values and input s
   */
{
}

void pwc::updateParameters(double* delta)
	/*	Update parameters by amounts in delta array
	*/
{
}

void pwc::setParameter(int index, double value){
  if ((index<0) || (index >=N)) {
    cout << "Index out of bounds (" << index << ") sent to the pwc::setParameter() function" << endl;
    exit(EXIT_FAILURE);
  }
  weights[index]=value;
}

double pwc::getParameter(int index){
  if ((index<0) || (index >=N)) {
    cout << "Index out of bounds (" << index << ") sent to the pwc::getParameter() function" << endl;
    exit(EXIT_FAILURE);
  }
  return weights[index];
}

void pwc::getParameters(double* w){
  int i;

  for(i=0; i<N; i++)
    w[i]=weights[i];
 
}
	
void pwc::setParameters(double* w){
  int i;
 
  
  for(i=0; i<N; i++)
    weights[i]=w[i];
}

void pwc::getOrigin(double* orig){
  int i;

  for(i=0; i<Inputs; i++)
    orig[i]=origin[i];
}

void pwc::replaceTraces(const State& s, double replace)
  /*	Replace traces of parameters, activated by input state s to value replace
   */
{
}

void pwc::decayTraces(double factor)
  /*	Decay traces by factor
   */
{
}

void pwc::accumulateTraces(const State& s, double amount)
	/*	Increment traces by amount for parameters activated by input s
	*/
{
}

void pwc::setArchitectureParameters(int argc, char *argv[])
  /*	Loads parameters of the architecture.
			Parameters:
				argc : number of supplied arguments
				argv : array of arguments
		*/
{ 
  //ifstream file(argv[0], ios::nocreate);
  ifstream file(argv[0]);
  if (file.fail()){
    cout << "Can not open file " << argv[0] << endl;
    exit(EXIT_FAILURE);
  }

  char buffer[80];
  char c;
  int i;

  file.get(buffer, strlen("Inputs ")+1);
  file >> Inputs;
  file.get(c);//get endl;
	
  delete [] LeftBounds;
  LeftBounds = new double[Inputs];
  delete [] RightBounds;
  RightBounds = new double[Inputs];
  delete [] n;
  n = new int[Inputs];
  delete [] h;
  h = new double[Inputs];
  delete IndCoef;
  IndCoef = new int[Inputs];
  delete [] origin;
  origin = new double[Inputs];
  

  file.get(buffer, strlen("n: ")+1);
  for (i=0; i<Inputs; i++){
    file >> n[i];
    file.get(c);
    if (file.fail()){
      cout << "Error reading from file " << argv[0] << endl;
      exit(EXIT_FAILURE);
    }
  }
  file.get(c);
	
  file.get(buffer, strlen("h: ")+1);
  for (i=0; i<Inputs; i++){
    file >> h[i];
    file.get(c);
    if (file.fail()){
      cout << "Error reading from file " << argv[0] << endl;
      exit(EXIT_FAILURE);
    }
  }
  file.get(c);

  file.get(buffer, strlen("LeftBounds: ")+1);
  for (i=0; i<Inputs; i++){
    file >> LeftBounds[i];
    file.get(c);
    if (file.fail()){
      cout << "Error reading from file " << argv[0] << endl;
      exit(EXIT_FAILURE);
    }
  }
  file.get(c);

  file.get(buffer, strlen("RightBounds: ")+1);
  for (i=0; i<Inputs; i++){
    file >> RightBounds[i];
    file.get(c);
    if (file.fail()){
      cout << "Error reading from file " << argv[0] << endl;
      exit(EXIT_FAILURE);
    }
  }
  file.get(c);
  BoundsSet=true;

  file.get(buffer, strlen("Origin: ")+1);
  for (i=0; i<Inputs; i++){
    file >> origin[i];
    file.get(c);
    if (file.fail()){
      cout << "Error reading from file " << argv[0] << endl;
      exit(EXIT_FAILURE);
    }
  }
  file.get(c);

  file.get(buffer, strlen("N=")+1);
  file >> N; 
  file.get(c);
  if (file.fail()){
    cout << "Error reading from file " << argv[0] << endl;
    exit(EXIT_FAILURE);
  }

  delete [] weights;
  weights = new double[N];
	
  if (weights==NULL){
    cout << "pwc: Allocation of weights array was not successfull" << endl;
    exit(EXIT_FAILURE);
  }


  for (i=0; i<N; i++){
    file >> weights[i];
    file.get(c);
    if (file.fail()){
      cout << "Error reading from file " << argv[0] << endl;
      exit(EXIT_FAILURE);
    }
  }

  //compute IndCoef
  IndCoef[Inputs-1]=1;
  for (i=Inputs-2; i>=0; i--)
    IndCoef[i]=IndCoef[i+1]*n[i+1];


}
void pwc::saveArchitectureParameters(int argc, char *argv[])
  /*	Saves parameters of the architecture.
			Parameters:
				argc : number of supplied arguments
				argv : array of arguments
		*/
{
	
  ofstream file(argv[0]);
  if (file.fail()){
    cout << "Can not open file " << argv[0] << endl;
    exit(EXIT_FAILURE);
  }

  int i;

  file << "Inputs " << Inputs << endl;

  file << "n: ";
  for (i=0; i<Inputs; i++)
    file << n[i] << " ";
  file << endl;
  if (file.fail()){
    cout << "Error writing to file " << argv[0] << endl;
    exit(EXIT_FAILURE);
  }

  file << "h: ";
  for (i=0; i<Inputs; i++)
    file << h[i] << " ";
  file << endl;
  if (file.fail()){
    cout << "Error writing to file " << argv[0] << endl;
    exit(EXIT_FAILURE);
  }

  file << "LeftBounds: ";
  for (i=0; i<Inputs; i++)
    file << LeftBounds[i] << " ";
  file << endl;
  if (file.fail()){
    cout << "Error writing to file " << argv[0] << endl;
    exit(EXIT_FAILURE);
  }

  file << "RightBounds: ";
  for (i=0; i<Inputs; i++)
    file << RightBounds[i] << " ";
  file << endl;
  if (file.fail()){
    cout << "Error writing to file " << argv[0] << endl;
    exit(EXIT_FAILURE);
  }

  file << "Origin: ";
  for (i=0; i<Inputs; i++)
    file << origin[i] << " ";
  file << endl;
  if (file.fail()){
    cout << "Error writing to file " << argv[0] << endl;
    exit(EXIT_FAILURE);
  }

  file << "N=" << N << endl;
  for (i=0; i<N; i++)
    file << weights[i] << endl;
  if (file.fail()){
    cout << "Error writing to file " << argv[0] << endl;
    exit(EXIT_FAILURE);
  }
  file.close();

	
}

void pwc::setLearningParameters(int argc, char *argv[])
		/*	Sets learning parameters.
			Parameters:
				argc : number of supplied arguments
				argv : array of arguments
		*/
{}
pwc::~pwc(){

  delete [] h;
  delete [] n;
  delete [] IndCoef;
  delete [] LeftBounds;
  delete [] RightBounds;
  delete [] weights;

}

double pwc::discreteSample(double low, double high, int V){
  int low_ind, high_ind, sample_ind;

  if (low>=1){ 
    low_ind=V-1;
  }
  else{
    
    low_ind=(int)(float)(low/(1.0/(double)(V))); 
    if (low_ind == V) low_ind=V-1;
  }
  
  if (high>=1){ 
    high_ind=V-1;
  }
  else{
    high_ind=(int)(float)(high/(1.0/(double)(V)));
    if (high_ind == V) high_ind=V-1;
  }

  sample_ind=low_ind+(rand()%(high_ind-low_ind+1));
  return ((double)(sample_ind)/(double)(V)+1.0/(double)(2*V));
  
}
