#include <stdlib.h>
#include <string.h>
#include<stdio.h>
#include<math.h>
#include<sys/types.h>		
#include<iostream.h>
#include<fstream.h>

#ifndef INTERFACE_CLASSES	
#define INTERFACE_CLASSES 1
#include "interface_classes.h"
#endif

class pwc : public Approximator{
	
 private:
  
  int Inputs;
  int N;		//total number of tiles
  double* h;	//size of tiles along each dimension
  int* n;		//number of tiles along each dimension
  double* origin; //coordinates of the lower left corner of the discretization lattice
  double* LeftBounds; //left bounds of input variables
  double* RightBounds;//right bound of input variables
  bool BoundsSet;	//indicates if bounds have been set
  int* IndCoef;	//coefficients used to calculate 
  //index of a tile in the one-dimensional array of tiles
  double* weights;


 public:

  pwc();

  pwc(int in, double* left, double* right, int* nn, double weightLow, double weightHigh, double* orig=NULL, int DiscreteValues=0);

  void weightInterval(const Subset& in, double left, double right,int DiscreteValues=0);
  /*	Randomly generates weights for some subsets of input space in
	specified interval
	Parameters:
	in	:	subset of the input space as a hypercub 
	left	:	left limit of the weights
	right	:	right  limit of the weights
  */

  int getSize();
  /*	Return the number of parameters in this architecture
   */

  void predict(const State& s, double& output);
  /*	Predicts an output value for a given input.
	Parameters:
	s : reference to the input (state)
	output : returned value of the predicted output
  */
  void learn(const State& s, const double target);
  /*	Learns an input-output pair.
	Parameters:
	s : input (state)
	target: target output value
  */

  void computeGradient(const State& s, double* GradientVector);
  /*	Compute the gradient w.r.t. architecture parameters at the current parameters' values and input s
   */

  void updateParameters(double* delta);
  /*	Update parameters by amounts in delta array
   */

  void setParameter(int index, double value);
  /* Set parameter with "index" in the array of parameters to "value"
   */

  double getParameter(int index);

  void getParameters(double* w);
	
  void setParameters(double* w);

  void getOrigin(double* orig);

  void replaceTraces(const State& s, double replace);
  /*	Replace traces of parameters, activated by input state s to value replace
   */

  void decayTraces(double factor);
  /*	Decay traces by factor
   */

  void accumulateTraces(const State& s, double amount);
  /*	Increment traces by amount for parameters activated by input s
   */

  void setArchitectureParameters(int argc, char *argv[]);
  /*	Loads parameters of the architecture.
	Parameters:
	argc : number of supplied arguments
	argv : array of arguments
  */
  void saveArchitectureParameters(int argc, char *argv[]);
  /*	Saves parameters of the architecture.
	Parameters:
	argc : number of supplied arguments
	argv : array of arguments
  */
  void setLearningParameters(int argc, char *argv[]);
  /*	Sets learning parameters.
	Parameters:
	argc : number of supplied arguments
	argv : array of arguments
  */
  ~pwc();

 protected:

  double discreteSample(double low, double high, int V);
  /* Returns a random value that corresponds to discrete points - middles of the discretization intervals - and that lies in one of the intervals between those where low and high fall
   */
};
